@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.aws.lb.kotlin.outputs.LoadBalancerAccessLogs
import com.pulumi.aws.lb.kotlin.outputs.LoadBalancerConnectionLogs
import com.pulumi.aws.lb.kotlin.outputs.LoadBalancerSubnetMapping
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.lb.kotlin.outputs.LoadBalancerAccessLogs.Companion.toKotlin as loadBalancerAccessLogsToKotlin
import com.pulumi.aws.lb.kotlin.outputs.LoadBalancerConnectionLogs.Companion.toKotlin as loadBalancerConnectionLogsToKotlin
import com.pulumi.aws.lb.kotlin.outputs.LoadBalancerSubnetMapping.Companion.toKotlin as loadBalancerSubnetMappingToKotlin

/**
 * Builder for [LoadBalancer].
 */
@PulumiTagMarker
public class LoadBalancerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerArgs = LoadBalancerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerArgsBuilder.() -> Unit) {
        val builder = LoadBalancerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancer {
        val builtJavaResource = com.pulumi.aws.lb.LoadBalancer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoadBalancer(builtJavaResource)
    }
}

/**
 * Provides a Load Balancer resource.
 * > **Note:** `aws.alb.LoadBalancer` is known as `aws.lb.LoadBalancer`. The functionality is identical.
 * ## Example Usage
 * ### Application Load Balancer
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lb.LoadBalancer("test", {
 *     name: "test-lb-tf",
 *     internal: false,
 *     loadBalancerType: "application",
 *     securityGroups: [lbSg&#46;id],
 *     subnets: .map(subnet => (subnet.id)),
 *     enableDeletionProtection: true,
 *     accessLogs: {
 *         bucket: lbLogs.id,
 *         prefix: "test-lb",
 *         enabled: true,
 *     },
 *     tags: {
 *         Environment: "production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lb.LoadBalancer("test",
 *     name="test-lb-tf",
 *     internal=False,
 *     load_balancer_type="application",
 *     security_groups=[lb_sg["id"]],
 *     subnets=[subnet["id"] for subnet in public],
 *     enable_deletion_protection=True,
 *     access_logs={
 *         "bucket": lb_logs["id"],
 *         "prefix": "test-lb",
 *         "enabled": True,
 *     },
 *     tags={
 *         "Environment": "production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LB.LoadBalancer("test", new()
 *     {
 *         Name = "test-lb-tf",
 *         Internal = false,
 *         LoadBalancerType = "application",
 *         SecurityGroups = new[]
 *         {
 *             lbSg.Id,
 *         },
 *         Subnets = .Select(subnet =>
 *         {
 *             return subnet.Id;
 *         }).ToList(),
 *         EnableDeletionProtection = true,
 *         AccessLogs = new Aws.LB.Inputs.LoadBalancerAccessLogsArgs
 *         {
 *             Bucket = lbLogs.Id,
 *             Prefix = "test-lb",
 *             Enabled = true,
 *         },
 *         Tags =
 *         {
 *             { "Environment", "production" },
 *         },
 *     });
 * });
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Network Load Balancer
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lb.LoadBalancer("test", {
 *     name: "test-lb-tf",
 *     internal: false,
 *     loadBalancerType: "network",
 *     subnets: .map(subnet => (subnet.id)),
 *     enableDeletionProtection: true,
 *     tags: {
 *         Environment: "production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lb.LoadBalancer("test",
 *     name="test-lb-tf",
 *     internal=False,
 *     load_balancer_type="network",
 *     subnets=[subnet["id"] for subnet in public],
 *     enable_deletion_protection=True,
 *     tags={
 *         "Environment": "production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LB.LoadBalancer("test", new()
 *     {
 *         Name = "test-lb-tf",
 *         Internal = false,
 *         LoadBalancerType = "network",
 *         Subnets = .Select(subnet =>
 *         {
 *             return subnet.Id;
 *         }).ToList(),
 *         EnableDeletionProtection = true,
 *         Tags =
 *         {
 *             { "Environment", "production" },
 *         },
 *     });
 * });
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Specifying Elastic IPs
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lb.LoadBalancer("example", {
 *     name: "example",
 *     loadBalancerType: "network",
 *     subnetMappings: [
 *         {
 *             subnetId: example1AwsSubnet.id,
 *             allocationId: example1.id,
 *         },
 *         {
 *             subnetId: example2AwsSubnet.id,
 *             allocationId: example2.id,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lb.LoadBalancer("example",
 *     name="example",
 *     load_balancer_type="network",
 *     subnet_mappings=[
 *         {
 *             "subnet_id": example1_aws_subnet["id"],
 *             "allocation_id": example1["id"],
 *         },
 *         {
 *             "subnet_id": example2_aws_subnet["id"],
 *             "allocation_id": example2["id"],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LB.LoadBalancer("example", new()
 *     {
 *         Name = "example",
 *         LoadBalancerType = "network",
 *         SubnetMappings = new[]
 *         {
 *             new Aws.LB.Inputs.LoadBalancerSubnetMappingArgs
 *             {
 *                 SubnetId = example1AwsSubnet.Id,
 *                 AllocationId = example1.Id,
 *             },
 *             new Aws.LB.Inputs.LoadBalancerSubnetMappingArgs
 *             {
 *                 SubnetId = example2AwsSubnet.Id,
 *                 AllocationId = example2.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lb.NewLoadBalancer(ctx, "example", &lb.LoadBalancerArgs{
 * 			Name:             pulumi.String("example"),
 * 			LoadBalancerType: pulumi.String("network"),
 * 			SubnetMappings: lb.LoadBalancerSubnetMappingArray{
 * 				&lb.LoadBalancerSubnetMappingArgs{
 * 					SubnetId:     pulumi.Any(example1AwsSubnet.Id),
 * 					AllocationId: pulumi.Any(example1.Id),
 * 				},
 * 				&lb.LoadBalancerSubnetMappingArgs{
 * 					SubnetId:     pulumi.Any(example2AwsSubnet.Id),
 * 					AllocationId: pulumi.Any(example2.Id),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.LoadBalancerArgs;
 * import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoadBalancer("example", LoadBalancerArgs.builder()
 *             .name("example")
 *             .loadBalancerType("network")
 *             .subnetMappings(
 *                 LoadBalancerSubnetMappingArgs.builder()
 *                     .subnetId(example1AwsSubnet.id())
 *                     .allocationId(example1.id())
 *                     .build(),
 *                 LoadBalancerSubnetMappingArgs.builder()
 *                     .subnetId(example2AwsSubnet.id())
 *                     .allocationId(example2.id())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lb:LoadBalancer
 *     properties:
 *       name: example
 *       loadBalancerType: network
 *       subnetMappings:
 *         - subnetId: ${example1AwsSubnet.id}
 *           allocationId: ${example1.id}
 *         - subnetId: ${example2AwsSubnet.id}
 *           allocationId: ${example2.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Specifying private IP addresses for an internal-facing load balancer
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lb.LoadBalancer("example", {
 *     name: "example",
 *     loadBalancerType: "network",
 *     subnetMappings: [
 *         {
 *             subnetId: example1.id,
 *             privateIpv4Address: "10.0.1.15",
 *         },
 *         {
 *             subnetId: example2.id,
 *             privateIpv4Address: "10.0.2.15",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lb.LoadBalancer("example",
 *     name="example",
 *     load_balancer_type="network",
 *     subnet_mappings=[
 *         {
 *             "subnet_id": example1["id"],
 *             "private_ipv4_address": "10.0.1.15",
 *         },
 *         {
 *             "subnet_id": example2["id"],
 *             "private_ipv4_address": "10.0.2.15",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.LB.LoadBalancer("example", new()
 *     {
 *         Name = "example",
 *         LoadBalancerType = "network",
 *         SubnetMappings = new[]
 *         {
 *             new Aws.LB.Inputs.LoadBalancerSubnetMappingArgs
 *             {
 *                 SubnetId = example1.Id,
 *                 PrivateIpv4Address = "10.0.1.15",
 *             },
 *             new Aws.LB.Inputs.LoadBalancerSubnetMappingArgs
 *             {
 *                 SubnetId = example2.Id,
 *                 PrivateIpv4Address = "10.0.2.15",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lb.NewLoadBalancer(ctx, "example", &lb.LoadBalancerArgs{
 * 			Name:             pulumi.String("example"),
 * 			LoadBalancerType: pulumi.String("network"),
 * 			SubnetMappings: lb.LoadBalancerSubnetMappingArray{
 * 				&lb.LoadBalancerSubnetMappingArgs{
 * 					SubnetId:           pulumi.Any(example1.Id),
 * 					PrivateIpv4Address: pulumi.String("10.0.1.15"),
 * 				},
 * 				&lb.LoadBalancerSubnetMappingArgs{
 * 					SubnetId:           pulumi.Any(example2.Id),
 * 					PrivateIpv4Address: pulumi.String("10.0.2.15"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.LoadBalancer;
 * import com.pulumi.aws.lb.LoadBalancerArgs;
 * import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LoadBalancer("example", LoadBalancerArgs.builder()
 *             .name("example")
 *             .loadBalancerType("network")
 *             .subnetMappings(
 *                 LoadBalancerSubnetMappingArgs.builder()
 *                     .subnetId(example1.id())
 *                     .privateIpv4Address("10.0.1.15")
 *                     .build(),
 *                 LoadBalancerSubnetMappingArgs.builder()
 *                     .subnetId(example2.id())
 *                     .privateIpv4Address("10.0.2.15")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lb:LoadBalancer
 *     properties:
 *       name: example
 *       loadBalancerType: network
 *       subnetMappings:
 *         - subnetId: ${example1.id}
 *           privateIpv4Address: 10.0.1.15
 *         - subnetId: ${example2.id}
 *           privateIpv4Address: 10.0.2.15
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import LBs using their ARN. For example:
 * ```sh
 * $ pulumi import aws:lb/loadBalancer:LoadBalancer bar arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188
 * ```
 */
public class LoadBalancer internal constructor(
    override val javaResource: com.pulumi.aws.lb.LoadBalancer,
) : KotlinCustomResource(javaResource, LoadBalancerMapper) {
    /**
     * Access Logs block. See below.
     */
    public val accessLogs: Output<LoadBalancerAccessLogs>?
        get() = javaResource.accessLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loadBalancerAccessLogsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * ARN of the load balancer (matches `id`).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN suffix for use with CloudWatch Metrics.
     */
    public val arnSuffix: Output<String>
        get() = javaResource.arnSuffix().applyValue({ args0 -> args0 })

    /**
     * Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
     */
    public val clientKeepAlive: Output<Int>?
        get() = javaResource.clientKeepAlive().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Connection Logs block. See below. Only valid for Load Balancers of type `application`.
     */
    public val connectionLogs: Output<LoadBalancerConnectionLogs>?
        get() = javaResource.connectionLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> loadBalancerConnectionLogsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * ID of the customer owned ipv4 pool to use for this load balancer.
     */
    public val customerOwnedIpv4Pool: Output<String>?
        get() = javaResource.customerOwnedIpv4Pool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     */
    public val desyncMitigationMode: Output<String>?
        get() = javaResource.desyncMitigationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DNS name of the load balancer.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * How traffic is distributed among the load balancer Availability Zones. Possible values are `any_availability_zone` (default), `availability_zone_affinity`, or `partial_availability_zone_affinity`. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for `network` type load balancers.
     */
    public val dnsRecordClientRoutingPolicy: Output<String>?
        get() = javaResource.dnsRecordClientRoutingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type `application`.
     */
    public val dropInvalidHeaderFields: Output<Boolean>?
        get() = javaResource.dropInvalidHeaderFields().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, cross-zone load balancing of the load balancer will be enabled. For `network` and `gateway` type load balancers, this feature is disabled by default (`false`). For `application` load balancer this feature is always enabled (`true`) and cannot be disabled. Defaults to `false`.
     */
    public val enableCrossZoneLoadBalancing: Output<Boolean>?
        get() = javaResource.enableCrossZoneLoadBalancing().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to `false`.
     */
    public val enableDeletionProtection: Output<Boolean>?
        get() = javaResource.enableDeletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether HTTP/2 is enabled in `application` load balancers. Defaults to `true`.
     */
    public val enableHttp2: Output<Boolean>?
        get() = javaResource.enableHttp2().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type `application`. Defaults to `false`
     */
    public val enableTlsVersionAndCipherSuiteHeaders: Output<Boolean>?
        get() = javaResource.enableTlsVersionAndCipherSuiteHeaders().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to `false`.
     */
    public val enableWafFailOpen: Output<Boolean>?
        get() = javaResource.enableWafFailOpen().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in `application` load balancers. Defaults to `false`.
     */
    public val enableXffClientPort: Output<Boolean>?
        get() = javaResource.enableXffClientPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type `network`. The possible values are `on` and `off`.
     */
    public val enforceSecurityGroupInboundRulesOnPrivateLinkTraffic: Output<String>
        get() = javaResource.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic().applyValue({ args0 ->
            args0
        })

    /**
     * Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type `application`. Default: 60.
     */
    public val idleTimeout: Output<Int>?
        get() = javaResource.idleTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, the LB will be internal. Defaults to `false`.
     */
    public val `internal`: Output<Boolean>
        get() = javaResource.`internal`().applyValue({ args0 -> args0 })

    /**
     * Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: `ipv4` (all load balancer types), `dualstack` (all load balancer types), and `dualstack-without-public-ipv4` (type `application` only).
     */
    public val ipAddressType: Output<String>
        get() = javaResource.ipAddressType().applyValue({ args0 -> args0 })

    /**
     * Type of load balancer to create. Possible values are `application`, `gateway`, or `network`. The default value is `application`.
     */
    public val loadBalancerType: Output<String>?
        get() = javaResource.loadBalancerType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to `false`.
     */
    public val preserveHostHeader: Output<Boolean>?
        get() = javaResource.preserveHostHeader().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of security group IDs to assign to the LB. Only valid for Load Balancers of type `application` or `network`. For load balancers of type `network` security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Subnet mapping block. See below. For Load Balancers of type `network` subnet mappings can only be added.
     */
    public val subnetMappings: Output<List<LoadBalancerSubnetMapping>>
        get() = javaResource.subnetMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> loadBalancerSubnetMappingToKotlin(args0) })
            })
        })

    /**
     * List of subnet IDs to attach to the LB. For Load Balancers of type `network` subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type `network` will force a recreation of the resource.
     */
    public val subnets: Output<List<String>>
        get() = javaResource.subnets().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are `append`, `preserve`, and `remove`. Only valid for Load Balancers of type `application`. The default is `append`.
     */
    public val xffHeaderProcessingMode: Output<String>?
        get() = javaResource.xffHeaderProcessingMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Canonical hosted zone ID of the load balancer (to be used in a Route 53 Alias record).
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object LoadBalancerMapper : ResourceMapper<LoadBalancer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lb.LoadBalancer::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancer = LoadBalancer(
        javaResource as
            com.pulumi.aws.lb.LoadBalancer,
    )
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancer].
 */
public suspend fun loadBalancer(
    name: String,
    block: suspend LoadBalancerResourceBuilder.() -> Unit,
): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancer(name: String): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    return builder.build()
}
