@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.aws.lb.kotlin.outputs.TargetGroupHealthCheck
import com.pulumi.aws.lb.kotlin.outputs.TargetGroupStickiness
import com.pulumi.aws.lb.kotlin.outputs.TargetGroupTargetFailover
import com.pulumi.aws.lb.kotlin.outputs.TargetGroupTargetGroupHealth
import com.pulumi.aws.lb.kotlin.outputs.TargetGroupTargetHealthState
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.lb.kotlin.outputs.TargetGroupHealthCheck.Companion.toKotlin as targetGroupHealthCheckToKotlin
import com.pulumi.aws.lb.kotlin.outputs.TargetGroupStickiness.Companion.toKotlin as targetGroupStickinessToKotlin
import com.pulumi.aws.lb.kotlin.outputs.TargetGroupTargetFailover.Companion.toKotlin as targetGroupTargetFailoverToKotlin
import com.pulumi.aws.lb.kotlin.outputs.TargetGroupTargetGroupHealth.Companion.toKotlin as targetGroupTargetGroupHealthToKotlin
import com.pulumi.aws.lb.kotlin.outputs.TargetGroupTargetHealthState.Companion.toKotlin as targetGroupTargetHealthStateToKotlin

/**
 * Builder for [TargetGroup].
 */
@PulumiTagMarker
public class TargetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TargetGroupArgs = TargetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TargetGroupArgsBuilder.() -> Unit) {
        val builder = TargetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TargetGroup {
        val builtJavaResource = com.pulumi.aws.lb.TargetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TargetGroup(builtJavaResource)
    }
}

/**
 * Provides a Target Group resource for use with Load Balancer resources.
 * > **Note:** `aws.alb.TargetGroup` is known as `aws.lb.TargetGroup`. The functionality is identical.
 * ## Example Usage
 * ### Instance Target Group
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * const test = new aws.lb.TargetGroup("test", {
 *     name: "tf-example-lb-tg",
 *     port: 80,
 *     protocol: "HTTP",
 *     vpcId: main.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * test = aws.lb.TargetGroup("test",
 *     name="tf-example-lb-tg",
 *     port=80,
 *     protocol="HTTP",
 *     vpc_id=main.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var test = new Aws.LB.TargetGroup("test", new()
 *     {
 *         Name = "tf-example-lb-tg",
 *         Port = 80,
 *         Protocol = "HTTP",
 *         VpcId = main.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lb.NewTargetGroup(ctx, "test", &lb.TargetGroupArgs{
 * 			Name:     pulumi.String("tf-example-lb-tg"),
 * 			Port:     pulumi.Int(80),
 * 			Protocol: pulumi.String("HTTP"),
 * 			VpcId:    main.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var test = new TargetGroup("test", TargetGroupArgs.builder()
 *             .name("tf-example-lb-tg")
 *             .port(80)
 *             .protocol("HTTP")
 *             .vpcId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lb:TargetGroup
 *     properties:
 *       name: tf-example-lb-tg
 *       port: 80
 *       protocol: HTTP
 *       vpcId: ${main.id}
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 * ```
 * <!--End PulumiCodeChooser -->
 * ### IP Target Group
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
 * const ip_example = new aws.lb.TargetGroup("ip-example", {
 *     name: "tf-example-lb-tg",
 *     port: 80,
 *     protocol: "HTTP",
 *     targetType: "ip",
 *     vpcId: main.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
 * ip_example = aws.lb.TargetGroup("ip-example",
 *     name="tf-example-lb-tg",
 *     port=80,
 *     protocol="HTTP",
 *     target_type="ip",
 *     vpc_id=main.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var main = new Aws.Ec2.Vpc("main", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var ip_example = new Aws.LB.TargetGroup("ip-example", new()
 *     {
 *         Name = "tf-example-lb-tg",
 *         Port = 80,
 *         Protocol = "HTTP",
 *         TargetType = "ip",
 *         VpcId = main.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lb.NewTargetGroup(ctx, "ip-example", &lb.TargetGroupArgs{
 * 			Name:       pulumi.String("tf-example-lb-tg"),
 * 			Port:       pulumi.Int(80),
 * 			Protocol:   pulumi.String("HTTP"),
 * 			TargetType: pulumi.String("ip"),
 * 			VpcId:      main.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var ip_example = new TargetGroup("ip-example", TargetGroupArgs.builder()
 *             .name("tf-example-lb-tg")
 *             .port(80)
 *             .protocol("HTTP")
 *             .targetType("ip")
 *             .vpcId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ip-example:
 *     type: aws:lb:TargetGroup
 *     properties:
 *       name: tf-example-lb-tg
 *       port: 80
 *       protocol: HTTP
 *       targetType: ip
 *       vpcId: ${main.id}
 *   main:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Lambda Target Group
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const lambda_example = new aws.lb.TargetGroup("lambda-example", {
 *     name: "tf-example-lb-tg",
 *     targetType: "lambda",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * lambda_example = aws.lb.TargetGroup("lambda-example",
 *     name="tf-example-lb-tg",
 *     target_type="lambda")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lambda_example = new Aws.LB.TargetGroup("lambda-example", new()
 *     {
 *         Name = "tf-example-lb-tg",
 *         TargetType = "lambda",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lb.NewTargetGroup(ctx, "lambda-example", &lb.TargetGroupArgs{
 * 			Name:       pulumi.String("tf-example-lb-tg"),
 * 			TargetType: pulumi.String("lambda"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lambda_example = new TargetGroup("lambda-example", TargetGroupArgs.builder()
 *             .name("tf-example-lb-tg")
 *             .targetType("lambda")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lambda-example:
 *     type: aws:lb:TargetGroup
 *     properties:
 *       name: tf-example-lb-tg
 *       targetType: lambda
 * ```
 * <!--End PulumiCodeChooser -->
 * ### ALB Target Group
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const alb_example = new aws.lb.TargetGroup("alb-example", {
 *     name: "tf-example-lb-alb-tg",
 *     targetType: "alb",
 *     port: 80,
 *     protocol: "TCP",
 *     vpcId: main.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * alb_example = aws.lb.TargetGroup("alb-example",
 *     name="tf-example-lb-alb-tg",
 *     target_type="alb",
 *     port=80,
 *     protocol="TCP",
 *     vpc_id=main["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var alb_example = new Aws.LB.TargetGroup("alb-example", new()
 *     {
 *         Name = "tf-example-lb-alb-tg",
 *         TargetType = "alb",
 *         Port = 80,
 *         Protocol = "TCP",
 *         VpcId = main.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lb.NewTargetGroup(ctx, "alb-example", &lb.TargetGroupArgs{
 * 			Name:       pulumi.String("tf-example-lb-alb-tg"),
 * 			TargetType: pulumi.String("alb"),
 * 			Port:       pulumi.Int(80),
 * 			Protocol:   pulumi.String("TCP"),
 * 			VpcId:      pulumi.Any(main.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alb_example = new TargetGroup("alb-example", TargetGroupArgs.builder()
 *             .name("tf-example-lb-alb-tg")
 *             .targetType("alb")
 *             .port(80)
 *             .protocol("TCP")
 *             .vpcId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   alb-example:
 *     type: aws:lb:TargetGroup
 *     properties:
 *       name: tf-example-lb-alb-tg
 *       targetType: alb
 *       port: 80
 *       protocol: TCP
 *       vpcId: ${main.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Target group with unhealthy connection termination disabled
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const tcp_example = new aws.lb.TargetGroup("tcp-example", {
 *     name: "tf-example-lb-nlb-tg",
 *     port: 25,
 *     protocol: "TCP",
 *     vpcId: main.id,
 *     targetHealthStates: [{
 *         enableUnhealthyConnectionTermination: false,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * tcp_example = aws.lb.TargetGroup("tcp-example",
 *     name="tf-example-lb-nlb-tg",
 *     port=25,
 *     protocol="TCP",
 *     vpc_id=main["id"],
 *     target_health_states=[{
 *         "enable_unhealthy_connection_termination": False,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tcp_example = new Aws.LB.TargetGroup("tcp-example", new()
 *     {
 *         Name = "tf-example-lb-nlb-tg",
 *         Port = 25,
 *         Protocol = "TCP",
 *         VpcId = main.Id,
 *         TargetHealthStates = new[]
 *         {
 *             new Aws.LB.Inputs.TargetGroupTargetHealthStateArgs
 *             {
 *                 EnableUnhealthyConnectionTermination = false,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lb.NewTargetGroup(ctx, "tcp-example", &lb.TargetGroupArgs{
 * 			Name:     pulumi.String("tf-example-lb-nlb-tg"),
 * 			Port:     pulumi.Int(25),
 * 			Protocol: pulumi.String("TCP"),
 * 			VpcId:    pulumi.Any(main.Id),
 * 			TargetHealthStates: lb.TargetGroupTargetHealthStateArray{
 * 				&lb.TargetGroupTargetHealthStateArgs{
 * 					EnableUnhealthyConnectionTermination: pulumi.Bool(false),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import com.pulumi.aws.lb.inputs.TargetGroupTargetHealthStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tcp_example = new TargetGroup("tcp-example", TargetGroupArgs.builder()
 *             .name("tf-example-lb-nlb-tg")
 *             .port(25)
 *             .protocol("TCP")
 *             .vpcId(main.id())
 *             .targetHealthStates(TargetGroupTargetHealthStateArgs.builder()
 *                 .enableUnhealthyConnectionTermination(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   tcp-example:
 *     type: aws:lb:TargetGroup
 *     properties:
 *       name: tf-example-lb-nlb-tg
 *       port: 25
 *       protocol: TCP
 *       vpcId: ${main.id}
 *       targetHealthStates:
 *         - enableUnhealthyConnectionTermination: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Target group with health requirements
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const tcp_example = new aws.lb.TargetGroup("tcp-example", {
 *     name: "tf-example-lb-nlb-tg",
 *     port: 80,
 *     protocol: "TCP",
 *     vpcId: main.id,
 *     targetGroupHealth: {
 *         dnsFailover: {
 *             minimumHealthyTargetsCount: "1",
 *             minimumHealthyTargetsPercentage: "off",
 *         },
 *         unhealthyStateRouting: {
 *             minimumHealthyTargetsCount: 1,
 *             minimumHealthyTargetsPercentage: "off",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * tcp_example = aws.lb.TargetGroup("tcp-example",
 *     name="tf-example-lb-nlb-tg",
 *     port=80,
 *     protocol="TCP",
 *     vpc_id=main["id"],
 *     target_group_health={
 *         "dns_failover": {
 *             "minimum_healthy_targets_count": "1",
 *             "minimum_healthy_targets_percentage": "off",
 *         },
 *         "unhealthy_state_routing": {
 *             "minimum_healthy_targets_count": 1,
 *             "minimum_healthy_targets_percentage": "off",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tcp_example = new Aws.LB.TargetGroup("tcp-example", new()
 *     {
 *         Name = "tf-example-lb-nlb-tg",
 *         Port = 80,
 *         Protocol = "TCP",
 *         VpcId = main.Id,
 *         TargetGroupHealth = new Aws.LB.Inputs.TargetGroupTargetGroupHealthArgs
 *         {
 *             DnsFailover = new Aws.LB.Inputs.TargetGroupTargetGroupHealthDnsFailoverArgs
 *             {
 *                 MinimumHealthyTargetsCount = "1",
 *                 MinimumHealthyTargetsPercentage = "off",
 *             },
 *             UnhealthyStateRouting = new Aws.LB.Inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs
 *             {
 *                 MinimumHealthyTargetsCount = 1,
 *                 MinimumHealthyTargetsPercentage = "off",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lb.NewTargetGroup(ctx, "tcp-example", &lb.TargetGroupArgs{
 * 			Name:     pulumi.String("tf-example-lb-nlb-tg"),
 * 			Port:     pulumi.Int(80),
 * 			Protocol: pulumi.String("TCP"),
 * 			VpcId:    pulumi.Any(main.Id),
 * 			TargetGroupHealth: &lb.TargetGroupTargetGroupHealthArgs{
 * 				DnsFailover: &lb.TargetGroupTargetGroupHealthDnsFailoverArgs{
 * 					MinimumHealthyTargetsCount:      pulumi.String("1"),
 * 					MinimumHealthyTargetsPercentage: pulumi.String("off"),
 * 				},
 * 				UnhealthyStateRouting: &lb.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs{
 * 					MinimumHealthyTargetsCount:      pulumi.Int(1),
 * 					MinimumHealthyTargetsPercentage: pulumi.String("off"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TargetGroup;
 * import com.pulumi.aws.lb.TargetGroupArgs;
 * import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthArgs;
 * import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthDnsFailoverArgs;
 * import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tcp_example = new TargetGroup("tcp-example", TargetGroupArgs.builder()
 *             .name("tf-example-lb-nlb-tg")
 *             .port(80)
 *             .protocol("TCP")
 *             .vpcId(main.id())
 *             .targetGroupHealth(TargetGroupTargetGroupHealthArgs.builder()
 *                 .dnsFailover(TargetGroupTargetGroupHealthDnsFailoverArgs.builder()
 *                     .minimumHealthyTargetsCount("1")
 *                     .minimumHealthyTargetsPercentage("off")
 *                     .build())
 *                 .unhealthyStateRouting(TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs.builder()
 *                     .minimumHealthyTargetsCount("1")
 *                     .minimumHealthyTargetsPercentage("off")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   tcp-example:
 *     type: aws:lb:TargetGroup
 *     properties:
 *       name: tf-example-lb-nlb-tg
 *       port: 80
 *       protocol: TCP
 *       vpcId: ${main.id}
 *       targetGroupHealth:
 *         dnsFailover:
 *           minimumHealthyTargetsCount: '1'
 *           minimumHealthyTargetsPercentage: off
 *         unhealthyStateRouting:
 *           minimumHealthyTargetsCount: '1'
 *           minimumHealthyTargetsPercentage: off
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Target Groups using their ARN. For example:
 * ```sh
 * $ pulumi import aws:lb/targetGroup:TargetGroup app_front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:targetgroup/app-front-end/20cfe21448b66314
 * ```
 */
public class TargetGroup internal constructor(
    override val javaResource: com.pulumi.aws.lb.TargetGroup,
) : KotlinCustomResource(javaResource, TargetGroupMapper) {
    /**
     * ARN of the Target Group (matches `id`).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN suffix for use with CloudWatch Metrics.
     */
    public val arnSuffix: Output<String>
        get() = javaResource.arnSuffix().applyValue({ args0 -> args0 })

    /**
     * Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is `false`.
     */
    public val connectionTermination: Output<Boolean>
        get() = javaResource.connectionTermination().applyValue({ args0 -> args0 })

    /**
     * Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
     */
    public val deregistrationDelay: Output<Int>?
        get() = javaResource.deregistrationDelay().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Health Check configuration block. Detailed below.
     */
    public val healthCheck: Output<TargetGroupHealthCheck>
        get() = javaResource.healthCheck().applyValue({ args0 ->
            args0.let({ args0 ->
                targetGroupHealthCheckToKotlin(args0)
            })
        })

    /**
     * The type of IP addresses used by the target group, only supported when target type is set to `ip`. Possible values are `ipv4` or `ipv6`.
     */
    public val ipAddressType: Output<String>
        get() = javaResource.ipAddressType().applyValue({ args0 -> args0 })

    /**
     * Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when `target_type` is `lambda`. Default is `false`.
     */
    public val lambdaMultiValueHeadersEnabled: Output<Boolean>?
        get() = javaResource.lambdaMultiValueHeadersEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARNs of the Load Balancers associated with the Target Group.
     */
    public val loadBalancerArns: Output<List<String>>
        get() = javaResource.loadBalancerArns().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is `round_robin`, `least_outstanding_requests`, or `weighted_random`. The default is `round_robin`.
     */
    public val loadBalancingAlgorithmType: Output<String>
        get() = javaResource.loadBalancingAlgorithmType().applyValue({ args0 -> args0 })

    /**
     * Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the `weighted_random` load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
     */
    public val loadBalancingAnomalyMitigation: Output<String>
        get() = javaResource.loadBalancingAnomalyMitigation().applyValue({ args0 -> args0 })

    /**
     * Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `"use_load_balancer_configuration"`. The default is `"use_load_balancer_configuration"`.
     */
    public val loadBalancingCrossZoneEnabled: Output<String>
        get() = javaResource.loadBalancingCrossZoneEnabled().applyValue({ args0 -> args0 })

    /**
     * Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Port on which targets receive traffic, unless overridden when registering a specific target. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
     */
    public val preserveClientIp: Output<String>
        get() = javaResource.preserveClientIp().applyValue({ args0 -> args0 })

    /**
     * Protocol to use for routing traffic to the targets.
     * Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
     * Required when `target_type` is `instance`, `ip`, or `alb`.
     * Does not apply when `target_type` is `lambda`.
     */
    public val protocol: Output<String>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Only applicable when `protocol` is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
     */
    public val protocolVersion: Output<String>
        get() = javaResource.protocolVersion().applyValue({ args0 -> args0 })

    /**
     * Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is `false`.
     */
    public val proxyProtocolV2: Output<Boolean>?
        get() = javaResource.proxyProtocolV2().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
     */
    public val slowStart: Output<Int>?
        get() = javaResource.slowStart().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Stickiness configuration block. Detailed below.
     */
    public val stickiness: Output<TargetGroupStickiness>
        get() = javaResource.stickiness().applyValue({ args0 ->
            args0.let({ args0 ->
                targetGroupStickinessToKotlin(args0)
            })
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Target failover block. Only applicable for Gateway Load Balancer target groups. See target_failover for more information.
     */
    public val targetFailovers: Output<List<TargetGroupTargetFailover>>
        get() = javaResource.targetFailovers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> targetGroupTargetFailoverToKotlin(args0) })
            })
        })

    /**
     * Target health requirements block. See target_group_health for more information.
     */
    public val targetGroupHealth: Output<TargetGroupTargetGroupHealth>
        get() = javaResource.targetGroupHealth().applyValue({ args0 ->
            args0.let({ args0 ->
                targetGroupTargetGroupHealthToKotlin(args0)
            })
        })

    /**
     * Target health state block. Only applicable for Network Load Balancer target groups when `protocol` is `TCP` or `TLS`. See target_health_state for more information.
     */
    public val targetHealthStates: Output<List<TargetGroupTargetHealthState>>
        get() = javaResource.targetHealthStates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> targetGroupTargetHealthStateToKotlin(args0) })
            })
        })

    /**
     * Type of target that you must specify when registering targets with this target group.
     * See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
     * The default is `instance`.
     * Note that you can't specify targets for a target group using both instance IDs and IP addresses.
     * If the target type is `ip`, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
     * Network Load Balancers do not support the `lambda` target type.
     * Application Load Balancers do not support the `alb` target type.
     */
    public val targetType: Output<String>?
        get() = javaResource.targetType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the VPC in which to create the target group. Required when `target_type` is `instance`, `ip` or `alb`. Does not apply when `target_type` is `lambda`.
     */
    public val vpcId: Output<String>?
        get() = javaResource.vpcId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object TargetGroupMapper : ResourceMapper<TargetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lb.TargetGroup::class == javaResource::class

    override fun map(javaResource: Resource): TargetGroup = TargetGroup(
        javaResource as
            com.pulumi.aws.lb.TargetGroup,
    )
}

/**
 * @see [TargetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TargetGroup].
 */
public suspend fun targetGroup(name: String, block: suspend TargetGroupResourceBuilder.() -> Unit): TargetGroup {
    val builder = TargetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TargetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun targetGroup(name: String): TargetGroup {
    val builder = TargetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
