@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TrustStore].
 */
@PulumiTagMarker
public class TrustStoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrustStoreArgs = TrustStoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrustStoreArgsBuilder.() -> Unit) {
        val builder = TrustStoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrustStore {
        val builtJavaResource = com.pulumi.aws.lb.TrustStore(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrustStore(builtJavaResource)
    }
}

/**
 * Provides a ELBv2 Trust Store for use with Application Load Balancer Listener resources.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import Target Groups using their ARN. For example:
 * ```sh
 * $ pulumi import aws:lb/trustStore:TrustStore example arn:aws:elasticloadbalancing:us-west-2:187416307283:truststore/my-trust-store/20cfe21448b66314
 * ```
 */
public class TrustStore internal constructor(
    override val javaResource: com.pulumi.aws.lb.TrustStore,
) : KotlinCustomResource(javaResource, TrustStoreMapper) {
    /**
     * ARN of the Trust Store (matches `id`).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN suffix for use with CloudWatch Metrics.
     */
    public val arnSuffix: Output<String>
        get() = javaResource.arnSuffix().applyValue({ args0 -> args0 })

    /**
     * S3 Bucket name holding the client certificate CA bundle.
     */
    public val caCertificatesBundleS3Bucket: Output<String>
        get() = javaResource.caCertificatesBundleS3Bucket().applyValue({ args0 -> args0 })

    /**
     * S3 object key holding the client certificate CA bundle.
     */
    public val caCertificatesBundleS3Key: Output<String>
        get() = javaResource.caCertificatesBundleS3Key().applyValue({ args0 -> args0 })

    /**
     * Version Id of CA bundle S3 bucket object, if versioned, defaults to latest if omitted.
     */
    public val caCertificatesBundleS3ObjectVersion: Output<String>?
        get() = javaResource.caCertificatesBundleS3ObjectVersion().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Name of the Trust Store. If omitted, the provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object TrustStoreMapper : ResourceMapper<TrustStore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lb.TrustStore::class == javaResource::class

    override fun map(javaResource: Resource): TrustStore = TrustStore(
        javaResource as
            com.pulumi.aws.lb.TrustStore,
    )
}

/**
 * @see [TrustStore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrustStore].
 */
public suspend fun trustStore(name: String, block: suspend TrustStoreResourceBuilder.() -> Unit): TrustStore {
    val builder = TrustStoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrustStore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trustStore(name: String): TrustStore {
    val builder = TrustStoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
