@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.aws.lb.TrustStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ELBv2 Trust Store for use with Application Load Balancer Listener resources.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import Target Groups using their ARN. For example:
 * ```sh
 * $ pulumi import aws:lb/trustStore:TrustStore example arn:aws:elasticloadbalancing:us-west-2:187416307283:truststore/my-trust-store/20cfe21448b66314
 * ```
 * @property caCertificatesBundleS3Bucket S3 Bucket name holding the client certificate CA bundle.
 * @property caCertificatesBundleS3Key S3 object key holding the client certificate CA bundle.
 * @property caCertificatesBundleS3ObjectVersion Version Id of CA bundle S3 bucket object, if versioned, defaults to latest if omitted.
 * @property name Name of the Trust Store. If omitted, the provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class TrustStoreArgs(
    public val caCertificatesBundleS3Bucket: Output<String>? = null,
    public val caCertificatesBundleS3Key: Output<String>? = null,
    public val caCertificatesBundleS3ObjectVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.TrustStoreArgs> {
    override fun toJava(): com.pulumi.aws.lb.TrustStoreArgs =
        com.pulumi.aws.lb.TrustStoreArgs.builder()
            .caCertificatesBundleS3Bucket(caCertificatesBundleS3Bucket?.applyValue({ args0 -> args0 }))
            .caCertificatesBundleS3Key(caCertificatesBundleS3Key?.applyValue({ args0 -> args0 }))
            .caCertificatesBundleS3ObjectVersion(
                caCertificatesBundleS3ObjectVersion?.applyValue({ args0 ->
                    args0
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TrustStoreArgs].
 */
@PulumiTagMarker
public class TrustStoreArgsBuilder internal constructor() {
    private var caCertificatesBundleS3Bucket: Output<String>? = null

    private var caCertificatesBundleS3Key: Output<String>? = null

    private var caCertificatesBundleS3ObjectVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value S3 Bucket name holding the client certificate CA bundle.
     */
    @JvmName("misbrrmkdpgxiufp")
    public suspend fun caCertificatesBundleS3Bucket(`value`: Output<String>) {
        this.caCertificatesBundleS3Bucket = value
    }

    /**
     * @param value S3 object key holding the client certificate CA bundle.
     */
    @JvmName("eommbwxspllyoiri")
    public suspend fun caCertificatesBundleS3Key(`value`: Output<String>) {
        this.caCertificatesBundleS3Key = value
    }

    /**
     * @param value Version Id of CA bundle S3 bucket object, if versioned, defaults to latest if omitted.
     */
    @JvmName("tdjfulluelcvakvl")
    public suspend fun caCertificatesBundleS3ObjectVersion(`value`: Output<String>) {
        this.caCertificatesBundleS3ObjectVersion = value
    }

    /**
     * @param value Name of the Trust Store. If omitted, the provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    @JvmName("iiahgbqjiphtifeo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
     */
    @JvmName("nqedviscmlrjnxsm")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("agfijkeuuxgbtkkd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value S3 Bucket name holding the client certificate CA bundle.
     */
    @JvmName("gdevhjxwoxtwhtlf")
    public suspend fun caCertificatesBundleS3Bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertificatesBundleS3Bucket = mapped
    }

    /**
     * @param value S3 object key holding the client certificate CA bundle.
     */
    @JvmName("swbutehagbsesxjy")
    public suspend fun caCertificatesBundleS3Key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertificatesBundleS3Key = mapped
    }

    /**
     * @param value Version Id of CA bundle S3 bucket object, if versioned, defaults to latest if omitted.
     */
    @JvmName("iyswqtlqksegawna")
    public suspend fun caCertificatesBundleS3ObjectVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertificatesBundleS3ObjectVersion = mapped
    }

    /**
     * @param value Name of the Trust Store. If omitted, the provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    @JvmName("cyjsgmyymbgkxugl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. Cannot be longer than 6 characters.
     */
    @JvmName("qdarirankbpwijgy")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dkbnilhbpfqoixdm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xcstikteyljnuxxl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TrustStoreArgs = TrustStoreArgs(
        caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket,
        caCertificatesBundleS3Key = caCertificatesBundleS3Key,
        caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion,
        name = name,
        namePrefix = namePrefix,
        tags = tags,
    )
}
