@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TrustStoreRevocation].
 */
@PulumiTagMarker
public class TrustStoreRevocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrustStoreRevocationArgs = TrustStoreRevocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrustStoreRevocationArgsBuilder.() -> Unit) {
        val builder = TrustStoreRevocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrustStoreRevocation {
        val builtJavaResource = com.pulumi.aws.lb.TrustStoreRevocation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrustStoreRevocation(builtJavaResource)
    }
}

/**
 * Provides a ELBv2 Trust Store Revocation for use with Application Load Balancer Listener resources.
 * ## Example Usage
 * ### Trust Store With Revocations
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lb.TrustStore("test", {
 *     name: "tf-example-lb-ts",
 *     caCertificatesBundleS3Bucket: "...",
 *     caCertificatesBundleS3Key: "...",
 * });
 * const testTrustStoreRevocation = new aws.lb.TrustStoreRevocation("test", {
 *     trustStoreArn: test.arn,
 *     revocationsS3Bucket: "...",
 *     revocationsS3Key: "...",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lb.TrustStore("test",
 *     name="tf-example-lb-ts",
 *     ca_certificates_bundle_s3_bucket="...",
 *     ca_certificates_bundle_s3_key="...")
 * test_trust_store_revocation = aws.lb.TrustStoreRevocation("test",
 *     trust_store_arn=test.arn,
 *     revocations_s3_bucket="...",
 *     revocations_s3_key="...")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.LB.TrustStore("test", new()
 *     {
 *         Name = "tf-example-lb-ts",
 *         CaCertificatesBundleS3Bucket = "...",
 *         CaCertificatesBundleS3Key = "...",
 *     });
 *     var testTrustStoreRevocation = new Aws.LB.TrustStoreRevocation("test", new()
 *     {
 *         TrustStoreArn = test.Arn,
 *         RevocationsS3Bucket = "...",
 *         RevocationsS3Key = "...",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := lb.NewTrustStore(ctx, "test", &lb.TrustStoreArgs{
 * 			Name:                         pulumi.String("tf-example-lb-ts"),
 * 			CaCertificatesBundleS3Bucket: pulumi.String("..."),
 * 			CaCertificatesBundleS3Key:    pulumi.String("..."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = lb.NewTrustStoreRevocation(ctx, "test", &lb.TrustStoreRevocationArgs{
 * 			TrustStoreArn:       test.Arn,
 * 			RevocationsS3Bucket: pulumi.String("..."),
 * 			RevocationsS3Key:    pulumi.String("..."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lb.TrustStore;
 * import com.pulumi.aws.lb.TrustStoreArgs;
 * import com.pulumi.aws.lb.TrustStoreRevocation;
 * import com.pulumi.aws.lb.TrustStoreRevocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new TrustStore("test", TrustStoreArgs.builder()
 *             .name("tf-example-lb-ts")
 *             .caCertificatesBundleS3Bucket("...")
 *             .caCertificatesBundleS3Key("...")
 *             .build());
 *         var testTrustStoreRevocation = new TrustStoreRevocation("testTrustStoreRevocation", TrustStoreRevocationArgs.builder()
 *             .trustStoreArn(test.arn())
 *             .revocationsS3Bucket("...")
 *             .revocationsS3Key("...")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lb:TrustStore
 *     properties:
 *       name: tf-example-lb-ts
 *       caCertificatesBundleS3Bucket: '...'
 *       caCertificatesBundleS3Key: '...'
 *   testTrustStoreRevocation:
 *     type: aws:lb:TrustStoreRevocation
 *     name: test
 *     properties:
 *       trustStoreArn: ${test.arn}
 *       revocationsS3Bucket: '...'
 *       revocationsS3Key: '...'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Trust Store Revocations using their ARN. For example:
 * ```sh
 * $ pulumi import aws:lb/trustStoreRevocation:TrustStoreRevocation example arn:aws:elasticloadbalancing:us-west-2:187416307283:truststore/my-trust-store/20cfe21448b66314,6
 * ```
 */
public class TrustStoreRevocation internal constructor(
    override val javaResource: com.pulumi.aws.lb.TrustStoreRevocation,
) : KotlinCustomResource(javaResource, TrustStoreRevocationMapper) {
    /**
     * AWS assigned RevocationId, (number).
     */
    public val revocationId: Output<Int>
        get() = javaResource.revocationId().applyValue({ args0 -> args0 })

    /**
     * S3 Bucket name holding the client certificate CA bundle.
     */
    public val revocationsS3Bucket: Output<String>
        get() = javaResource.revocationsS3Bucket().applyValue({ args0 -> args0 })

    /**
     * S3 object key holding the client certificate CA bundle.
     */
    public val revocationsS3Key: Output<String>
        get() = javaResource.revocationsS3Key().applyValue({ args0 -> args0 })

    /**
     * Version Id of CA bundle S3 bucket object, if versioned, defaults to latest if omitted.
     */
    public val revocationsS3ObjectVersion: Output<String>?
        get() = javaResource.revocationsS3ObjectVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Trust Store ARN.
     */
    public val trustStoreArn: Output<String>
        get() = javaResource.trustStoreArn().applyValue({ args0 -> args0 })
}

public object TrustStoreRevocationMapper : ResourceMapper<TrustStoreRevocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lb.TrustStoreRevocation::class == javaResource::class

    override fun map(javaResource: Resource): TrustStoreRevocation = TrustStoreRevocation(
        javaResource
            as com.pulumi.aws.lb.TrustStoreRevocation,
    )
}

/**
 * @see [TrustStoreRevocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrustStoreRevocation].
 */
public suspend fun trustStoreRevocation(
    name: String,
    block: suspend TrustStoreRevocationResourceBuilder.() -> Unit,
): TrustStoreRevocation {
    val builder = TrustStoreRevocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrustStoreRevocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trustStoreRevocation(name: String): TrustStoreRevocation {
    val builder = TrustStoreRevocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
