@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.GetListenerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getListener.
 * @property arn ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
 * @property loadBalancerArn ARN of the load balancer. Required if `arn` is not set.
 * @property port Port of the listener. Required if `arn` is not set.
 * @property tags
 */
public data class GetListenerPlainArgs(
    public val arn: String? = null,
    public val loadBalancerArn: String? = null,
    public val port: Int? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.GetListenerPlainArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.GetListenerPlainArgs =
        com.pulumi.aws.lb.inputs.GetListenerPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .loadBalancerArn(loadBalancerArn?.let({ args0 -> args0 }))
            .port(port?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetListenerPlainArgs].
 */
@PulumiTagMarker
public class GetListenerPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var loadBalancerArn: String? = null

    private var port: Int? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
     */
    @JvmName("fnqcglqibktkntqb")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value ARN of the load balancer. Required if `arn` is not set.
     */
    @JvmName("xmscowvrekkxdlqy")
    public suspend fun loadBalancerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.loadBalancerArn = mapped
    }

    /**
     * @param value Port of the listener. Required if `arn` is not set.
     */
    @JvmName("skdnvilwynyswdkb")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("dryjlnvfvljhwneq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("kmisjioxtpabupuv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetListenerPlainArgs = GetListenerPlainArgs(
        arn = arn,
        loadBalancerArn = loadBalancerArn,
        port = port,
        tags = tags,
    )
}
