@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.GetTrustStorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrustStore.
 * @property arn Full ARN of the trust store.
 * @property name Unique name of the trust store.
 * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
 */
public data class GetTrustStorePlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.GetTrustStorePlainArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.GetTrustStorePlainArgs =
        com.pulumi.aws.lb.inputs.GetTrustStorePlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrustStorePlainArgs].
 */
@PulumiTagMarker
public class GetTrustStorePlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    /**
     * @param value Full ARN of the trust store.
     */
    @JvmName("pivmyfkuopdkkrgl")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Unique name of the trust store.
     * > **NOTE:** When both `arn` and `name` are specified, `arn` takes precedence.
     */
    @JvmName("sejyctkbkfvwlptk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetTrustStorePlainArgs = GetTrustStorePlainArgs(
        arn = arn,
        name = name,
    )
}
