@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property stickiness Configuration block for target group stickiness for the rule. Detailed below.
 * @property targetGroups Set of 1-5 target group blocks. Detailed below.
 * The following arguments are optional:
 */
public data class ListenerDefaultActionForwardArgs(
    public val stickiness: Output<ListenerDefaultActionForwardStickinessArgs>? = null,
    public val targetGroups: Output<List<ListenerDefaultActionForwardTargetGroupArgs>>,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardArgs =
        com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardArgs.builder()
            .stickiness(stickiness?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetGroups(
                targetGroups.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ListenerDefaultActionForwardArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionForwardArgsBuilder internal constructor() {
    private var stickiness: Output<ListenerDefaultActionForwardStickinessArgs>? = null

    private var targetGroups: Output<List<ListenerDefaultActionForwardTargetGroupArgs>>? = null

    /**
     * @param value Configuration block for target group stickiness for the rule. Detailed below.
     */
    @JvmName("hbnabmtuyheragut")
    public suspend fun stickiness(`value`: Output<ListenerDefaultActionForwardStickinessArgs>) {
        this.stickiness = value
    }

    /**
     * @param value Set of 1-5 target group blocks. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("sttcbhhuirlgwsui")
    public suspend fun targetGroups(`value`: Output<List<ListenerDefaultActionForwardTargetGroupArgs>>) {
        this.targetGroups = value
    }

    @JvmName("rywdhaxmkunstulr")
    public suspend fun targetGroups(vararg values: Output<ListenerDefaultActionForwardTargetGroupArgs>) {
        this.targetGroups = Output.all(values.asList())
    }

    /**
     * @param values Set of 1-5 target group blocks. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("qikvunxykicceiny")
    public suspend fun targetGroups(values: List<Output<ListenerDefaultActionForwardTargetGroupArgs>>) {
        this.targetGroups = Output.all(values)
    }

    /**
     * @param value Configuration block for target group stickiness for the rule. Detailed below.
     */
    @JvmName("mnuvhbuekcyhoumk")
    public suspend fun stickiness(`value`: ListenerDefaultActionForwardStickinessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stickiness = mapped
    }

    /**
     * @param argument Configuration block for target group stickiness for the rule. Detailed below.
     */
    @JvmName("rqymsvmhsbtattfa")
    public suspend fun stickiness(argument: suspend ListenerDefaultActionForwardStickinessArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerDefaultActionForwardStickinessArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.stickiness = mapped
    }

    /**
     * @param value Set of 1-5 target group blocks. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("mwwovgttktusousr")
    public suspend fun targetGroups(`value`: List<ListenerDefaultActionForwardTargetGroupArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    /**
     * @param argument Set of 1-5 target group blocks. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("skjdslxopsijdyhw")
    public suspend fun targetGroups(argument: List<suspend ListenerDefaultActionForwardTargetGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionForwardTargetGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument Set of 1-5 target group blocks. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("ctfadskwxeticlcs")
    public suspend fun targetGroups(vararg argument: suspend ListenerDefaultActionForwardTargetGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerDefaultActionForwardTargetGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument Set of 1-5 target group blocks. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("snsqcsqffwfyinqq")
    public suspend fun targetGroups(argument: suspend ListenerDefaultActionForwardTargetGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ListenerDefaultActionForwardTargetGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param values Set of 1-5 target group blocks. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("uagpdoiervlvfttp")
    public suspend fun targetGroups(vararg values: ListenerDefaultActionForwardTargetGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    internal fun build(): ListenerDefaultActionForwardArgs = ListenerDefaultActionForwardArgs(
        stickiness = stickiness,
        targetGroups = targetGroups ?: throw PulumiNullFieldException("targetGroups"),
    )
}
