@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerMutualAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ignoreClientCertificateExpiry Whether client certificate expiry is ignored. Default is `false`.
 * @property mode Valid values are `off`, `verify` and `passthrough`.
 * @property trustStoreArn ARN of the elbv2 Trust Store.
 */
public data class ListenerMutualAuthenticationArgs(
    public val ignoreClientCertificateExpiry: Output<Boolean>? = null,
    public val mode: Output<String>,
    public val trustStoreArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerMutualAuthenticationArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerMutualAuthenticationArgs =
        com.pulumi.aws.lb.inputs.ListenerMutualAuthenticationArgs.builder()
            .ignoreClientCertificateExpiry(ignoreClientCertificateExpiry?.applyValue({ args0 -> args0 }))
            .mode(mode.applyValue({ args0 -> args0 }))
            .trustStoreArn(trustStoreArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerMutualAuthenticationArgs].
 */
@PulumiTagMarker
public class ListenerMutualAuthenticationArgsBuilder internal constructor() {
    private var ignoreClientCertificateExpiry: Output<Boolean>? = null

    private var mode: Output<String>? = null

    private var trustStoreArn: Output<String>? = null

    /**
     * @param value Whether client certificate expiry is ignored. Default is `false`.
     */
    @JvmName("ahdxowjiubrabixw")
    public suspend fun ignoreClientCertificateExpiry(`value`: Output<Boolean>) {
        this.ignoreClientCertificateExpiry = value
    }

    /**
     * @param value Valid values are `off`, `verify` and `passthrough`.
     */
    @JvmName("rtesubyyrtnuplpo")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value ARN of the elbv2 Trust Store.
     */
    @JvmName("qcfplifuexnctdmc")
    public suspend fun trustStoreArn(`value`: Output<String>) {
        this.trustStoreArn = value
    }

    /**
     * @param value Whether client certificate expiry is ignored. Default is `false`.
     */
    @JvmName("noxwqvqwuufgyord")
    public suspend fun ignoreClientCertificateExpiry(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreClientCertificateExpiry = mapped
    }

    /**
     * @param value Valid values are `off`, `verify` and `passthrough`.
     */
    @JvmName("spkuugavtoemsgoj")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value ARN of the elbv2 Trust Store.
     */
    @JvmName("wrawapwhwhodkgil")
    public suspend fun trustStoreArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustStoreArn = mapped
    }

    internal fun build(): ListenerMutualAuthenticationArgs = ListenerMutualAuthenticationArgs(
        ignoreClientCertificateExpiry = ignoreClientCertificateExpiry,
        mode = mode ?: throw PulumiNullFieldException("mode"),
        trustStoreArn = trustStoreArn,
    )
}
