@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateOidcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationRequestExtraParams The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
 * @property authorizationEndpoint The authorization endpoint of the IdP.
 * @property clientId The OAuth 2.0 client identifier.
 * @property clientSecret The OAuth 2.0 client secret.
 * @property issuer The OIDC issuer identifier of the IdP.
 * @property onUnauthenticatedRequest The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
 * @property scope The set of user claims to be requested from the IdP.
 * @property sessionCookieName The name of the cookie used to maintain session information.
 * @property sessionTimeout The maximum duration of the authentication session, in seconds.
 * @property tokenEndpoint The token endpoint of the IdP.
 * @property userInfoEndpoint The user info endpoint of the IdP.
 */
public data class ListenerRuleActionAuthenticateOidcArgs(
    public val authenticationRequestExtraParams: Output<Map<String, String>>? = null,
    public val authorizationEndpoint: Output<String>,
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
    public val issuer: Output<String>,
    public val onUnauthenticatedRequest: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sessionCookieName: Output<String>? = null,
    public val sessionTimeout: Output<Int>? = null,
    public val tokenEndpoint: Output<String>,
    public val userInfoEndpoint: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateOidcArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateOidcArgs =
        com.pulumi.aws.lb.inputs.ListenerRuleActionAuthenticateOidcArgs.builder()
            .authenticationRequestExtraParams(
                authenticationRequestExtraParams?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            )
            .authorizationEndpoint(authorizationEndpoint.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 }))
            .issuer(issuer.applyValue({ args0 -> args0 }))
            .onUnauthenticatedRequest(onUnauthenticatedRequest?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sessionCookieName(sessionCookieName?.applyValue({ args0 -> args0 }))
            .sessionTimeout(sessionTimeout?.applyValue({ args0 -> args0 }))
            .tokenEndpoint(tokenEndpoint.applyValue({ args0 -> args0 }))
            .userInfoEndpoint(userInfoEndpoint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleActionAuthenticateOidcArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionAuthenticateOidcArgsBuilder internal constructor() {
    private var authenticationRequestExtraParams: Output<Map<String, String>>? = null

    private var authorizationEndpoint: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var issuer: Output<String>? = null

    private var onUnauthenticatedRequest: Output<String>? = null

    private var scope: Output<String>? = null

    private var sessionCookieName: Output<String>? = null

    private var sessionTimeout: Output<Int>? = null

    private var tokenEndpoint: Output<String>? = null

    private var userInfoEndpoint: Output<String>? = null

    /**
     * @param value The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
     */
    @JvmName("mmycnoxvyacdweol")
    public suspend fun authenticationRequestExtraParams(`value`: Output<Map<String, String>>) {
        this.authenticationRequestExtraParams = value
    }

    /**
     * @param value The authorization endpoint of the IdP.
     */
    @JvmName("hfpvtgndcwcvowde")
    public suspend fun authorizationEndpoint(`value`: Output<String>) {
        this.authorizationEndpoint = value
    }

    /**
     * @param value The OAuth 2.0 client identifier.
     */
    @JvmName("sdxcejfvogmbmlnk")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The OAuth 2.0 client secret.
     */
    @JvmName("jffvrolphjpkdwcn")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The OIDC issuer identifier of the IdP.
     */
    @JvmName("dpdwrfaonodallsi")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
     */
    @JvmName("yllpmfodpngxdmni")
    public suspend fun onUnauthenticatedRequest(`value`: Output<String>) {
        this.onUnauthenticatedRequest = value
    }

    /**
     * @param value The set of user claims to be requested from the IdP.
     */
    @JvmName("grpmgtjvfgprkjgy")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The name of the cookie used to maintain session information.
     */
    @JvmName("obctruulpgewyyae")
    public suspend fun sessionCookieName(`value`: Output<String>) {
        this.sessionCookieName = value
    }

    /**
     * @param value The maximum duration of the authentication session, in seconds.
     */
    @JvmName("jecjhksgcveahtmt")
    public suspend fun sessionTimeout(`value`: Output<Int>) {
        this.sessionTimeout = value
    }

    /**
     * @param value The token endpoint of the IdP.
     */
    @JvmName("ewiaiiofsvvrjdmx")
    public suspend fun tokenEndpoint(`value`: Output<String>) {
        this.tokenEndpoint = value
    }

    /**
     * @param value The user info endpoint of the IdP.
     */
    @JvmName("ytcrinnnkhsaacaj")
    public suspend fun userInfoEndpoint(`value`: Output<String>) {
        this.userInfoEndpoint = value
    }

    /**
     * @param value The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
     */
    @JvmName("txyaymjgoaxtwcic")
    public suspend fun authenticationRequestExtraParams(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param values The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
     */
    @JvmName("xunpdojyaxhwudeo")
    public fun authenticationRequestExtraParams(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationRequestExtraParams = mapped
    }

    /**
     * @param value The authorization endpoint of the IdP.
     */
    @JvmName("lshfjutgukhkwwfs")
    public suspend fun authorizationEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationEndpoint = mapped
    }

    /**
     * @param value The OAuth 2.0 client identifier.
     */
    @JvmName("gbbfkrbhactxmacd")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The OAuth 2.0 client secret.
     */
    @JvmName("cbxkenxrrgnvmeqk")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The OIDC issuer identifier of the IdP.
     */
    @JvmName("rwfngasjyyjgffxb")
    public suspend fun issuer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
     */
    @JvmName("slakicwwbxlcvrdm")
    public suspend fun onUnauthenticatedRequest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onUnauthenticatedRequest = mapped
    }

    /**
     * @param value The set of user claims to be requested from the IdP.
     */
    @JvmName("ydylyastyolgmrqf")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The name of the cookie used to maintain session information.
     */
    @JvmName("uvqhtvnbbgqniame")
    public suspend fun sessionCookieName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionCookieName = mapped
    }

    /**
     * @param value The maximum duration of the authentication session, in seconds.
     */
    @JvmName("grdyilwqtgtnqpkd")
    public suspend fun sessionTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionTimeout = mapped
    }

    /**
     * @param value The token endpoint of the IdP.
     */
    @JvmName("wjtigejecthijusk")
    public suspend fun tokenEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenEndpoint = mapped
    }

    /**
     * @param value The user info endpoint of the IdP.
     */
    @JvmName("lvsjcbnkkqtxogbq")
    public suspend fun userInfoEndpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userInfoEndpoint = mapped
    }

    internal fun build(): ListenerRuleActionAuthenticateOidcArgs =
        ListenerRuleActionAuthenticateOidcArgs(
            authenticationRequestExtraParams = authenticationRequestExtraParams,
            authorizationEndpoint = authorizationEndpoint ?: throw
                PulumiNullFieldException("authorizationEndpoint"),
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
            issuer = issuer ?: throw PulumiNullFieldException("issuer"),
            onUnauthenticatedRequest = onUnauthenticatedRequest,
            scope = scope,
            sessionCookieName = sessionCookieName,
            sessionTimeout = sessionTimeout,
            tokenEndpoint = tokenEndpoint ?: throw PulumiNullFieldException("tokenEndpoint"),
            userInfoEndpoint = userInfoEndpoint ?: throw PulumiNullFieldException("userInfoEndpoint"),
        )
}
