@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerRuleActionForwardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property stickiness The target group stickiness for the rule.
 * @property targetGroups One or more target groups block.
 */
public data class ListenerRuleActionForwardArgs(
    public val stickiness: Output<ListenerRuleActionForwardStickinessArgs>? = null,
    public val targetGroups: Output<List<ListenerRuleActionForwardTargetGroupArgs>>,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerRuleActionForwardArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerRuleActionForwardArgs =
        com.pulumi.aws.lb.inputs.ListenerRuleActionForwardArgs.builder()
            .stickiness(stickiness?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetGroups(
                targetGroups.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ListenerRuleActionForwardArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionForwardArgsBuilder internal constructor() {
    private var stickiness: Output<ListenerRuleActionForwardStickinessArgs>? = null

    private var targetGroups: Output<List<ListenerRuleActionForwardTargetGroupArgs>>? = null

    /**
     * @param value The target group stickiness for the rule.
     */
    @JvmName("gajblsdbahkvgjaw")
    public suspend fun stickiness(`value`: Output<ListenerRuleActionForwardStickinessArgs>) {
        this.stickiness = value
    }

    /**
     * @param value One or more target groups block.
     */
    @JvmName("airtilmgwahdewko")
    public suspend fun targetGroups(`value`: Output<List<ListenerRuleActionForwardTargetGroupArgs>>) {
        this.targetGroups = value
    }

    @JvmName("dgvtsgydndrdjuik")
    public suspend fun targetGroups(vararg values: Output<ListenerRuleActionForwardTargetGroupArgs>) {
        this.targetGroups = Output.all(values.asList())
    }

    /**
     * @param values One or more target groups block.
     */
    @JvmName("jhgqrnmooqecpluf")
    public suspend fun targetGroups(values: List<Output<ListenerRuleActionForwardTargetGroupArgs>>) {
        this.targetGroups = Output.all(values)
    }

    /**
     * @param value The target group stickiness for the rule.
     */
    @JvmName("osilbaryygdisonv")
    public suspend fun stickiness(`value`: ListenerRuleActionForwardStickinessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stickiness = mapped
    }

    /**
     * @param argument The target group stickiness for the rule.
     */
    @JvmName("tkkscrblmsehmfkx")
    public suspend fun stickiness(argument: suspend ListenerRuleActionForwardStickinessArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionForwardStickinessArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.stickiness = mapped
    }

    /**
     * @param value One or more target groups block.
     */
    @JvmName("gdtnwgqklugfuhds")
    public suspend fun targetGroups(`value`: List<ListenerRuleActionForwardTargetGroupArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    /**
     * @param argument One or more target groups block.
     */
    @JvmName("bylidwbsfujsitdn")
    public suspend fun targetGroups(argument: List<suspend ListenerRuleActionForwardTargetGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerRuleActionForwardTargetGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument One or more target groups block.
     */
    @JvmName("scpmcegsydgntyxj")
    public suspend fun targetGroups(vararg argument: suspend ListenerRuleActionForwardTargetGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ListenerRuleActionForwardTargetGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param argument One or more target groups block.
     */
    @JvmName("npdgnnimfiychqwq")
    public suspend fun targetGroups(argument: suspend ListenerRuleActionForwardTargetGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ListenerRuleActionForwardTargetGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetGroups = mapped
    }

    /**
     * @param values One or more target groups block.
     */
    @JvmName("rucwhdvyltmwfmhh")
    public suspend fun targetGroups(vararg values: ListenerRuleActionForwardTargetGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroups = mapped
    }

    internal fun build(): ListenerRuleActionForwardArgs = ListenerRuleActionForwardArgs(
        stickiness = stickiness,
        targetGroups = targetGroups ?: throw PulumiNullFieldException("targetGroups"),
    )
}
