@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.ListenerRuleConditionSourceIpArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property values
 */
public data class ListenerRuleConditionSourceIpArgs(
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.ListenerRuleConditionSourceIpArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.ListenerRuleConditionSourceIpArgs =
        com.pulumi.aws.lb.inputs.ListenerRuleConditionSourceIpArgs.builder()
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ListenerRuleConditionSourceIpArgs].
 */
@PulumiTagMarker
public class ListenerRuleConditionSourceIpArgsBuilder internal constructor() {
    private var values: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("ulgyiygvptrmvvvy")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("ehyjlkaauhfjavdi")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vwrfbviaucpdfqho")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("wpddrofbspkkcdoi")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("oiginnddntcmvgla")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ListenerRuleConditionSourceIpArgs = ListenerRuleConditionSourceIpArgs(
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
