@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allocationId Allocation ID of the Elastic IP address for an internet-facing load balancer.
 * @property ipv6Address IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
 * @property outpostId
 * @property privateIpv4Address Private IPv4 address for an internal load balancer.
 * @property subnetId ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
 */
public data class LoadBalancerSubnetMappingArgs(
    public val allocationId: Output<String>? = null,
    public val ipv6Address: Output<String>? = null,
    public val outpostId: Output<String>? = null,
    public val privateIpv4Address: Output<String>? = null,
    public val subnetId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs =
        com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs.builder()
            .allocationId(allocationId?.applyValue({ args0 -> args0 }))
            .ipv6Address(ipv6Address?.applyValue({ args0 -> args0 }))
            .outpostId(outpostId?.applyValue({ args0 -> args0 }))
            .privateIpv4Address(privateIpv4Address?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerSubnetMappingArgs].
 */
@PulumiTagMarker
public class LoadBalancerSubnetMappingArgsBuilder internal constructor() {
    private var allocationId: Output<String>? = null

    private var ipv6Address: Output<String>? = null

    private var outpostId: Output<String>? = null

    private var privateIpv4Address: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value Allocation ID of the Elastic IP address for an internet-facing load balancer.
     */
    @JvmName("gpgifxqqxihmrsfu")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
     */
    @JvmName("wljyrnhpvnattoiw")
    public suspend fun ipv6Address(`value`: Output<String>) {
        this.ipv6Address = value
    }

    /**
     * @param value
     */
    @JvmName("rpywspkyowsnnrbi")
    public suspend fun outpostId(`value`: Output<String>) {
        this.outpostId = value
    }

    /**
     * @param value Private IPv4 address for an internal load balancer.
     */
    @JvmName("msvxhayhjqngqwiw")
    public suspend fun privateIpv4Address(`value`: Output<String>) {
        this.privateIpv4Address = value
    }

    /**
     * @param value ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
     */
    @JvmName("wwptqrxltiiupkkx")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Allocation ID of the Elastic IP address for an internet-facing load balancer.
     */
    @JvmName("bulbckqlycauybyq")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
     */
    @JvmName("suaynjhiqsjbbips")
    public suspend fun ipv6Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Address = mapped
    }

    /**
     * @param value
     */
    @JvmName("fhpqanhgjmeaouod")
    public suspend fun outpostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outpostId = mapped
    }

    /**
     * @param value Private IPv4 address for an internal load balancer.
     */
    @JvmName("twlaclgkuhuwaxqh")
    public suspend fun privateIpv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpv4Address = mapped
    }

    /**
     * @param value ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
     */
    @JvmName("eykspntwkmvlglle")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): LoadBalancerSubnetMappingArgs = LoadBalancerSubnetMappingArgs(
        allocationId = allocationId,
        ipv6Address = ipv6Address,
        outpostId = outpostId,
        privateIpv4Address = privateIpv4Address,
        subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
    )
}
