@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.TargetGroupTargetFailoverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property onDeregistration Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
 * @property onUnhealthy Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
 */
public data class TargetGroupTargetFailoverArgs(
    public val onDeregistration: Output<String>,
    public val onUnhealthy: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.TargetGroupTargetFailoverArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.TargetGroupTargetFailoverArgs =
        com.pulumi.aws.lb.inputs.TargetGroupTargetFailoverArgs.builder()
            .onDeregistration(onDeregistration.applyValue({ args0 -> args0 }))
            .onUnhealthy(onUnhealthy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupTargetFailoverArgs].
 */
@PulumiTagMarker
public class TargetGroupTargetFailoverArgsBuilder internal constructor() {
    private var onDeregistration: Output<String>? = null

    private var onUnhealthy: Output<String>? = null

    /**
     * @param value Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
     */
    @JvmName("wistotsipyigpaki")
    public suspend fun onDeregistration(`value`: Output<String>) {
        this.onDeregistration = value
    }

    /**
     * @param value Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
     */
    @JvmName("wqetheuebdtveegt")
    public suspend fun onUnhealthy(`value`: Output<String>) {
        this.onUnhealthy = value
    }

    /**
     * @param value Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
     */
    @JvmName("jofnissvvacksuvw")
    public suspend fun onDeregistration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onDeregistration = mapped
    }

    /**
     * @param value Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
     */
    @JvmName("pcvepttipwdgmpjq")
    public suspend fun onUnhealthy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onUnhealthy = mapped
    }

    internal fun build(): TargetGroupTargetFailoverArgs = TargetGroupTargetFailoverArgs(
        onDeregistration = onDeregistration ?: throw PulumiNullFieldException("onDeregistration"),
        onUnhealthy = onUnhealthy ?: throw PulumiNullFieldException("onUnhealthy"),
    )
}
