@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dnsFailover Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
 * @property unhealthyStateRouting Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
 */
public data class TargetGroupTargetGroupHealthArgs(
    public val dnsFailover: Output<TargetGroupTargetGroupHealthDnsFailoverArgs>? = null,
    public val unhealthyStateRouting: Output<TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthArgs =
        com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthArgs.builder()
            .dnsFailover(dnsFailover?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .unhealthyStateRouting(
                unhealthyStateRouting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TargetGroupTargetGroupHealthArgs].
 */
@PulumiTagMarker
public class TargetGroupTargetGroupHealthArgsBuilder internal constructor() {
    private var dnsFailover: Output<TargetGroupTargetGroupHealthDnsFailoverArgs>? = null

    private var unhealthyStateRouting: Output<TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs>? =
        null

    /**
     * @param value Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
     */
    @JvmName("gosgticwlbavqmba")
    public suspend fun dnsFailover(`value`: Output<TargetGroupTargetGroupHealthDnsFailoverArgs>) {
        this.dnsFailover = value
    }

    /**
     * @param value Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
     */
    @JvmName("vpsgldavwolfcblq")
    public suspend fun unhealthyStateRouting(`value`: Output<TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs>) {
        this.unhealthyStateRouting = value
    }

    /**
     * @param value Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
     */
    @JvmName("brmlqqpeukmdjsmd")
    public suspend fun dnsFailover(`value`: TargetGroupTargetGroupHealthDnsFailoverArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsFailover = mapped
    }

    /**
     * @param argument Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
     */
    @JvmName("ysgquemaskllrrmr")
    public suspend fun dnsFailover(argument: suspend TargetGroupTargetGroupHealthDnsFailoverArgsBuilder.() -> Unit) {
        val toBeMapped = TargetGroupTargetGroupHealthDnsFailoverArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dnsFailover = mapped
    }

    /**
     * @param value Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
     */
    @JvmName("bcqtewfiqduaknac")
    public suspend fun unhealthyStateRouting(`value`: TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyStateRouting = mapped
    }

    /**
     * @param argument Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
     */
    @JvmName("uovvqsuxfmcrwnpb")
    public suspend fun unhealthyStateRouting(argument: suspend TargetGroupTargetGroupHealthUnhealthyStateRoutingArgsBuilder.() -> Unit) {
        val toBeMapped = TargetGroupTargetGroupHealthUnhealthyStateRoutingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.unhealthyStateRouting = mapped
    }

    internal fun build(): TargetGroupTargetGroupHealthArgs = TargetGroupTargetGroupHealthArgs(
        dnsFailover = dnsFailover,
        unhealthyStateRouting = unhealthyStateRouting,
    )
}
