@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.inputs

import com.pulumi.aws.lb.inputs.TargetGroupTargetHealthStateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableUnhealthyConnectionTermination Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
 * @property unhealthyDrainingInterval Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
 */
public data class TargetGroupTargetHealthStateArgs(
    public val enableUnhealthyConnectionTermination: Output<Boolean>,
    public val unhealthyDrainingInterval: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lb.inputs.TargetGroupTargetHealthStateArgs> {
    override fun toJava(): com.pulumi.aws.lb.inputs.TargetGroupTargetHealthStateArgs =
        com.pulumi.aws.lb.inputs.TargetGroupTargetHealthStateArgs.builder()
            .enableUnhealthyConnectionTermination(
                enableUnhealthyConnectionTermination.applyValue({ args0 ->
                    args0
                }),
            )
            .unhealthyDrainingInterval(unhealthyDrainingInterval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupTargetHealthStateArgs].
 */
@PulumiTagMarker
public class TargetGroupTargetHealthStateArgsBuilder internal constructor() {
    private var enableUnhealthyConnectionTermination: Output<Boolean>? = null

    private var unhealthyDrainingInterval: Output<Int>? = null

    /**
     * @param value Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
     */
    @JvmName("vrstqlnlkypcgiiw")
    public suspend fun enableUnhealthyConnectionTermination(`value`: Output<Boolean>) {
        this.enableUnhealthyConnectionTermination = value
    }

    /**
     * @param value Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
     */
    @JvmName("hombjdgnhkirgdhs")
    public suspend fun unhealthyDrainingInterval(`value`: Output<Int>) {
        this.unhealthyDrainingInterval = value
    }

    /**
     * @param value Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
     */
    @JvmName("lqixshyegydssngl")
    public suspend fun enableUnhealthyConnectionTermination(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableUnhealthyConnectionTermination = mapped
    }

    /**
     * @param value Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
     */
    @JvmName("imtmkalotjmsghfk")
    public suspend fun unhealthyDrainingInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unhealthyDrainingInterval = mapped
    }

    internal fun build(): TargetGroupTargetHealthStateArgs = TargetGroupTargetHealthStateArgs(
        enableUnhealthyConnectionTermination = enableUnhealthyConnectionTermination ?: throw
            PulumiNullFieldException("enableUnhealthyConnectionTermination"),
        unhealthyDrainingInterval = unhealthyDrainingInterval,
    )
}
