@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getHostedZoneId.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property loadBalancerType
 * @property region
 */
public data class GetHostedZoneIdResult(
    public val id: String,
    public val loadBalancerType: String? = null,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.GetHostedZoneIdResult): GetHostedZoneIdResult = GetHostedZoneIdResult(
            id = javaType.id(),
            loadBalancerType = javaType.loadBalancerType().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
