@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getLoadBalancer.
 * @property accessLogs
 * @property arn
 * @property arnSuffix
 * @property clientKeepAlive
 * @property connectionLogs
 * @property customerOwnedIpv4Pool
 * @property desyncMitigationMode
 * @property dnsName
 * @property dnsRecordClientRoutingPolicy
 * @property dropInvalidHeaderFields
 * @property enableCrossZoneLoadBalancing
 * @property enableDeletionProtection
 * @property enableHttp2
 * @property enableTlsVersionAndCipherSuiteHeaders
 * @property enableWafFailOpen
 * @property enableXffClientPort
 * @property enforceSecurityGroupInboundRulesOnPrivateLinkTraffic
 * @property id The provider-assigned unique ID for this managed resource.
 * @property idleTimeout
 * @property internal
 * @property ipAddressType
 * @property loadBalancerType
 * @property name
 * @property preserveHostHeader
 * @property securityGroups
 * @property subnetMappings
 * @property subnets
 * @property tags
 * @property vpcId
 * @property xffHeaderProcessingMode
 * @property zoneId
 */
public data class GetLoadBalancerResult(
    public val accessLogs: GetLoadBalancerAccessLogs,
    public val arn: String,
    public val arnSuffix: String,
    public val clientKeepAlive: Int,
    public val connectionLogs: List<GetLoadBalancerConnectionLog>,
    public val customerOwnedIpv4Pool: String,
    public val desyncMitigationMode: String,
    public val dnsName: String,
    public val dnsRecordClientRoutingPolicy: String,
    public val dropInvalidHeaderFields: Boolean,
    public val enableCrossZoneLoadBalancing: Boolean,
    public val enableDeletionProtection: Boolean,
    public val enableHttp2: Boolean,
    public val enableTlsVersionAndCipherSuiteHeaders: Boolean,
    public val enableWafFailOpen: Boolean,
    public val enableXffClientPort: Boolean,
    public val enforceSecurityGroupInboundRulesOnPrivateLinkTraffic: String,
    public val id: String,
    public val idleTimeout: Int,
    public val `internal`: Boolean,
    public val ipAddressType: String,
    public val loadBalancerType: String,
    public val name: String,
    public val preserveHostHeader: Boolean,
    public val securityGroups: List<String>,
    public val subnetMappings: List<GetLoadBalancerSubnetMapping>,
    public val subnets: List<String>,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val xffHeaderProcessingMode: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.GetLoadBalancerResult): GetLoadBalancerResult = GetLoadBalancerResult(
            accessLogs = javaType.accessLogs().let({ args0 ->
                com.pulumi.aws.lb.kotlin.outputs.GetLoadBalancerAccessLogs.Companion.toKotlin(args0)
            }),
            arn = javaType.arn(),
            arnSuffix = javaType.arnSuffix(),
            clientKeepAlive = javaType.clientKeepAlive(),
            connectionLogs = javaType.connectionLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.GetLoadBalancerConnectionLog.Companion.toKotlin(args0)
                })
            }),
            customerOwnedIpv4Pool = javaType.customerOwnedIpv4Pool(),
            desyncMitigationMode = javaType.desyncMitigationMode(),
            dnsName = javaType.dnsName(),
            dnsRecordClientRoutingPolicy = javaType.dnsRecordClientRoutingPolicy(),
            dropInvalidHeaderFields = javaType.dropInvalidHeaderFields(),
            enableCrossZoneLoadBalancing = javaType.enableCrossZoneLoadBalancing(),
            enableDeletionProtection = javaType.enableDeletionProtection(),
            enableHttp2 = javaType.enableHttp2(),
            enableTlsVersionAndCipherSuiteHeaders = javaType.enableTlsVersionAndCipherSuiteHeaders(),
            enableWafFailOpen = javaType.enableWafFailOpen(),
            enableXffClientPort = javaType.enableXffClientPort(),
            enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = javaType.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(),
            id = javaType.id(),
            idleTimeout = javaType.idleTimeout(),
            `internal` = javaType.`internal`(),
            ipAddressType = javaType.ipAddressType(),
            loadBalancerType = javaType.loadBalancerType(),
            name = javaType.name(),
            preserveHostHeader = javaType.preserveHostHeader(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            subnetMappings = javaType.subnetMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lb.kotlin.outputs.GetLoadBalancerSubnetMapping.Companion.toKotlin(args0)
                })
            }),
            subnets = javaType.subnets().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            xffHeaderProcessingMode = javaType.xffHeaderProcessingMode(),
            zoneId = javaType.zoneId(),
        )
    }
}
