@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getTrustStore.
 * @property arn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 */
public data class GetTrustStoreResult(
    public val arn: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.GetTrustStoreResult): GetTrustStoreResult = GetTrustStoreResult(
            arn = javaType.arn(),
            id = javaType.id(),
            name = javaType.name(),
        )
    }
}
