@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authenticationRequestExtraParams Query parameters to include in the redirect request to the authorization endpoint. Max: 10. Detailed below.
 * @property onUnauthenticatedRequest Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
 * @property scope Set of user claims to be requested from the IdP.
 * @property sessionCookieName Name of the cookie used to maintain session information.
 * @property sessionTimeout Maximum duration of the authentication session, in seconds.
 * @property userPoolArn ARN of the Cognito user pool.
 * @property userPoolClientId ID of the Cognito user pool client.
 * @property userPoolDomain Domain prefix or fully-qualified domain name of the Cognito user pool.
 * The following arguments are optional:
 */
public data class ListenerDefaultActionAuthenticateCognito(
    public val authenticationRequestExtraParams: Map<String, String>? = null,
    public val onUnauthenticatedRequest: String? = null,
    public val scope: String? = null,
    public val sessionCookieName: String? = null,
    public val sessionTimeout: Int? = null,
    public val userPoolArn: String,
    public val userPoolClientId: String,
    public val userPoolDomain: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerDefaultActionAuthenticateCognito): ListenerDefaultActionAuthenticateCognito = ListenerDefaultActionAuthenticateCognito(
            authenticationRequestExtraParams = javaType.authenticationRequestExtraParams().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            onUnauthenticatedRequest = javaType.onUnauthenticatedRequest().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            sessionCookieName = javaType.sessionCookieName().map({ args0 -> args0 }).orElse(null),
            sessionTimeout = javaType.sessionTimeout().map({ args0 -> args0 }).orElse(null),
            userPoolArn = javaType.userPoolArn(),
            userPoolClientId = javaType.userPoolClientId(),
            userPoolDomain = javaType.userPoolDomain(),
        )
    }
}
