@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authenticationRequestExtraParams Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
 * @property authorizationEndpoint Authorization endpoint of the IdP.
 * @property clientId OAuth 2.0 client identifier.
 * @property clientSecret OAuth 2.0 client secret.
 * @property issuer OIDC issuer identifier of the IdP.
 * @property onUnauthenticatedRequest Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
 * @property scope Set of user claims to be requested from the IdP.
 * @property sessionCookieName Name of the cookie used to maintain session information.
 * @property sessionTimeout Maximum duration of the authentication session, in seconds.
 * @property tokenEndpoint Token endpoint of the IdP.
 * @property userInfoEndpoint User info endpoint of the IdP.
 * The following arguments are optional:
 */
public data class ListenerDefaultActionAuthenticateOidc(
    public val authenticationRequestExtraParams: Map<String, String>? = null,
    public val authorizationEndpoint: String,
    public val clientId: String,
    public val clientSecret: String,
    public val issuer: String,
    public val onUnauthenticatedRequest: String? = null,
    public val scope: String? = null,
    public val sessionCookieName: String? = null,
    public val sessionTimeout: Int? = null,
    public val tokenEndpoint: String,
    public val userInfoEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerDefaultActionAuthenticateOidc): ListenerDefaultActionAuthenticateOidc = ListenerDefaultActionAuthenticateOidc(
            authenticationRequestExtraParams = javaType.authenticationRequestExtraParams().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            authorizationEndpoint = javaType.authorizationEndpoint(),
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret(),
            issuer = javaType.issuer(),
            onUnauthenticatedRequest = javaType.onUnauthenticatedRequest().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            sessionCookieName = javaType.sessionCookieName().map({ args0 -> args0 }).orElse(null),
            sessionTimeout = javaType.sessionTimeout().map({ args0 -> args0 }).orElse(null),
            tokenEndpoint = javaType.tokenEndpoint(),
            userInfoEndpoint = javaType.userInfoEndpoint(),
        )
    }
}
