@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property duration Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
 * The following arguments are optional:
 * @property enabled Whether target group stickiness is enabled. Default is `false`.
 */
public data class ListenerDefaultActionForwardStickiness(
    public val duration: Int,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerDefaultActionForwardStickiness): ListenerDefaultActionForwardStickiness = ListenerDefaultActionForwardStickiness(
            duration = javaType.duration(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
