@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ignoreClientCertificateExpiry Whether client certificate expiry is ignored. Default is `false`.
 * @property mode Valid values are `off`, `verify` and `passthrough`.
 * @property trustStoreArn ARN of the elbv2 Trust Store.
 */
public data class ListenerMutualAuthentication(
    public val ignoreClientCertificateExpiry: Boolean? = null,
    public val mode: String,
    public val trustStoreArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerMutualAuthentication): ListenerMutualAuthentication = ListenerMutualAuthentication(
            ignoreClientCertificateExpiry = javaType.ignoreClientCertificateExpiry().map({ args0 ->
                args0
            }).orElse(null),
            mode = javaType.mode(),
            trustStoreArn = javaType.trustStoreArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
