@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authenticationRequestExtraParams The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
 * @property authorizationEndpoint The authorization endpoint of the IdP.
 * @property clientId The OAuth 2.0 client identifier.
 * @property clientSecret The OAuth 2.0 client secret.
 * @property issuer The OIDC issuer identifier of the IdP.
 * @property onUnauthenticatedRequest The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
 * @property scope The set of user claims to be requested from the IdP.
 * @property sessionCookieName The name of the cookie used to maintain session information.
 * @property sessionTimeout The maximum duration of the authentication session, in seconds.
 * @property tokenEndpoint The token endpoint of the IdP.
 * @property userInfoEndpoint The user info endpoint of the IdP.
 */
public data class ListenerRuleActionAuthenticateOidc(
    public val authenticationRequestExtraParams: Map<String, String>? = null,
    public val authorizationEndpoint: String,
    public val clientId: String,
    public val clientSecret: String,
    public val issuer: String,
    public val onUnauthenticatedRequest: String? = null,
    public val scope: String? = null,
    public val sessionCookieName: String? = null,
    public val sessionTimeout: Int? = null,
    public val tokenEndpoint: String,
    public val userInfoEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.ListenerRuleActionAuthenticateOidc): ListenerRuleActionAuthenticateOidc = ListenerRuleActionAuthenticateOidc(
            authenticationRequestExtraParams = javaType.authenticationRequestExtraParams().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            authorizationEndpoint = javaType.authorizationEndpoint(),
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret(),
            issuer = javaType.issuer(),
            onUnauthenticatedRequest = javaType.onUnauthenticatedRequest().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            sessionCookieName = javaType.sessionCookieName().map({ args0 -> args0 }).orElse(null),
            sessionTimeout = javaType.sessionTimeout().map({ args0 -> args0 }).orElse(null),
            tokenEndpoint = javaType.tokenEndpoint(),
            userInfoEndpoint = javaType.userInfoEndpoint(),
        )
    }
}
