@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cookieDuration Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
 * @property cookieName Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
 * @property enabled Boolean to enable / disable `stickiness`. Default is `true`.
 * @property type The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
 */
public data class TargetGroupStickiness(
    public val cookieDuration: Int? = null,
    public val cookieName: String? = null,
    public val enabled: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.TargetGroupStickiness): TargetGroupStickiness = TargetGroupStickiness(
            cookieDuration = javaType.cookieDuration().map({ args0 -> args0 }).orElse(null),
            cookieName = javaType.cookieName().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
