@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property minimumHealthyTargetsCount The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
 * @property minimumHealthyTargetsPercentage The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
 */
public data class TargetGroupTargetGroupHealthDnsFailover(
    public val minimumHealthyTargetsCount: String? = null,
    public val minimumHealthyTargetsPercentage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.TargetGroupTargetGroupHealthDnsFailover): TargetGroupTargetGroupHealthDnsFailover = TargetGroupTargetGroupHealthDnsFailover(
            minimumHealthyTargetsCount = javaType.minimumHealthyTargetsCount().map({ args0 ->
                args0
            }).orElse(null),
            minimumHealthyTargetsPercentage = javaType.minimumHealthyTargetsPercentage().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
