@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property minimumHealthyTargetsCount The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
 * @property minimumHealthyTargetsPercentage The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
 */
public data class TargetGroupTargetGroupHealthUnhealthyStateRouting(
    public val minimumHealthyTargetsCount: Int? = null,
    public val minimumHealthyTargetsPercentage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lb.outputs.TargetGroupTargetGroupHealthUnhealthyStateRouting): TargetGroupTargetGroupHealthUnhealthyStateRouting =
            TargetGroupTargetGroupHealthUnhealthyStateRouting(
                minimumHealthyTargetsCount = javaType.minimumHealthyTargetsCount().map({ args0 ->
                    args0
                }).orElse(null),
                minimumHealthyTargetsPercentage = javaType.minimumHealthyTargetsPercentage().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
