@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.BotAbortStatement
import com.pulumi.aws.lex.kotlin.outputs.BotClarificationPrompt
import com.pulumi.aws.lex.kotlin.outputs.BotIntent
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lex.kotlin.outputs.BotAbortStatement.Companion.toKotlin as botAbortStatementToKotlin
import com.pulumi.aws.lex.kotlin.outputs.BotClarificationPrompt.Companion.toKotlin as botClarificationPromptToKotlin
import com.pulumi.aws.lex.kotlin.outputs.BotIntent.Companion.toKotlin as botIntentToKotlin

/**
 * Builder for [Bot].
 */
@PulumiTagMarker
public class BotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BotArgs = BotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BotArgsBuilder.() -> Unit) {
        val builder = BotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Bot {
        val builtJavaResource = com.pulumi.aws.lex.Bot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Bot(builtJavaResource)
    }
}

/**
 * Provides an Amazon Lex Bot resource. For more information see
 * [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const orderFlowersBot = new aws.lex.Bot("order_flowers_bot", {
 *     abortStatement: {
 *         messages: [{
 *             content: "Sorry, I am not able to assist at this time",
 *             contentType: "PlainText",
 *         }],
 *     },
 *     childDirected: false,
 *     clarificationPrompt: {
 *         maxAttempts: 2,
 *         messages: [{
 *             content: "I didn't understand you, what would you like to do?",
 *             contentType: "PlainText",
 *         }],
 *     },
 *     createVersion: false,
 *     description: "Bot to order flowers on the behalf of a user",
 *     idleSessionTtlInSeconds: 600,
 *     intents: [{
 *         intentName: "OrderFlowers",
 *         intentVersion: "1",
 *     }],
 *     locale: "en-US",
 *     name: "OrderFlowers",
 *     processBehavior: "BUILD",
 *     voiceId: "Salli",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * order_flowers_bot = aws.lex.Bot("order_flowers_bot",
 *     abort_statement={
 *         "messages": [{
 *             "content": "Sorry, I am not able to assist at this time",
 *             "content_type": "PlainText",
 *         }],
 *     },
 *     child_directed=False,
 *     clarification_prompt={
 *         "max_attempts": 2,
 *         "messages": [{
 *             "content": "I didn't understand you, what would you like to do?",
 *             "content_type": "PlainText",
 *         }],
 *     },
 *     create_version=False,
 *     description="Bot to order flowers on the behalf of a user",
 *     idle_session_ttl_in_seconds=600,
 *     intents=[{
 *         "intent_name": "OrderFlowers",
 *         "intent_version": "1",
 *     }],
 *     locale="en-US",
 *     name="OrderFlowers",
 *     process_behavior="BUILD",
 *     voice_id="Salli")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderFlowersBot = new Aws.Lex.Bot("order_flowers_bot", new()
 *     {
 *         AbortStatement = new Aws.Lex.Inputs.BotAbortStatementArgs
 *         {
 *             Messages = new[]
 *             {
 *                 new Aws.Lex.Inputs.BotAbortStatementMessageArgs
 *                 {
 *                     Content = "Sorry, I am not able to assist at this time",
 *                     ContentType = "PlainText",
 *                 },
 *             },
 *         },
 *         ChildDirected = false,
 *         ClarificationPrompt = new Aws.Lex.Inputs.BotClarificationPromptArgs
 *         {
 *             MaxAttempts = 2,
 *             Messages = new[]
 *             {
 *                 new Aws.Lex.Inputs.BotClarificationPromptMessageArgs
 *                 {
 *                     Content = "I didn't understand you, what would you like to do?",
 *                     ContentType = "PlainText",
 *                 },
 *             },
 *         },
 *         CreateVersion = false,
 *         Description = "Bot to order flowers on the behalf of a user",
 *         IdleSessionTtlInSeconds = 600,
 *         Intents = new[]
 *         {
 *             new Aws.Lex.Inputs.BotIntentArgs
 *             {
 *                 IntentName = "OrderFlowers",
 *                 IntentVersion = "1",
 *             },
 *         },
 *         Locale = "en-US",
 *         Name = "OrderFlowers",
 *         ProcessBehavior = "BUILD",
 *         VoiceId = "Salli",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lex.NewBot(ctx, "order_flowers_bot", &lex.BotArgs{
 * 			AbortStatement: &lex.BotAbortStatementArgs{
 * 				Messages: lex.BotAbortStatementMessageArray{
 * 					&lex.BotAbortStatementMessageArgs{
 * 						Content:     pulumi.String("Sorry, I am not able to assist at this time"),
 * 						ContentType: pulumi.String("PlainText"),
 * 					},
 * 				},
 * 			},
 * 			ChildDirected: pulumi.Bool(false),
 * 			ClarificationPrompt: &lex.BotClarificationPromptArgs{
 * 				MaxAttempts: pulumi.Int(2),
 * 				Messages: lex.BotClarificationPromptMessageArray{
 * 					&lex.BotClarificationPromptMessageArgs{
 * 						Content:     pulumi.String("I didn't understand you, what would you like to do?"),
 * 						ContentType: pulumi.String("PlainText"),
 * 					},
 * 				},
 * 			},
 * 			CreateVersion:           pulumi.Bool(false),
 * 			Description:             pulumi.String("Bot to order flowers on the behalf of a user"),
 * 			IdleSessionTtlInSeconds: pulumi.Int(600),
 * 			Intents: lex.BotIntentArray{
 * 				&lex.BotIntentArgs{
 * 					IntentName:    pulumi.String("OrderFlowers"),
 * 					IntentVersion: pulumi.String("1"),
 * 				},
 * 			},
 * 			Locale:          pulumi.String("en-US"),
 * 			Name:            pulumi.String("OrderFlowers"),
 * 			ProcessBehavior: pulumi.String("BUILD"),
 * 			VoiceId:         pulumi.String("Salli"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.Bot;
 * import com.pulumi.aws.lex.BotArgs;
 * import com.pulumi.aws.lex.inputs.BotAbortStatementArgs;
 * import com.pulumi.aws.lex.inputs.BotClarificationPromptArgs;
 * import com.pulumi.aws.lex.inputs.BotIntentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderFlowersBot = new Bot("orderFlowersBot", BotArgs.builder()
 *             .abortStatement(BotAbortStatementArgs.builder()
 *                 .messages(BotAbortStatementMessageArgs.builder()
 *                     .content("Sorry, I am not able to assist at this time")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .childDirected(false)
 *             .clarificationPrompt(BotClarificationPromptArgs.builder()
 *                 .maxAttempts(2)
 *                 .messages(BotClarificationPromptMessageArgs.builder()
 *                     .content("I didn't understand you, what would you like to do?")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .createVersion(false)
 *             .description("Bot to order flowers on the behalf of a user")
 *             .idleSessionTtlInSeconds(600)
 *             .intents(BotIntentArgs.builder()
 *                 .intentName("OrderFlowers")
 *                 .intentVersion("1")
 *                 .build())
 *             .locale("en-US")
 *             .name("OrderFlowers")
 *             .processBehavior("BUILD")
 *             .voiceId("Salli")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   orderFlowersBot:
 *     type: aws:lex:Bot
 *     name: order_flowers_bot
 *     properties:
 *       abortStatement:
 *         messages:
 *           - content: Sorry, I am not able to assist at this time
 *             contentType: PlainText
 *       childDirected: false
 *       clarificationPrompt:
 *         maxAttempts: 2
 *         messages:
 *           - content: I didn't understand you, what would you like to do?
 *             contentType: PlainText
 *       createVersion: false
 *       description: Bot to order flowers on the behalf of a user
 *       idleSessionTtlInSeconds: 600
 *       intents:
 *         - intentName: OrderFlowers
 *           intentVersion: '1'
 *       locale: en-US
 *       name: OrderFlowers
 *       processBehavior: BUILD
 *       voiceId: Salli
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import bots using their name. For example:
 * ```sh
 * $ pulumi import aws:lex/bot:Bot order_flowers_bot OrderFlowers
 * ```
 */
public class Bot internal constructor(
    override val javaResource: com.pulumi.aws.lex.Bot,
) : KotlinCustomResource(javaResource, BotMapper) {
    /**
     * The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
     */
    public val abortStatement: Output<BotAbortStatement>
        get() = javaResource.abortStatement().applyValue({ args0 ->
            args0.let({ args0 ->
                botAbortStatementToKotlin(args0)
            })
        })

    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Checksum identifying the version of the bot that was created. The checksum is not
     * included as an argument because the resource will add it automatically when updating the bot.
     */
    public val checksum: Output<String>
        get() = javaResource.checksum().applyValue({ args0 -> args0 })

    /**
     * By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws&#46;amazon&#46;com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
     */
    public val childDirected: Output<Boolean>
        get() = javaResource.childDirected().applyValue({ args0 -> args0 })

    /**
     * The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
     */
    public val clarificationPrompt: Output<BotClarificationPrompt>?
        get() = javaResource.clarificationPrompt().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> botClarificationPromptToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
     */
    public val createVersion: Output<Boolean>?
        get() = javaResource.createVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date when the bot version was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * A description of the bot. Must be less than or equal to 200 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
     */
    public val detectSentiment: Output<Boolean>?
        get() = javaResource.detectSentiment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs&#46;aws&#46;amazon&#46;com/lex/latest/dg/confidence-scores&#46;html)&#46; You can only set the `enable_model_improvements` parameter in certain Regions&#46; If you set the parameter to true, your bot has access to accuracy improvements&#46; For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
     */
    public val enableModelImprovements: Output<Boolean>?
        get() = javaResource.enableModelImprovements().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If status is FAILED, Amazon Lex provides the reason that it failed to build the bot.
     */
    public val failureReason: Output<String>
        get() = javaResource.failureReason().applyValue({ args0 -> args0 })

    /**
     * The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
     */
    public val idleSessionTtlInSeconds: Output<Int>?
        get() = javaResource.idleSessionTtlInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
     */
    public val intents: Output<List<BotIntent>>
        get() = javaResource.intents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    botIntentToKotlin(args0)
                })
            })
        })

    /**
     * The date when the $LATEST version of this bot was updated.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
     */
    public val locale: Output<String>?
        get() = javaResource.locale().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
     */
    public val nluIntentConfidenceThreshold: Output<Double>?
        get() = javaResource.nluIntentConfidenceThreshold().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
     */
    public val processBehavior: Output<String>?
        get() = javaResource.processBehavior().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When you send a request to create or update a bot, Amazon Lex sets the status response
     * element to BUILDING. After Amazon Lex builds the bot, it sets status to READY. If Amazon Lex can't
     * build the bot, it sets status to FAILED. Amazon Lex returns the reason for the failure in the
     * failure_reason response element.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The version of the bot.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
     */
    public val voiceId: Output<String>
        get() = javaResource.voiceId().applyValue({ args0 -> args0 })
}

public object BotMapper : ResourceMapper<Bot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.Bot::class == javaResource::class

    override fun map(javaResource: Resource): Bot = Bot(javaResource as com.pulumi.aws.lex.Bot)
}

/**
 * @see [Bot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Bot].
 */
public suspend fun bot(name: String, block: suspend BotResourceBuilder.() -> Unit): Bot {
    val builder = BotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Bot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bot(name: String): Bot {
    val builder = BotResourceBuilder()
    builder.name(name)
    return builder.build()
}
