@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.BotArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.BotAbortStatementArgs
import com.pulumi.aws.lex.kotlin.inputs.BotAbortStatementArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.BotClarificationPromptArgs
import com.pulumi.aws.lex.kotlin.inputs.BotClarificationPromptArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.BotIntentArgs
import com.pulumi.aws.lex.kotlin.inputs.BotIntentArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Lex Bot resource. For more information see
 * [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const orderFlowersBot = new aws.lex.Bot("order_flowers_bot", {
 *     abortStatement: {
 *         messages: [{
 *             content: "Sorry, I am not able to assist at this time",
 *             contentType: "PlainText",
 *         }],
 *     },
 *     childDirected: false,
 *     clarificationPrompt: {
 *         maxAttempts: 2,
 *         messages: [{
 *             content: "I didn't understand you, what would you like to do?",
 *             contentType: "PlainText",
 *         }],
 *     },
 *     createVersion: false,
 *     description: "Bot to order flowers on the behalf of a user",
 *     idleSessionTtlInSeconds: 600,
 *     intents: [{
 *         intentName: "OrderFlowers",
 *         intentVersion: "1",
 *     }],
 *     locale: "en-US",
 *     name: "OrderFlowers",
 *     processBehavior: "BUILD",
 *     voiceId: "Salli",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * order_flowers_bot = aws.lex.Bot("order_flowers_bot",
 *     abort_statement={
 *         "messages": [{
 *             "content": "Sorry, I am not able to assist at this time",
 *             "content_type": "PlainText",
 *         }],
 *     },
 *     child_directed=False,
 *     clarification_prompt={
 *         "max_attempts": 2,
 *         "messages": [{
 *             "content": "I didn't understand you, what would you like to do?",
 *             "content_type": "PlainText",
 *         }],
 *     },
 *     create_version=False,
 *     description="Bot to order flowers on the behalf of a user",
 *     idle_session_ttl_in_seconds=600,
 *     intents=[{
 *         "intent_name": "OrderFlowers",
 *         "intent_version": "1",
 *     }],
 *     locale="en-US",
 *     name="OrderFlowers",
 *     process_behavior="BUILD",
 *     voice_id="Salli")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderFlowersBot = new Aws.Lex.Bot("order_flowers_bot", new()
 *     {
 *         AbortStatement = new Aws.Lex.Inputs.BotAbortStatementArgs
 *         {
 *             Messages = new[]
 *             {
 *                 new Aws.Lex.Inputs.BotAbortStatementMessageArgs
 *                 {
 *                     Content = "Sorry, I am not able to assist at this time",
 *                     ContentType = "PlainText",
 *                 },
 *             },
 *         },
 *         ChildDirected = false,
 *         ClarificationPrompt = new Aws.Lex.Inputs.BotClarificationPromptArgs
 *         {
 *             MaxAttempts = 2,
 *             Messages = new[]
 *             {
 *                 new Aws.Lex.Inputs.BotClarificationPromptMessageArgs
 *                 {
 *                     Content = "I didn't understand you, what would you like to do?",
 *                     ContentType = "PlainText",
 *                 },
 *             },
 *         },
 *         CreateVersion = false,
 *         Description = "Bot to order flowers on the behalf of a user",
 *         IdleSessionTtlInSeconds = 600,
 *         Intents = new[]
 *         {
 *             new Aws.Lex.Inputs.BotIntentArgs
 *             {
 *                 IntentName = "OrderFlowers",
 *                 IntentVersion = "1",
 *             },
 *         },
 *         Locale = "en-US",
 *         Name = "OrderFlowers",
 *         ProcessBehavior = "BUILD",
 *         VoiceId = "Salli",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lex.NewBot(ctx, "order_flowers_bot", &lex.BotArgs{
 * 			AbortStatement: &lex.BotAbortStatementArgs{
 * 				Messages: lex.BotAbortStatementMessageArray{
 * 					&lex.BotAbortStatementMessageArgs{
 * 						Content:     pulumi.String("Sorry, I am not able to assist at this time"),
 * 						ContentType: pulumi.String("PlainText"),
 * 					},
 * 				},
 * 			},
 * 			ChildDirected: pulumi.Bool(false),
 * 			ClarificationPrompt: &lex.BotClarificationPromptArgs{
 * 				MaxAttempts: pulumi.Int(2),
 * 				Messages: lex.BotClarificationPromptMessageArray{
 * 					&lex.BotClarificationPromptMessageArgs{
 * 						Content:     pulumi.String("I didn't understand you, what would you like to do?"),
 * 						ContentType: pulumi.String("PlainText"),
 * 					},
 * 				},
 * 			},
 * 			CreateVersion:           pulumi.Bool(false),
 * 			Description:             pulumi.String("Bot to order flowers on the behalf of a user"),
 * 			IdleSessionTtlInSeconds: pulumi.Int(600),
 * 			Intents: lex.BotIntentArray{
 * 				&lex.BotIntentArgs{
 * 					IntentName:    pulumi.String("OrderFlowers"),
 * 					IntentVersion: pulumi.String("1"),
 * 				},
 * 			},
 * 			Locale:          pulumi.String("en-US"),
 * 			Name:            pulumi.String("OrderFlowers"),
 * 			ProcessBehavior: pulumi.String("BUILD"),
 * 			VoiceId:         pulumi.String("Salli"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.Bot;
 * import com.pulumi.aws.lex.BotArgs;
 * import com.pulumi.aws.lex.inputs.BotAbortStatementArgs;
 * import com.pulumi.aws.lex.inputs.BotClarificationPromptArgs;
 * import com.pulumi.aws.lex.inputs.BotIntentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderFlowersBot = new Bot("orderFlowersBot", BotArgs.builder()
 *             .abortStatement(BotAbortStatementArgs.builder()
 *                 .messages(BotAbortStatementMessageArgs.builder()
 *                     .content("Sorry, I am not able to assist at this time")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .childDirected(false)
 *             .clarificationPrompt(BotClarificationPromptArgs.builder()
 *                 .maxAttempts(2)
 *                 .messages(BotClarificationPromptMessageArgs.builder()
 *                     .content("I didn't understand you, what would you like to do?")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .createVersion(false)
 *             .description("Bot to order flowers on the behalf of a user")
 *             .idleSessionTtlInSeconds(600)
 *             .intents(BotIntentArgs.builder()
 *                 .intentName("OrderFlowers")
 *                 .intentVersion("1")
 *                 .build())
 *             .locale("en-US")
 *             .name("OrderFlowers")
 *             .processBehavior("BUILD")
 *             .voiceId("Salli")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   orderFlowersBot:
 *     type: aws:lex:Bot
 *     name: order_flowers_bot
 *     properties:
 *       abortStatement:
 *         messages:
 *           - content: Sorry, I am not able to assist at this time
 *             contentType: PlainText
 *       childDirected: false
 *       clarificationPrompt:
 *         maxAttempts: 2
 *         messages:
 *           - content: I didn't understand you, what would you like to do?
 *             contentType: PlainText
 *       createVersion: false
 *       description: Bot to order flowers on the behalf of a user
 *       idleSessionTtlInSeconds: 600
 *       intents:
 *         - intentName: OrderFlowers
 *           intentVersion: '1'
 *       locale: en-US
 *       name: OrderFlowers
 *       processBehavior: BUILD
 *       voiceId: Salli
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import bots using their name. For example:
 * ```sh
 * $ pulumi import aws:lex/bot:Bot order_flowers_bot OrderFlowers
 * ```
 * @property abortStatement The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
 * @property childDirected By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws&#46;amazon&#46;com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
 * @property clarificationPrompt The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
 * @property createVersion Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
 * @property description A description of the bot. Must be less than or equal to 200 characters in length.
 * @property detectSentiment When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
 * @property enableModelImprovements Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs&#46;aws&#46;amazon&#46;com/lex/latest/dg/confidence-scores&#46;html)&#46; You can only set the `enable_model_improvements` parameter in certain Regions&#46; If you set the parameter to true, your bot has access to accuracy improvements&#46; For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
 * @property idleSessionTtlInSeconds The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
 * @property intents A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
 * @property locale Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
 * @property name The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
 * @property nluIntentConfidenceThreshold Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
 * @property processBehavior If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
 * @property voiceId The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
 */
public data class BotArgs(
    public val abortStatement: Output<BotAbortStatementArgs>? = null,
    public val childDirected: Output<Boolean>? = null,
    public val clarificationPrompt: Output<BotClarificationPromptArgs>? = null,
    public val createVersion: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val detectSentiment: Output<Boolean>? = null,
    public val enableModelImprovements: Output<Boolean>? = null,
    public val idleSessionTtlInSeconds: Output<Int>? = null,
    public val intents: Output<List<BotIntentArgs>>? = null,
    public val locale: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nluIntentConfidenceThreshold: Output<Double>? = null,
    public val processBehavior: Output<String>? = null,
    public val voiceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.BotArgs> {
    override fun toJava(): com.pulumi.aws.lex.BotArgs = com.pulumi.aws.lex.BotArgs.builder()
        .abortStatement(abortStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .childDirected(childDirected?.applyValue({ args0 -> args0 }))
        .clarificationPrompt(
            clarificationPrompt?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .createVersion(createVersion?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .detectSentiment(detectSentiment?.applyValue({ args0 -> args0 }))
        .enableModelImprovements(enableModelImprovements?.applyValue({ args0 -> args0 }))
        .idleSessionTtlInSeconds(idleSessionTtlInSeconds?.applyValue({ args0 -> args0 }))
        .intents(
            intents?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .locale(locale?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .nluIntentConfidenceThreshold(nluIntentConfidenceThreshold?.applyValue({ args0 -> args0 }))
        .processBehavior(processBehavior?.applyValue({ args0 -> args0 }))
        .voiceId(voiceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotArgs].
 */
@PulumiTagMarker
public class BotArgsBuilder internal constructor() {
    private var abortStatement: Output<BotAbortStatementArgs>? = null

    private var childDirected: Output<Boolean>? = null

    private var clarificationPrompt: Output<BotClarificationPromptArgs>? = null

    private var createVersion: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var detectSentiment: Output<Boolean>? = null

    private var enableModelImprovements: Output<Boolean>? = null

    private var idleSessionTtlInSeconds: Output<Int>? = null

    private var intents: Output<List<BotIntentArgs>>? = null

    private var locale: Output<String>? = null

    private var name: Output<String>? = null

    private var nluIntentConfidenceThreshold: Output<Double>? = null

    private var processBehavior: Output<String>? = null

    private var voiceId: Output<String>? = null

    /**
     * @param value The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
     */
    @JvmName("scvjbfpqqmqjxgwf")
    public suspend fun abortStatement(`value`: Output<BotAbortStatementArgs>) {
        this.abortStatement = value
    }

    /**
     * @param value By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws&#46;amazon&#46;com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
     */
    @JvmName("wjdmuesrxmhddeta")
    public suspend fun childDirected(`value`: Output<Boolean>) {
        this.childDirected = value
    }

    /**
     * @param value The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
     */
    @JvmName("ptgqoxxyfaisbggn")
    public suspend fun clarificationPrompt(`value`: Output<BotClarificationPromptArgs>) {
        this.clarificationPrompt = value
    }

    /**
     * @param value Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
     */
    @JvmName("willtwtepyjfygaj")
    public suspend fun createVersion(`value`: Output<Boolean>) {
        this.createVersion = value
    }

    /**
     * @param value A description of the bot. Must be less than or equal to 200 characters in length.
     */
    @JvmName("qdpunbusxbvkfntf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
     */
    @JvmName("pqiasgkjfjrddlpa")
    public suspend fun detectSentiment(`value`: Output<Boolean>) {
        this.detectSentiment = value
    }

    /**
     * @param value Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs&#46;aws&#46;amazon&#46;com/lex/latest/dg/confidence-scores&#46;html)&#46; You can only set the `enable_model_improvements` parameter in certain Regions&#46; If you set the parameter to true, your bot has access to accuracy improvements&#46; For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
     */
    @JvmName("oqdyfncmpidenpan")
    public suspend fun enableModelImprovements(`value`: Output<Boolean>) {
        this.enableModelImprovements = value
    }

    /**
     * @param value The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
     */
    @JvmName("bqjtbpsapgynjlod")
    public suspend fun idleSessionTtlInSeconds(`value`: Output<Int>) {
        this.idleSessionTtlInSeconds = value
    }

    /**
     * @param value A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
     */
    @JvmName("tornpmonastukpkk")
    public suspend fun intents(`value`: Output<List<BotIntentArgs>>) {
        this.intents = value
    }

    @JvmName("jjjrfthsqwoyrkam")
    public suspend fun intents(vararg values: Output<BotIntentArgs>) {
        this.intents = Output.all(values.asList())
    }

    /**
     * @param values A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
     */
    @JvmName("phganasefbfqrckw")
    public suspend fun intents(values: List<Output<BotIntentArgs>>) {
        this.intents = Output.all(values)
    }

    /**
     * @param value Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
     */
    @JvmName("tfbjsbmtyktdkifs")
    public suspend fun locale(`value`: Output<String>) {
        this.locale = value
    }

    /**
     * @param value The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
     */
    @JvmName("elmgvchwauqdirnr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
     */
    @JvmName("hytlddlsccsxbjsi")
    public suspend fun nluIntentConfidenceThreshold(`value`: Output<Double>) {
        this.nluIntentConfidenceThreshold = value
    }

    /**
     * @param value If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
     */
    @JvmName("wfancumfvisnogdr")
    public suspend fun processBehavior(`value`: Output<String>) {
        this.processBehavior = value
    }

    /**
     * @param value The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
     */
    @JvmName("wfollsxiiymgrwcs")
    public suspend fun voiceId(`value`: Output<String>) {
        this.voiceId = value
    }

    /**
     * @param value The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
     */
    @JvmName("peakaplmyevwmvfv")
    public suspend fun abortStatement(`value`: BotAbortStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.abortStatement = mapped
    }

    /**
     * @param argument The message that Amazon Lex uses to abort a conversation. Attributes are documented under statement.
     */
    @JvmName("yqpihtkdatmwnyxo")
    public suspend fun abortStatement(argument: suspend BotAbortStatementArgsBuilder.() -> Unit) {
        val toBeMapped = BotAbortStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.abortStatement = mapped
    }

    /**
     * @param value By specifying true, you confirm that your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA. For more information see the [Amazon Lex FAQ](https://aws&#46;amazon&#46;com/lex/faqs#data-security) and the [Amazon Lex PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-childDirected).
     */
    @JvmName("ednwqrmlqnvisnae")
    public suspend fun childDirected(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childDirected = mapped
    }

    /**
     * @param value The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
     */
    @JvmName("mvlplabjhieukigx")
    public suspend fun clarificationPrompt(`value`: BotClarificationPromptArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clarificationPrompt = mapped
    }

    /**
     * @param argument The message that Amazon Lex uses when it doesn't understand the user's request. Attributes are documented under prompt.
     */
    @JvmName("bexmnbyehvgpepik")
    public suspend fun clarificationPrompt(argument: suspend BotClarificationPromptArgsBuilder.() -> Unit) {
        val toBeMapped = BotClarificationPromptArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clarificationPrompt = mapped
    }

    /**
     * @param value Determines if a new bot version is created when the initial resource is created and on each update. Defaults to `false`.
     */
    @JvmName("wijajaijgeehjurd")
    public suspend fun createVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createVersion = mapped
    }

    /**
     * @param value A description of the bot. Must be less than or equal to 200 characters in length.
     */
    @JvmName("avvcvqssxycpkvcw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value When set to true user utterances are sent to Amazon Comprehend for sentiment analysis. If you don't specify detectSentiment, the default is `false`.
     */
    @JvmName("pylbjaldyiufgryg")
    public suspend fun detectSentiment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectSentiment = mapped
    }

    /**
     * @param value Set to `true` to enable access to natural language understanding improvements. When you set the `enable_model_improvements` parameter to true you can use the `nlu_intent_confidence_threshold` parameter to configure confidence scores. For more information, see [Confidence Scores](https://docs&#46;aws&#46;amazon&#46;com/lex/latest/dg/confidence-scores&#46;html)&#46; You can only set the `enable_model_improvements` parameter in certain Regions&#46; If you set the parameter to true, your bot has access to accuracy improvements&#46; For more information see the [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-enableModelImprovements).
     */
    @JvmName("uewtfxwepverqume")
    public suspend fun enableModelImprovements(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableModelImprovements = mapped
    }

    /**
     * @param value The maximum time in seconds that Amazon Lex retains the data gathered in a conversation. Default is `300`. Must be a number between 60 and 86400 (inclusive).
     */
    @JvmName("gfjsuynjshjwumtt")
    public suspend fun idleSessionTtlInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleSessionTtlInSeconds = mapped
    }

    /**
     * @param value A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
     */
    @JvmName("qcvbvlxgksnaommo")
    public suspend fun intents(`value`: List<BotIntentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intents = mapped
    }

    /**
     * @param argument A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
     */
    @JvmName("epwluvfahnlmxwrv")
    public suspend fun intents(argument: List<suspend BotIntentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BotIntentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.intents = mapped
    }

    /**
     * @param argument A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
     */
    @JvmName("mhejuclcigoqnvlp")
    public suspend fun intents(vararg argument: suspend BotIntentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BotIntentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.intents = mapped
    }

    /**
     * @param argument A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
     */
    @JvmName("ojqmjbsrfvakgthe")
    public suspend fun intents(argument: suspend BotIntentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BotIntentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.intents = mapped
    }

    /**
     * @param values A set of Intent objects. Each intent represents a command that a user can express. Attributes are documented under intent. Can have up to 250 Intent objects.
     */
    @JvmName("lpqmoomewpplajgf")
    public suspend fun intents(vararg values: BotIntentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.intents = mapped
    }

    /**
     * @param value Specifies the target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot. For available locales, see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-locale). Default is `en-US`.
     */
    @JvmName("emajqcwpkbiegpqu")
    public suspend fun locale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locale = mapped
    }

    /**
     * @param value The name of the bot that you want to create, case sensitive. Must be between 2 and 50 characters in length.
     */
    @JvmName("vscmokdkiabhxnyl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot. For more information see [Amazon Lex Bot PutBot API Docs](https://docs.aws.amazon.com/lex/latest/dg/API_PutBot.html#lex-PutBot-request-nluIntentConfidenceThreshold) This value requires `enable_model_improvements` to be set to `true` and the default is `0`. Must be a float between 0 and 1.
     */
    @JvmName("rjtgapsmwulguyjg")
    public suspend fun nluIntentConfidenceThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nluIntentConfidenceThreshold = mapped
    }

    /**
     * @param value If you set the `process_behavior` element to `BUILD`, Amazon Lex builds the bot so that it can be run. If you set the element to `SAVE` Amazon Lex saves the bot, but doesn't build it. Default is `SAVE`.
     */
    @JvmName("qvwgeemkqenpxjrh")
    public suspend fun processBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processBehavior = mapped
    }

    /**
     * @param value The Amazon Polly voice ID that you want Amazon Lex to use for voice interactions with the user. The locale configured for the voice must match the locale of the bot. For more information, see [Available Voices](http://docs.aws.amazon.com/polly/latest/dg/voicelist.html) in the Amazon Polly Developer Guide.
     */
    @JvmName("sxulbfkhdgeliepy")
    public suspend fun voiceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.voiceId = mapped
    }

    internal fun build(): BotArgs = BotArgs(
        abortStatement = abortStatement,
        childDirected = childDirected,
        clarificationPrompt = clarificationPrompt,
        createVersion = createVersion,
        description = description,
        detectSentiment = detectSentiment,
        enableModelImprovements = enableModelImprovements,
        idleSessionTtlInSeconds = idleSessionTtlInSeconds,
        intents = intents,
        locale = locale,
        name = name,
        nluIntentConfidenceThreshold = nluIntentConfidenceThreshold,
        processBehavior = processBehavior,
        voiceId = voiceId,
    )
}
