@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.IntentConclusionStatement
import com.pulumi.aws.lex.kotlin.outputs.IntentConfirmationPrompt
import com.pulumi.aws.lex.kotlin.outputs.IntentDialogCodeHook
import com.pulumi.aws.lex.kotlin.outputs.IntentFollowUpPrompt
import com.pulumi.aws.lex.kotlin.outputs.IntentFulfillmentActivity
import com.pulumi.aws.lex.kotlin.outputs.IntentRejectionStatement
import com.pulumi.aws.lex.kotlin.outputs.IntentSlot
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lex.kotlin.outputs.IntentConclusionStatement.Companion.toKotlin as intentConclusionStatementToKotlin
import com.pulumi.aws.lex.kotlin.outputs.IntentConfirmationPrompt.Companion.toKotlin as intentConfirmationPromptToKotlin
import com.pulumi.aws.lex.kotlin.outputs.IntentDialogCodeHook.Companion.toKotlin as intentDialogCodeHookToKotlin
import com.pulumi.aws.lex.kotlin.outputs.IntentFollowUpPrompt.Companion.toKotlin as intentFollowUpPromptToKotlin
import com.pulumi.aws.lex.kotlin.outputs.IntentFulfillmentActivity.Companion.toKotlin as intentFulfillmentActivityToKotlin
import com.pulumi.aws.lex.kotlin.outputs.IntentRejectionStatement.Companion.toKotlin as intentRejectionStatementToKotlin
import com.pulumi.aws.lex.kotlin.outputs.IntentSlot.Companion.toKotlin as intentSlotToKotlin

/**
 * Builder for [Intent].
 */
@PulumiTagMarker
public class IntentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntentArgs = IntentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntentArgsBuilder.() -> Unit) {
        val builder = IntentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Intent {
        val builtJavaResource = com.pulumi.aws.lex.Intent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Intent(builtJavaResource)
    }
}

/**
 * Provides an Amazon Lex Intent resource. For more information see
 * [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const orderFlowersIntent = new aws.lex.Intent("order_flowers_intent", {
 *     confirmationPrompt: {
 *         maxAttempts: 2,
 *         messages: [{
 *             content: "Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?",
 *             contentType: "PlainText",
 *         }],
 *     },
 *     createVersion: false,
 *     name: "OrderFlowers",
 *     description: "Intent to order a bouquet of flowers for pick up",
 *     fulfillmentActivity: {
 *         type: "ReturnIntent",
 *     },
 *     rejectionStatement: {
 *         messages: [{
 *             content: "Okay, I will not place your order.",
 *             contentType: "PlainText",
 *         }],
 *     },
 *     sampleUtterances: [
 *         "I would like to order some flowers",
 *         "I would like to pick up flowers",
 *     ],
 *     slots: [
 *         {
 *             description: "The type of flowers to pick up",
 *             name: "FlowerType",
 *             priority: 1,
 *             sampleUtterances: ["I would like to order {FlowerType}"],
 *             slotConstraint: "Required",
 *             slotType: "FlowerTypes",
 *             slotTypeVersion: "$$LATEST",
 *             valueElicitationPrompt: {
 *                 maxAttempts: 2,
 *                 messages: [{
 *                     content: "What type of flowers would you like to order?",
 *                     contentType: "PlainText",
 *                 }],
 *             },
 *         },
 *         {
 *             description: "The date to pick up the flowers",
 *             name: "PickupDate",
 *             priority: 2,
 *             sampleUtterances: ["I would like to order {FlowerType}"],
 *             slotConstraint: "Required",
 *             slotType: "AMAZON.DATE",
 *             slotTypeVersion: "$$LATEST",
 *             valueElicitationPrompt: {
 *                 maxAttempts: 2,
 *                 messages: [{
 *                     content: "What day do you want the {FlowerType} to be picked up?",
 *                     contentType: "PlainText",
 *                 }],
 *             },
 *         },
 *         {
 *             description: "The time to pick up the flowers",
 *             name: "PickupTime",
 *             priority: 3,
 *             sampleUtterances: ["I would like to order {FlowerType}"],
 *             slotConstraint: "Required",
 *             slotType: "AMAZON.TIME",
 *             slotTypeVersion: "$$LATEST",
 *             valueElicitationPrompt: {
 *                 maxAttempts: 2,
 *                 messages: [{
 *                     content: "Pick up the {FlowerType} at what time on {PickupDate}?",
 *                     contentType: "PlainText",
 *                 }],
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * order_flowers_intent = aws.lex.Intent("order_flowers_intent",
 *     confirmation_prompt={
 *         "max_attempts": 2,
 *         "messages": [{
 *             "content": "Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?",
 *             "content_type": "PlainText",
 *         }],
 *     },
 *     create_version=False,
 *     name="OrderFlowers",
 *     description="Intent to order a bouquet of flowers for pick up",
 *     fulfillment_activity={
 *         "type": "ReturnIntent",
 *     },
 *     rejection_statement={
 *         "messages": [{
 *             "content": "Okay, I will not place your order.",
 *             "content_type": "PlainText",
 *         }],
 *     },
 *     sample_utterances=[
 *         "I would like to order some flowers",
 *         "I would like to pick up flowers",
 *     ],
 *     slots=[
 *         {
 *             "description": "The type of flowers to pick up",
 *             "name": "FlowerType",
 *             "priority": 1,
 *             "sample_utterances": ["I would like to order {FlowerType}"],
 *             "slot_constraint": "Required",
 *             "slot_type": "FlowerTypes",
 *             "slot_type_version": "$$LATEST",
 *             "value_elicitation_prompt": {
 *                 "max_attempts": 2,
 *                 "messages": [{
 *                     "content": "What type of flowers would you like to order?",
 *                     "content_type": "PlainText",
 *                 }],
 *             },
 *         },
 *         {
 *             "description": "The date to pick up the flowers",
 *             "name": "PickupDate",
 *             "priority": 2,
 *             "sample_utterances": ["I would like to order {FlowerType}"],
 *             "slot_constraint": "Required",
 *             "slot_type": "AMAZON.DATE",
 *             "slot_type_version": "$$LATEST",
 *             "value_elicitation_prompt": {
 *                 "max_attempts": 2,
 *                 "messages": [{
 *                     "content": "What day do you want the {FlowerType} to be picked up?",
 *                     "content_type": "PlainText",
 *                 }],
 *             },
 *         },
 *         {
 *             "description": "The time to pick up the flowers",
 *             "name": "PickupTime",
 *             "priority": 3,
 *             "sample_utterances": ["I would like to order {FlowerType}"],
 *             "slot_constraint": "Required",
 *             "slot_type": "AMAZON.TIME",
 *             "slot_type_version": "$$LATEST",
 *             "value_elicitation_prompt": {
 *                 "max_attempts": 2,
 *                 "messages": [{
 *                     "content": "Pick up the {FlowerType} at what time on {PickupDate}?",
 *                     "content_type": "PlainText",
 *                 }],
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderFlowersIntent = new Aws.Lex.Intent("order_flowers_intent", new()
 *     {
 *         ConfirmationPrompt = new Aws.Lex.Inputs.IntentConfirmationPromptArgs
 *         {
 *             MaxAttempts = 2,
 *             Messages = new[]
 *             {
 *                 new Aws.Lex.Inputs.IntentConfirmationPromptMessageArgs
 *                 {
 *                     Content = "Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?",
 *                     ContentType = "PlainText",
 *                 },
 *             },
 *         },
 *         CreateVersion = false,
 *         Name = "OrderFlowers",
 *         Description = "Intent to order a bouquet of flowers for pick up",
 *         FulfillmentActivity = new Aws.Lex.Inputs.IntentFulfillmentActivityArgs
 *         {
 *             Type = "ReturnIntent",
 *         },
 *         RejectionStatement = new Aws.Lex.Inputs.IntentRejectionStatementArgs
 *         {
 *             Messages = new[]
 *             {
 *                 new Aws.Lex.Inputs.IntentRejectionStatementMessageArgs
 *                 {
 *                     Content = "Okay, I will not place your order.",
 *                     ContentType = "PlainText",
 *                 },
 *             },
 *         },
 *         SampleUtterances = new[]
 *         {
 *             "I would like to order some flowers",
 *             "I would like to pick up flowers",
 *         },
 *         Slots = new[]
 *         {
 *             new Aws.Lex.Inputs.IntentSlotArgs
 *             {
 *                 Description = "The type of flowers to pick up",
 *                 Name = "FlowerType",
 *                 Priority = 1,
 *                 SampleUtterances = new[]
 *                 {
 *                     "I would like to order {FlowerType}",
 *                 },
 *                 SlotConstraint = "Required",
 *                 SlotType = "FlowerTypes",
 *                 SlotTypeVersion = "$$LATEST",
 *                 ValueElicitationPrompt = new Aws.Lex.Inputs.IntentSlotValueElicitationPromptArgs
 *                 {
 *                     MaxAttempts = 2,
 *                     Messages = new[]
 *                     {
 *                         new Aws.Lex.Inputs.IntentSlotValueElicitationPromptMessageArgs
 *                         {
 *                             Content = "What type of flowers would you like to order?",
 *                             ContentType = "PlainText",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Lex.Inputs.IntentSlotArgs
 *             {
 *                 Description = "The date to pick up the flowers",
 *                 Name = "PickupDate",
 *                 Priority = 2,
 *                 SampleUtterances = new[]
 *                 {
 *                     "I would like to order {FlowerType}",
 *                 },
 *                 SlotConstraint = "Required",
 *                 SlotType = "AMAZON.DATE",
 *                 SlotTypeVersion = "$$LATEST",
 *                 ValueElicitationPrompt = new Aws.Lex.Inputs.IntentSlotValueElicitationPromptArgs
 *                 {
 *                     MaxAttempts = 2,
 *                     Messages = new[]
 *                     {
 *                         new Aws.Lex.Inputs.IntentSlotValueElicitationPromptMessageArgs
 *                         {
 *                             Content = "What day do you want the {FlowerType} to be picked up?",
 *                             ContentType = "PlainText",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Lex.Inputs.IntentSlotArgs
 *             {
 *                 Description = "The time to pick up the flowers",
 *                 Name = "PickupTime",
 *                 Priority = 3,
 *                 SampleUtterances = new[]
 *                 {
 *                     "I would like to order {FlowerType}",
 *                 },
 *                 SlotConstraint = "Required",
 *                 SlotType = "AMAZON.TIME",
 *                 SlotTypeVersion = "$$LATEST",
 *                 ValueElicitationPrompt = new Aws.Lex.Inputs.IntentSlotValueElicitationPromptArgs
 *                 {
 *                     MaxAttempts = 2,
 *                     Messages = new[]
 *                     {
 *                         new Aws.Lex.Inputs.IntentSlotValueElicitationPromptMessageArgs
 *                         {
 *                             Content = "Pick up the {FlowerType} at what time on {PickupDate}?",
 *                             ContentType = "PlainText",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lex.NewIntent(ctx, "order_flowers_intent", &lex.IntentArgs{
 * 			ConfirmationPrompt: &lex.IntentConfirmationPromptArgs{
 * 				MaxAttempts: pulumi.Int(2),
 * 				Messages: lex.IntentConfirmationPromptMessageArray{
 * 					&lex.IntentConfirmationPromptMessageArgs{
 * 						Content:     pulumi.String("Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?"),
 * 						ContentType: pulumi.String("PlainText"),
 * 					},
 * 				},
 * 			},
 * 			CreateVersion: pulumi.Bool(false),
 * 			Name:          pulumi.String("OrderFlowers"),
 * 			Description:   pulumi.String("Intent to order a bouquet of flowers for pick up"),
 * 			FulfillmentActivity: &lex.IntentFulfillmentActivityArgs{
 * 				Type: pulumi.String("ReturnIntent"),
 * 			},
 * 			RejectionStatement: &lex.IntentRejectionStatementArgs{
 * 				Messages: lex.IntentRejectionStatementMessageArray{
 * 					&lex.IntentRejectionStatementMessageArgs{
 * 						Content:     pulumi.String("Okay, I will not place your order."),
 * 						ContentType: pulumi.String("PlainText"),
 * 					},
 * 				},
 * 			},
 * 			SampleUtterances: pulumi.StringArray{
 * 				pulumi.String("I would like to order some flowers"),
 * 				pulumi.String("I would like to pick up flowers"),
 * 			},
 * 			Slots: lex.IntentSlotArray{
 * 				&lex.IntentSlotArgs{
 * 					Description: pulumi.String("The type of flowers to pick up"),
 * 					Name:        pulumi.String("FlowerType"),
 * 					Priority:    pulumi.Int(1),
 * 					SampleUtterances: pulumi.StringArray{
 * 						pulumi.String("I would like to order {FlowerType}"),
 * 					},
 * 					SlotConstraint:  pulumi.String("Required"),
 * 					SlotType:        pulumi.String("FlowerTypes"),
 * 					SlotTypeVersion: pulumi.String("$$LATEST"),
 * 					ValueElicitationPrompt: &lex.IntentSlotValueElicitationPromptArgs{
 * 						MaxAttempts: pulumi.Int(2),
 * 						Messages: lex.IntentSlotValueElicitationPromptMessageArray{
 * 							&lex.IntentSlotValueElicitationPromptMessageArgs{
 * 								Content:     pulumi.String("What type of flowers would you like to order?"),
 * 								ContentType: pulumi.String("PlainText"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&lex.IntentSlotArgs{
 * 					Description: pulumi.String("The date to pick up the flowers"),
 * 					Name:        pulumi.String("PickupDate"),
 * 					Priority:    pulumi.Int(2),
 * 					SampleUtterances: pulumi.StringArray{
 * 						pulumi.String("I would like to order {FlowerType}"),
 * 					},
 * 					SlotConstraint:  pulumi.String("Required"),
 * 					SlotType:        pulumi.String("AMAZON.DATE"),
 * 					SlotTypeVersion: pulumi.String("$$LATEST"),
 * 					ValueElicitationPrompt: &lex.IntentSlotValueElicitationPromptArgs{
 * 						MaxAttempts: pulumi.Int(2),
 * 						Messages: lex.IntentSlotValueElicitationPromptMessageArray{
 * 							&lex.IntentSlotValueElicitationPromptMessageArgs{
 * 								Content:     pulumi.String("What day do you want the {FlowerType} to be picked up?"),
 * 								ContentType: pulumi.String("PlainText"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&lex.IntentSlotArgs{
 * 					Description: pulumi.String("The time to pick up the flowers"),
 * 					Name:        pulumi.String("PickupTime"),
 * 					Priority:    pulumi.Int(3),
 * 					SampleUtterances: pulumi.StringArray{
 * 						pulumi.String("I would like to order {FlowerType}"),
 * 					},
 * 					SlotConstraint:  pulumi.String("Required"),
 * 					SlotType:        pulumi.String("AMAZON.TIME"),
 * 					SlotTypeVersion: pulumi.String("$$LATEST"),
 * 					ValueElicitationPrompt: &lex.IntentSlotValueElicitationPromptArgs{
 * 						MaxAttempts: pulumi.Int(2),
 * 						Messages: lex.IntentSlotValueElicitationPromptMessageArray{
 * 							&lex.IntentSlotValueElicitationPromptMessageArgs{
 * 								Content:     pulumi.String("Pick up the {FlowerType} at what time on {PickupDate}?"),
 * 								ContentType: pulumi.String("PlainText"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.Intent;
 * import com.pulumi.aws.lex.IntentArgs;
 * import com.pulumi.aws.lex.inputs.IntentConfirmationPromptArgs;
 * import com.pulumi.aws.lex.inputs.IntentFulfillmentActivityArgs;
 * import com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs;
 * import com.pulumi.aws.lex.inputs.IntentSlotArgs;
 * import com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderFlowersIntent = new Intent("orderFlowersIntent", IntentArgs.builder()
 *             .confirmationPrompt(IntentConfirmationPromptArgs.builder()
 *                 .maxAttempts(2)
 *                 .messages(IntentConfirmationPromptMessageArgs.builder()
 *                     .content("Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .createVersion(false)
 *             .name("OrderFlowers")
 *             .description("Intent to order a bouquet of flowers for pick up")
 *             .fulfillmentActivity(IntentFulfillmentActivityArgs.builder()
 *                 .type("ReturnIntent")
 *                 .build())
 *             .rejectionStatement(IntentRejectionStatementArgs.builder()
 *                 .messages(IntentRejectionStatementMessageArgs.builder()
 *                     .content("Okay, I will not place your order.")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .sampleUtterances(
 *                 "I would like to order some flowers",
 *                 "I would like to pick up flowers")
 *             .slots(
 *                 IntentSlotArgs.builder()
 *                     .description("The type of flowers to pick up")
 *                     .name("FlowerType")
 *                     .priority(1)
 *                     .sampleUtterances("I would like to order {FlowerType}")
 *                     .slotConstraint("Required")
 *                     .slotType("FlowerTypes")
 *                     .slotTypeVersion("$$LATEST")
 *                     .valueElicitationPrompt(IntentSlotValueElicitationPromptArgs.builder()
 *                         .maxAttempts(2)
 *                         .messages(IntentSlotValueElicitationPromptMessageArgs.builder()
 *                             .content("What type of flowers would you like to order?")
 *                             .contentType("PlainText")
 *                             .build())
 *                         .build())
 *                     .build(),
 *                 IntentSlotArgs.builder()
 *                     .description("The date to pick up the flowers")
 *                     .name("PickupDate")
 *                     .priority(2)
 *                     .sampleUtterances("I would like to order {FlowerType}")
 *                     .slotConstraint("Required")
 *                     .slotType("AMAZON.DATE")
 *                     .slotTypeVersion("$$LATEST")
 *                     .valueElicitationPrompt(IntentSlotValueElicitationPromptArgs.builder()
 *                         .maxAttempts(2)
 *                         .messages(IntentSlotValueElicitationPromptMessageArgs.builder()
 *                             .content("What day do you want the {FlowerType} to be picked up?")
 *                             .contentType("PlainText")
 *                             .build())
 *                         .build())
 *                     .build(),
 *                 IntentSlotArgs.builder()
 *                     .description("The time to pick up the flowers")
 *                     .name("PickupTime")
 *                     .priority(3)
 *                     .sampleUtterances("I would like to order {FlowerType}")
 *                     .slotConstraint("Required")
 *                     .slotType("AMAZON.TIME")
 *                     .slotTypeVersion("$$LATEST")
 *                     .valueElicitationPrompt(IntentSlotValueElicitationPromptArgs.builder()
 *                         .maxAttempts(2)
 *                         .messages(IntentSlotValueElicitationPromptMessageArgs.builder()
 *                             .content("Pick up the {FlowerType} at what time on {PickupDate}?")
 *                             .contentType("PlainText")
 *                             .build())
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   orderFlowersIntent:
 *     type: aws:lex:Intent
 *     name: order_flowers_intent
 *     properties:
 *       confirmationPrompt:
 *         maxAttempts: 2
 *         messages:
 *           - content: Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?
 *             contentType: PlainText
 *       createVersion: false
 *       name: OrderFlowers
 *       description: Intent to order a bouquet of flowers for pick up
 *       fulfillmentActivity:
 *         type: ReturnIntent
 *       rejectionStatement:
 *         messages:
 *           - content: Okay, I will not place your order.
 *             contentType: PlainText
 *       sampleUtterances:
 *         - I would like to order some flowers
 *         - I would like to pick up flowers
 *       slots:
 *         - description: The type of flowers to pick up
 *           name: FlowerType
 *           priority: 1
 *           sampleUtterances:
 *             - I would like to order {FlowerType}
 *           slotConstraint: Required
 *           slotType: FlowerTypes
 *           slotTypeVersion: $$LATEST
 *           valueElicitationPrompt:
 *             maxAttempts: 2
 *             messages:
 *               - content: What type of flowers would you like to order?
 *                 contentType: PlainText
 *         - description: The date to pick up the flowers
 *           name: PickupDate
 *           priority: 2
 *           sampleUtterances:
 *             - I would like to order {FlowerType}
 *           slotConstraint: Required
 *           slotType: AMAZON.DATE
 *           slotTypeVersion: $$LATEST
 *           valueElicitationPrompt:
 *             maxAttempts: 2
 *             messages:
 *               - content: What day do you want the {FlowerType} to be picked up?
 *                 contentType: PlainText
 *         - description: The time to pick up the flowers
 *           name: PickupTime
 *           priority: 3
 *           sampleUtterances:
 *             - I would like to order {FlowerType}
 *           slotConstraint: Required
 *           slotType: AMAZON.TIME
 *           slotTypeVersion: $$LATEST
 *           valueElicitationPrompt:
 *             maxAttempts: 2
 *             messages:
 *               - content: Pick up the {FlowerType} at what time on {PickupDate}?
 *                 contentType: PlainText
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import intents using their name. For example:
 * ```sh
 * $ pulumi import aws:lex/intent:Intent order_flowers_intent OrderFlowers
 * ```
 */
public class Intent internal constructor(
    override val javaResource: com.pulumi.aws.lex.Intent,
) : KotlinCustomResource(javaResource, IntentMapper) {
    /**
     * The ARN of the Lex intent.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Checksum identifying the version of the intent that was created. The checksum is not
     * included as an argument because the resource will add it automatically when updating the intent.
     */
    public val checksum: Output<String>
        get() = javaResource.checksum().applyValue({ args0 -> args0 })

    /**
     * The statement that you want Amazon Lex to convey to the user
     * after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
     * you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
     * application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
     * mutually exclusive. You can specify only one. Attributes are documented under statement.
     */
    public val conclusionStatement: Output<IntentConclusionStatement>?
        get() = javaResource.conclusionStatement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> intentConclusionStatementToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Prompts the user to confirm the intent. This question should
     * have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
     * or neither. Attributes are documented under prompt.
     */
    public val confirmationPrompt: Output<IntentConfirmationPrompt>?
        get() = javaResource.confirmationPrompt().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> intentConfirmationPromptToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Determines if a new slot type version is created when the initial
     * resource is created and on each update. Defaults to `false`.
     */
    public val createVersion: Output<Boolean>?
        get() = javaResource.createVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date when the intent version was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * A description of the intent. Must be less than or equal to 200 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies a Lambda function to invoke for each user input. You can
     * invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
     */
    public val dialogCodeHook: Output<IntentDialogCodeHook>?
        get() = javaResource.dialogCodeHook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> intentDialogCodeHookToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Amazon Lex uses this prompt to solicit additional activity after
     * fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
     * user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
     * exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
     */
    public val followUpPrompt: Output<IntentFollowUpPrompt>?
        get() = javaResource.followUpPrompt().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> intentFollowUpPromptToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Describes how the intent is fulfilled. For example, after a
     * user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
     * places an order with a local pizza store. Attributes are documented under fulfillment_activity.
     */
    public val fulfillmentActivity: Output<IntentFulfillmentActivity>
        get() = javaResource.fulfillmentActivity().applyValue({ args0 ->
            args0.let({ args0 ->
                intentFulfillmentActivityToKotlin(args0)
            })
        })

    /**
     * The date when the $LATEST version of this intent was updated.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A unique identifier for the built-in intent to base this
     * intent on. To find the signature for an intent, see
     * [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
     * in the Alexa Skills Kit.
     */
    public val parentIntentSignature: Output<String>?
        get() = javaResource.parentIntentSignature().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When the user answers "no" to the question defined in
     * `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
     * canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
     * Attributes are documented under statement.
     */
    public val rejectionStatement: Output<IntentRejectionStatement>?
        get() = javaResource.rejectionStatement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> intentRejectionStatementToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An array of utterances (strings) that a user might say to signal
     * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    public val sampleUtterances: Output<List<String>>?
        get() = javaResource.sampleUtterances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    public val slots: Output<List<IntentSlot>>?
        get() = javaResource.slots().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> intentSlotToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The version of the bot.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object IntentMapper : ResourceMapper<Intent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.Intent::class == javaResource::class

    override fun map(javaResource: Resource): Intent = Intent(
        javaResource as
            com.pulumi.aws.lex.Intent,
    )
}

/**
 * @see [Intent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Intent].
 */
public suspend fun intent(name: String, block: suspend IntentResourceBuilder.() -> Unit): Intent {
    val builder = IntentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Intent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun intent(name: String): Intent {
    val builder = IntentResourceBuilder()
    builder.name(name)
    return builder.build()
}
