@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.IntentArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.IntentConclusionStatementArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentConclusionStatementArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentConfirmationPromptArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentConfirmationPromptArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentDialogCodeHookArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentDialogCodeHookArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentFollowUpPromptArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentFollowUpPromptArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentFulfillmentActivityArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentFulfillmentActivityArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentRejectionStatementArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentRejectionStatementArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.IntentSlotArgs
import com.pulumi.aws.lex.kotlin.inputs.IntentSlotArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Lex Intent resource. For more information see
 * [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const orderFlowersIntent = new aws.lex.Intent("order_flowers_intent", {
 *     confirmationPrompt: {
 *         maxAttempts: 2,
 *         messages: [{
 *             content: "Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?",
 *             contentType: "PlainText",
 *         }],
 *     },
 *     createVersion: false,
 *     name: "OrderFlowers",
 *     description: "Intent to order a bouquet of flowers for pick up",
 *     fulfillmentActivity: {
 *         type: "ReturnIntent",
 *     },
 *     rejectionStatement: {
 *         messages: [{
 *             content: "Okay, I will not place your order.",
 *             contentType: "PlainText",
 *         }],
 *     },
 *     sampleUtterances: [
 *         "I would like to order some flowers",
 *         "I would like to pick up flowers",
 *     ],
 *     slots: [
 *         {
 *             description: "The type of flowers to pick up",
 *             name: "FlowerType",
 *             priority: 1,
 *             sampleUtterances: ["I would like to order {FlowerType}"],
 *             slotConstraint: "Required",
 *             slotType: "FlowerTypes",
 *             slotTypeVersion: "$$LATEST",
 *             valueElicitationPrompt: {
 *                 maxAttempts: 2,
 *                 messages: [{
 *                     content: "What type of flowers would you like to order?",
 *                     contentType: "PlainText",
 *                 }],
 *             },
 *         },
 *         {
 *             description: "The date to pick up the flowers",
 *             name: "PickupDate",
 *             priority: 2,
 *             sampleUtterances: ["I would like to order {FlowerType}"],
 *             slotConstraint: "Required",
 *             slotType: "AMAZON.DATE",
 *             slotTypeVersion: "$$LATEST",
 *             valueElicitationPrompt: {
 *                 maxAttempts: 2,
 *                 messages: [{
 *                     content: "What day do you want the {FlowerType} to be picked up?",
 *                     contentType: "PlainText",
 *                 }],
 *             },
 *         },
 *         {
 *             description: "The time to pick up the flowers",
 *             name: "PickupTime",
 *             priority: 3,
 *             sampleUtterances: ["I would like to order {FlowerType}"],
 *             slotConstraint: "Required",
 *             slotType: "AMAZON.TIME",
 *             slotTypeVersion: "$$LATEST",
 *             valueElicitationPrompt: {
 *                 maxAttempts: 2,
 *                 messages: [{
 *                     content: "Pick up the {FlowerType} at what time on {PickupDate}?",
 *                     contentType: "PlainText",
 *                 }],
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * order_flowers_intent = aws.lex.Intent("order_flowers_intent",
 *     confirmation_prompt={
 *         "max_attempts": 2,
 *         "messages": [{
 *             "content": "Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?",
 *             "content_type": "PlainText",
 *         }],
 *     },
 *     create_version=False,
 *     name="OrderFlowers",
 *     description="Intent to order a bouquet of flowers for pick up",
 *     fulfillment_activity={
 *         "type": "ReturnIntent",
 *     },
 *     rejection_statement={
 *         "messages": [{
 *             "content": "Okay, I will not place your order.",
 *             "content_type": "PlainText",
 *         }],
 *     },
 *     sample_utterances=[
 *         "I would like to order some flowers",
 *         "I would like to pick up flowers",
 *     ],
 *     slots=[
 *         {
 *             "description": "The type of flowers to pick up",
 *             "name": "FlowerType",
 *             "priority": 1,
 *             "sample_utterances": ["I would like to order {FlowerType}"],
 *             "slot_constraint": "Required",
 *             "slot_type": "FlowerTypes",
 *             "slot_type_version": "$$LATEST",
 *             "value_elicitation_prompt": {
 *                 "max_attempts": 2,
 *                 "messages": [{
 *                     "content": "What type of flowers would you like to order?",
 *                     "content_type": "PlainText",
 *                 }],
 *             },
 *         },
 *         {
 *             "description": "The date to pick up the flowers",
 *             "name": "PickupDate",
 *             "priority": 2,
 *             "sample_utterances": ["I would like to order {FlowerType}"],
 *             "slot_constraint": "Required",
 *             "slot_type": "AMAZON.DATE",
 *             "slot_type_version": "$$LATEST",
 *             "value_elicitation_prompt": {
 *                 "max_attempts": 2,
 *                 "messages": [{
 *                     "content": "What day do you want the {FlowerType} to be picked up?",
 *                     "content_type": "PlainText",
 *                 }],
 *             },
 *         },
 *         {
 *             "description": "The time to pick up the flowers",
 *             "name": "PickupTime",
 *             "priority": 3,
 *             "sample_utterances": ["I would like to order {FlowerType}"],
 *             "slot_constraint": "Required",
 *             "slot_type": "AMAZON.TIME",
 *             "slot_type_version": "$$LATEST",
 *             "value_elicitation_prompt": {
 *                 "max_attempts": 2,
 *                 "messages": [{
 *                     "content": "Pick up the {FlowerType} at what time on {PickupDate}?",
 *                     "content_type": "PlainText",
 *                 }],
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderFlowersIntent = new Aws.Lex.Intent("order_flowers_intent", new()
 *     {
 *         ConfirmationPrompt = new Aws.Lex.Inputs.IntentConfirmationPromptArgs
 *         {
 *             MaxAttempts = 2,
 *             Messages = new[]
 *             {
 *                 new Aws.Lex.Inputs.IntentConfirmationPromptMessageArgs
 *                 {
 *                     Content = "Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?",
 *                     ContentType = "PlainText",
 *                 },
 *             },
 *         },
 *         CreateVersion = false,
 *         Name = "OrderFlowers",
 *         Description = "Intent to order a bouquet of flowers for pick up",
 *         FulfillmentActivity = new Aws.Lex.Inputs.IntentFulfillmentActivityArgs
 *         {
 *             Type = "ReturnIntent",
 *         },
 *         RejectionStatement = new Aws.Lex.Inputs.IntentRejectionStatementArgs
 *         {
 *             Messages = new[]
 *             {
 *                 new Aws.Lex.Inputs.IntentRejectionStatementMessageArgs
 *                 {
 *                     Content = "Okay, I will not place your order.",
 *                     ContentType = "PlainText",
 *                 },
 *             },
 *         },
 *         SampleUtterances = new[]
 *         {
 *             "I would like to order some flowers",
 *             "I would like to pick up flowers",
 *         },
 *         Slots = new[]
 *         {
 *             new Aws.Lex.Inputs.IntentSlotArgs
 *             {
 *                 Description = "The type of flowers to pick up",
 *                 Name = "FlowerType",
 *                 Priority = 1,
 *                 SampleUtterances = new[]
 *                 {
 *                     "I would like to order {FlowerType}",
 *                 },
 *                 SlotConstraint = "Required",
 *                 SlotType = "FlowerTypes",
 *                 SlotTypeVersion = "$$LATEST",
 *                 ValueElicitationPrompt = new Aws.Lex.Inputs.IntentSlotValueElicitationPromptArgs
 *                 {
 *                     MaxAttempts = 2,
 *                     Messages = new[]
 *                     {
 *                         new Aws.Lex.Inputs.IntentSlotValueElicitationPromptMessageArgs
 *                         {
 *                             Content = "What type of flowers would you like to order?",
 *                             ContentType = "PlainText",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Lex.Inputs.IntentSlotArgs
 *             {
 *                 Description = "The date to pick up the flowers",
 *                 Name = "PickupDate",
 *                 Priority = 2,
 *                 SampleUtterances = new[]
 *                 {
 *                     "I would like to order {FlowerType}",
 *                 },
 *                 SlotConstraint = "Required",
 *                 SlotType = "AMAZON.DATE",
 *                 SlotTypeVersion = "$$LATEST",
 *                 ValueElicitationPrompt = new Aws.Lex.Inputs.IntentSlotValueElicitationPromptArgs
 *                 {
 *                     MaxAttempts = 2,
 *                     Messages = new[]
 *                     {
 *                         new Aws.Lex.Inputs.IntentSlotValueElicitationPromptMessageArgs
 *                         {
 *                             Content = "What day do you want the {FlowerType} to be picked up?",
 *                             ContentType = "PlainText",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Lex.Inputs.IntentSlotArgs
 *             {
 *                 Description = "The time to pick up the flowers",
 *                 Name = "PickupTime",
 *                 Priority = 3,
 *                 SampleUtterances = new[]
 *                 {
 *                     "I would like to order {FlowerType}",
 *                 },
 *                 SlotConstraint = "Required",
 *                 SlotType = "AMAZON.TIME",
 *                 SlotTypeVersion = "$$LATEST",
 *                 ValueElicitationPrompt = new Aws.Lex.Inputs.IntentSlotValueElicitationPromptArgs
 *                 {
 *                     MaxAttempts = 2,
 *                     Messages = new[]
 *                     {
 *                         new Aws.Lex.Inputs.IntentSlotValueElicitationPromptMessageArgs
 *                         {
 *                             Content = "Pick up the {FlowerType} at what time on {PickupDate}?",
 *                             ContentType = "PlainText",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lex.NewIntent(ctx, "order_flowers_intent", &lex.IntentArgs{
 * 			ConfirmationPrompt: &lex.IntentConfirmationPromptArgs{
 * 				MaxAttempts: pulumi.Int(2),
 * 				Messages: lex.IntentConfirmationPromptMessageArray{
 * 					&lex.IntentConfirmationPromptMessageArgs{
 * 						Content:     pulumi.String("Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?"),
 * 						ContentType: pulumi.String("PlainText"),
 * 					},
 * 				},
 * 			},
 * 			CreateVersion: pulumi.Bool(false),
 * 			Name:          pulumi.String("OrderFlowers"),
 * 			Description:   pulumi.String("Intent to order a bouquet of flowers for pick up"),
 * 			FulfillmentActivity: &lex.IntentFulfillmentActivityArgs{
 * 				Type: pulumi.String("ReturnIntent"),
 * 			},
 * 			RejectionStatement: &lex.IntentRejectionStatementArgs{
 * 				Messages: lex.IntentRejectionStatementMessageArray{
 * 					&lex.IntentRejectionStatementMessageArgs{
 * 						Content:     pulumi.String("Okay, I will not place your order."),
 * 						ContentType: pulumi.String("PlainText"),
 * 					},
 * 				},
 * 			},
 * 			SampleUtterances: pulumi.StringArray{
 * 				pulumi.String("I would like to order some flowers"),
 * 				pulumi.String("I would like to pick up flowers"),
 * 			},
 * 			Slots: lex.IntentSlotArray{
 * 				&lex.IntentSlotArgs{
 * 					Description: pulumi.String("The type of flowers to pick up"),
 * 					Name:        pulumi.String("FlowerType"),
 * 					Priority:    pulumi.Int(1),
 * 					SampleUtterances: pulumi.StringArray{
 * 						pulumi.String("I would like to order {FlowerType}"),
 * 					},
 * 					SlotConstraint:  pulumi.String("Required"),
 * 					SlotType:        pulumi.String("FlowerTypes"),
 * 					SlotTypeVersion: pulumi.String("$$LATEST"),
 * 					ValueElicitationPrompt: &lex.IntentSlotValueElicitationPromptArgs{
 * 						MaxAttempts: pulumi.Int(2),
 * 						Messages: lex.IntentSlotValueElicitationPromptMessageArray{
 * 							&lex.IntentSlotValueElicitationPromptMessageArgs{
 * 								Content:     pulumi.String("What type of flowers would you like to order?"),
 * 								ContentType: pulumi.String("PlainText"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&lex.IntentSlotArgs{
 * 					Description: pulumi.String("The date to pick up the flowers"),
 * 					Name:        pulumi.String("PickupDate"),
 * 					Priority:    pulumi.Int(2),
 * 					SampleUtterances: pulumi.StringArray{
 * 						pulumi.String("I would like to order {FlowerType}"),
 * 					},
 * 					SlotConstraint:  pulumi.String("Required"),
 * 					SlotType:        pulumi.String("AMAZON.DATE"),
 * 					SlotTypeVersion: pulumi.String("$$LATEST"),
 * 					ValueElicitationPrompt: &lex.IntentSlotValueElicitationPromptArgs{
 * 						MaxAttempts: pulumi.Int(2),
 * 						Messages: lex.IntentSlotValueElicitationPromptMessageArray{
 * 							&lex.IntentSlotValueElicitationPromptMessageArgs{
 * 								Content:     pulumi.String("What day do you want the {FlowerType} to be picked up?"),
 * 								ContentType: pulumi.String("PlainText"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&lex.IntentSlotArgs{
 * 					Description: pulumi.String("The time to pick up the flowers"),
 * 					Name:        pulumi.String("PickupTime"),
 * 					Priority:    pulumi.Int(3),
 * 					SampleUtterances: pulumi.StringArray{
 * 						pulumi.String("I would like to order {FlowerType}"),
 * 					},
 * 					SlotConstraint:  pulumi.String("Required"),
 * 					SlotType:        pulumi.String("AMAZON.TIME"),
 * 					SlotTypeVersion: pulumi.String("$$LATEST"),
 * 					ValueElicitationPrompt: &lex.IntentSlotValueElicitationPromptArgs{
 * 						MaxAttempts: pulumi.Int(2),
 * 						Messages: lex.IntentSlotValueElicitationPromptMessageArray{
 * 							&lex.IntentSlotValueElicitationPromptMessageArgs{
 * 								Content:     pulumi.String("Pick up the {FlowerType} at what time on {PickupDate}?"),
 * 								ContentType: pulumi.String("PlainText"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.Intent;
 * import com.pulumi.aws.lex.IntentArgs;
 * import com.pulumi.aws.lex.inputs.IntentConfirmationPromptArgs;
 * import com.pulumi.aws.lex.inputs.IntentFulfillmentActivityArgs;
 * import com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs;
 * import com.pulumi.aws.lex.inputs.IntentSlotArgs;
 * import com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderFlowersIntent = new Intent("orderFlowersIntent", IntentArgs.builder()
 *             .confirmationPrompt(IntentConfirmationPromptArgs.builder()
 *                 .maxAttempts(2)
 *                 .messages(IntentConfirmationPromptMessageArgs.builder()
 *                     .content("Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .createVersion(false)
 *             .name("OrderFlowers")
 *             .description("Intent to order a bouquet of flowers for pick up")
 *             .fulfillmentActivity(IntentFulfillmentActivityArgs.builder()
 *                 .type("ReturnIntent")
 *                 .build())
 *             .rejectionStatement(IntentRejectionStatementArgs.builder()
 *                 .messages(IntentRejectionStatementMessageArgs.builder()
 *                     .content("Okay, I will not place your order.")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .sampleUtterances(
 *                 "I would like to order some flowers",
 *                 "I would like to pick up flowers")
 *             .slots(
 *                 IntentSlotArgs.builder()
 *                     .description("The type of flowers to pick up")
 *                     .name("FlowerType")
 *                     .priority(1)
 *                     .sampleUtterances("I would like to order {FlowerType}")
 *                     .slotConstraint("Required")
 *                     .slotType("FlowerTypes")
 *                     .slotTypeVersion("$$LATEST")
 *                     .valueElicitationPrompt(IntentSlotValueElicitationPromptArgs.builder()
 *                         .maxAttempts(2)
 *                         .messages(IntentSlotValueElicitationPromptMessageArgs.builder()
 *                             .content("What type of flowers would you like to order?")
 *                             .contentType("PlainText")
 *                             .build())
 *                         .build())
 *                     .build(),
 *                 IntentSlotArgs.builder()
 *                     .description("The date to pick up the flowers")
 *                     .name("PickupDate")
 *                     .priority(2)
 *                     .sampleUtterances("I would like to order {FlowerType}")
 *                     .slotConstraint("Required")
 *                     .slotType("AMAZON.DATE")
 *                     .slotTypeVersion("$$LATEST")
 *                     .valueElicitationPrompt(IntentSlotValueElicitationPromptArgs.builder()
 *                         .maxAttempts(2)
 *                         .messages(IntentSlotValueElicitationPromptMessageArgs.builder()
 *                             .content("What day do you want the {FlowerType} to be picked up?")
 *                             .contentType("PlainText")
 *                             .build())
 *                         .build())
 *                     .build(),
 *                 IntentSlotArgs.builder()
 *                     .description("The time to pick up the flowers")
 *                     .name("PickupTime")
 *                     .priority(3)
 *                     .sampleUtterances("I would like to order {FlowerType}")
 *                     .slotConstraint("Required")
 *                     .slotType("AMAZON.TIME")
 *                     .slotTypeVersion("$$LATEST")
 *                     .valueElicitationPrompt(IntentSlotValueElicitationPromptArgs.builder()
 *                         .maxAttempts(2)
 *                         .messages(IntentSlotValueElicitationPromptMessageArgs.builder()
 *                             .content("Pick up the {FlowerType} at what time on {PickupDate}?")
 *                             .contentType("PlainText")
 *                             .build())
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   orderFlowersIntent:
 *     type: aws:lex:Intent
 *     name: order_flowers_intent
 *     properties:
 *       confirmationPrompt:
 *         maxAttempts: 2
 *         messages:
 *           - content: Okay, your {FlowerType} will be ready for pickup by {PickupTime} on {PickupDate}.  Does this sound okay?
 *             contentType: PlainText
 *       createVersion: false
 *       name: OrderFlowers
 *       description: Intent to order a bouquet of flowers for pick up
 *       fulfillmentActivity:
 *         type: ReturnIntent
 *       rejectionStatement:
 *         messages:
 *           - content: Okay, I will not place your order.
 *             contentType: PlainText
 *       sampleUtterances:
 *         - I would like to order some flowers
 *         - I would like to pick up flowers
 *       slots:
 *         - description: The type of flowers to pick up
 *           name: FlowerType
 *           priority: 1
 *           sampleUtterances:
 *             - I would like to order {FlowerType}
 *           slotConstraint: Required
 *           slotType: FlowerTypes
 *           slotTypeVersion: $$LATEST
 *           valueElicitationPrompt:
 *             maxAttempts: 2
 *             messages:
 *               - content: What type of flowers would you like to order?
 *                 contentType: PlainText
 *         - description: The date to pick up the flowers
 *           name: PickupDate
 *           priority: 2
 *           sampleUtterances:
 *             - I would like to order {FlowerType}
 *           slotConstraint: Required
 *           slotType: AMAZON.DATE
 *           slotTypeVersion: $$LATEST
 *           valueElicitationPrompt:
 *             maxAttempts: 2
 *             messages:
 *               - content: What day do you want the {FlowerType} to be picked up?
 *                 contentType: PlainText
 *         - description: The time to pick up the flowers
 *           name: PickupTime
 *           priority: 3
 *           sampleUtterances:
 *             - I would like to order {FlowerType}
 *           slotConstraint: Required
 *           slotType: AMAZON.TIME
 *           slotTypeVersion: $$LATEST
 *           valueElicitationPrompt:
 *             maxAttempts: 2
 *             messages:
 *               - content: Pick up the {FlowerType} at what time on {PickupDate}?
 *                 contentType: PlainText
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import intents using their name. For example:
 * ```sh
 * $ pulumi import aws:lex/intent:Intent order_flowers_intent OrderFlowers
 * ```
 * @property conclusionStatement The statement that you want Amazon Lex to convey to the user
 * after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
 * you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
 * application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
 * mutually exclusive. You can specify only one. Attributes are documented under statement.
 * @property confirmationPrompt Prompts the user to confirm the intent. This question should
 * have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
 * or neither. Attributes are documented under prompt.
 * @property createVersion Determines if a new slot type version is created when the initial
 * resource is created and on each update. Defaults to `false`.
 * @property description A description of the intent. Must be less than or equal to 200 characters in length.
 * @property dialogCodeHook Specifies a Lambda function to invoke for each user input. You can
 * invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
 * @property followUpPrompt Amazon Lex uses this prompt to solicit additional activity after
 * fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
 * user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
 * exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
 * @property fulfillmentActivity Describes how the intent is fulfilled. For example, after a
 * user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
 * places an order with a local pizza store. Attributes are documented under fulfillment_activity.
 * @property name The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
 * @property parentIntentSignature A unique identifier for the built-in intent to base this
 * intent on. To find the signature for an intent, see
 * [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
 * in the Alexa Skills Kit.
 * @property rejectionStatement When the user answers "no" to the question defined in
 * `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
 * canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
 * Attributes are documented under statement.
 * @property sampleUtterances An array of utterances (strings) that a user might say to signal
 * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
 * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
 * @property slots An list of intent slots. At runtime, Amazon Lex elicits required slot values
 * from the user using prompts defined in the slots. Attributes are documented under slot.
 */
public data class IntentArgs(
    public val conclusionStatement: Output<IntentConclusionStatementArgs>? = null,
    public val confirmationPrompt: Output<IntentConfirmationPromptArgs>? = null,
    public val createVersion: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val dialogCodeHook: Output<IntentDialogCodeHookArgs>? = null,
    public val followUpPrompt: Output<IntentFollowUpPromptArgs>? = null,
    public val fulfillmentActivity: Output<IntentFulfillmentActivityArgs>? = null,
    public val name: Output<String>? = null,
    public val parentIntentSignature: Output<String>? = null,
    public val rejectionStatement: Output<IntentRejectionStatementArgs>? = null,
    public val sampleUtterances: Output<List<String>>? = null,
    public val slots: Output<List<IntentSlotArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.IntentArgs> {
    override fun toJava(): com.pulumi.aws.lex.IntentArgs = com.pulumi.aws.lex.IntentArgs.builder()
        .conclusionStatement(
            conclusionStatement?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .confirmationPrompt(
            confirmationPrompt?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .createVersion(createVersion?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .dialogCodeHook(dialogCodeHook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .followUpPrompt(followUpPrompt?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .fulfillmentActivity(
            fulfillmentActivity?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .name(name?.applyValue({ args0 -> args0 }))
        .parentIntentSignature(parentIntentSignature?.applyValue({ args0 -> args0 }))
        .rejectionStatement(
            rejectionStatement?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .sampleUtterances(sampleUtterances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .slots(
            slots?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [IntentArgs].
 */
@PulumiTagMarker
public class IntentArgsBuilder internal constructor() {
    private var conclusionStatement: Output<IntentConclusionStatementArgs>? = null

    private var confirmationPrompt: Output<IntentConfirmationPromptArgs>? = null

    private var createVersion: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var dialogCodeHook: Output<IntentDialogCodeHookArgs>? = null

    private var followUpPrompt: Output<IntentFollowUpPromptArgs>? = null

    private var fulfillmentActivity: Output<IntentFulfillmentActivityArgs>? = null

    private var name: Output<String>? = null

    private var parentIntentSignature: Output<String>? = null

    private var rejectionStatement: Output<IntentRejectionStatementArgs>? = null

    private var sampleUtterances: Output<List<String>>? = null

    private var slots: Output<List<IntentSlotArgs>>? = null

    /**
     * @param value The statement that you want Amazon Lex to convey to the user
     * after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
     * you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
     * application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
     * mutually exclusive. You can specify only one. Attributes are documented under statement.
     */
    @JvmName("halscljwdsdyhnek")
    public suspend fun conclusionStatement(`value`: Output<IntentConclusionStatementArgs>) {
        this.conclusionStatement = value
    }

    /**
     * @param value Prompts the user to confirm the intent. This question should
     * have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
     * or neither. Attributes are documented under prompt.
     */
    @JvmName("rwardnixecekikjk")
    public suspend fun confirmationPrompt(`value`: Output<IntentConfirmationPromptArgs>) {
        this.confirmationPrompt = value
    }

    /**
     * @param value Determines if a new slot type version is created when the initial
     * resource is created and on each update. Defaults to `false`.
     */
    @JvmName("hjglnhspkjkealrb")
    public suspend fun createVersion(`value`: Output<Boolean>) {
        this.createVersion = value
    }

    /**
     * @param value A description of the intent. Must be less than or equal to 200 characters in length.
     */
    @JvmName("olrfyuetoashofpu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies a Lambda function to invoke for each user input. You can
     * invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
     */
    @JvmName("iyrgatbfwelnvbox")
    public suspend fun dialogCodeHook(`value`: Output<IntentDialogCodeHookArgs>) {
        this.dialogCodeHook = value
    }

    /**
     * @param value Amazon Lex uses this prompt to solicit additional activity after
     * fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
     * user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
     * exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
     */
    @JvmName("cdjnfkhiaxxdpevn")
    public suspend fun followUpPrompt(`value`: Output<IntentFollowUpPromptArgs>) {
        this.followUpPrompt = value
    }

    /**
     * @param value Describes how the intent is fulfilled. For example, after a
     * user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
     * places an order with a local pizza store. Attributes are documented under fulfillment_activity.
     */
    @JvmName("ybfgjqnuesyhtych")
    public suspend fun fulfillmentActivity(`value`: Output<IntentFulfillmentActivityArgs>) {
        this.fulfillmentActivity = value
    }

    /**
     * @param value The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("stbvliqmdloqqnoy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A unique identifier for the built-in intent to base this
     * intent on. To find the signature for an intent, see
     * [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
     * in the Alexa Skills Kit.
     */
    @JvmName("kccdrmwbbogutwsl")
    public suspend fun parentIntentSignature(`value`: Output<String>) {
        this.parentIntentSignature = value
    }

    /**
     * @param value When the user answers "no" to the question defined in
     * `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
     * canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
     * Attributes are documented under statement.
     */
    @JvmName("dvhlupavtgtekjut")
    public suspend fun rejectionStatement(`value`: Output<IntentRejectionStatementArgs>) {
        this.rejectionStatement = value
    }

    /**
     * @param value An array of utterances (strings) that a user might say to signal
     * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("hpmlaqjhhjrjblra")
    public suspend fun sampleUtterances(`value`: Output<List<String>>) {
        this.sampleUtterances = value
    }

    @JvmName("hcafktimcfwwuxub")
    public suspend fun sampleUtterances(vararg values: Output<String>) {
        this.sampleUtterances = Output.all(values.asList())
    }

    /**
     * @param values An array of utterances (strings) that a user might say to signal
     * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("mytxrkwscawhvins")
    public suspend fun sampleUtterances(values: List<Output<String>>) {
        this.sampleUtterances = Output.all(values)
    }

    /**
     * @param value An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("mpntugwptqbjffir")
    public suspend fun slots(`value`: Output<List<IntentSlotArgs>>) {
        this.slots = value
    }

    @JvmName("pvopvptbnhioceux")
    public suspend fun slots(vararg values: Output<IntentSlotArgs>) {
        this.slots = Output.all(values.asList())
    }

    /**
     * @param values An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("wvbhvhwmcasmnunr")
    public suspend fun slots(values: List<Output<IntentSlotArgs>>) {
        this.slots = Output.all(values)
    }

    /**
     * @param value The statement that you want Amazon Lex to convey to the user
     * after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
     * you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
     * application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
     * mutually exclusive. You can specify only one. Attributes are documented under statement.
     */
    @JvmName("fkvdmejwvngqnkif")
    public suspend fun conclusionStatement(`value`: IntentConclusionStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conclusionStatement = mapped
    }

    /**
     * @param argument The statement that you want Amazon Lex to convey to the user
     * after the intent is successfully fulfilled by the Lambda function. This element is relevant only if
     * you provide a Lambda function in the `fulfillment_activity`. If you return the intent to the client
     * application, you can't specify this element. The `follow_up_prompt` and `conclusion_statement` are
     * mutually exclusive. You can specify only one. Attributes are documented under statement.
     */
    @JvmName("rislqmpyfgkqdgsb")
    public suspend fun conclusionStatement(argument: suspend IntentConclusionStatementArgsBuilder.() -> Unit) {
        val toBeMapped = IntentConclusionStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.conclusionStatement = mapped
    }

    /**
     * @param value Prompts the user to confirm the intent. This question should
     * have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
     * or neither. Attributes are documented under prompt.
     */
    @JvmName("usinpvhhspqjoqve")
    public suspend fun confirmationPrompt(`value`: IntentConfirmationPromptArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmationPrompt = mapped
    }

    /**
     * @param argument Prompts the user to confirm the intent. This question should
     * have a yes or no answer. You you must provide both the `rejection_statement` and `confirmation_prompt`,
     * or neither. Attributes are documented under prompt.
     */
    @JvmName("vteebvylrmgbhvqr")
    public suspend fun confirmationPrompt(argument: suspend IntentConfirmationPromptArgsBuilder.() -> Unit) {
        val toBeMapped = IntentConfirmationPromptArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.confirmationPrompt = mapped
    }

    /**
     * @param value Determines if a new slot type version is created when the initial
     * resource is created and on each update. Defaults to `false`.
     */
    @JvmName("wwxbjkwdehiktbmh")
    public suspend fun createVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createVersion = mapped
    }

    /**
     * @param value A description of the intent. Must be less than or equal to 200 characters in length.
     */
    @JvmName("mkxhferbqcrsaltk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies a Lambda function to invoke for each user input. You can
     * invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
     */
    @JvmName("ikwmlleijtpebuke")
    public suspend fun dialogCodeHook(`value`: IntentDialogCodeHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialogCodeHook = mapped
    }

    /**
     * @param argument Specifies a Lambda function to invoke for each user input. You can
     * invoke this Lambda function to personalize user interaction. Attributes are documented under code_hook.
     */
    @JvmName("diftxkonphhlsnsx")
    public suspend fun dialogCodeHook(argument: suspend IntentDialogCodeHookArgsBuilder.() -> Unit) {
        val toBeMapped = IntentDialogCodeHookArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dialogCodeHook = mapped
    }

    /**
     * @param value Amazon Lex uses this prompt to solicit additional activity after
     * fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
     * user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
     * exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
     */
    @JvmName("gtgbhupwhbqdbcjx")
    public suspend fun followUpPrompt(`value`: IntentFollowUpPromptArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.followUpPrompt = mapped
    }

    /**
     * @param argument Amazon Lex uses this prompt to solicit additional activity after
     * fulfilling an intent. For example, after the OrderPizza intent is fulfilled, you might prompt the
     * user to order a drink. The `follow_up_prompt` field and the `conclusion_statement` field are mutually
     * exclusive. You can specify only one. Attributes are documented under follow_up_prompt.
     */
    @JvmName("lbwvqkugtxhhltjm")
    public suspend fun followUpPrompt(argument: suspend IntentFollowUpPromptArgsBuilder.() -> Unit) {
        val toBeMapped = IntentFollowUpPromptArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.followUpPrompt = mapped
    }

    /**
     * @param value Describes how the intent is fulfilled. For example, after a
     * user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
     * places an order with a local pizza store. Attributes are documented under fulfillment_activity.
     */
    @JvmName("hjjqnqrvqjsjcxtp")
    public suspend fun fulfillmentActivity(`value`: IntentFulfillmentActivityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fulfillmentActivity = mapped
    }

    /**
     * @param argument Describes how the intent is fulfilled. For example, after a
     * user provides all of the information for a pizza order, `fulfillment_activity` defines how the bot
     * places an order with a local pizza store. Attributes are documented under fulfillment_activity.
     */
    @JvmName("dlsyxhrbenjtttnf")
    public suspend fun fulfillmentActivity(argument: suspend IntentFulfillmentActivityArgsBuilder.() -> Unit) {
        val toBeMapped = IntentFulfillmentActivityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fulfillmentActivity = mapped
    }

    /**
     * @param value The name of the intent, not case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("tkttncrsbcucqmcc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A unique identifier for the built-in intent to base this
     * intent on. To find the signature for an intent, see
     * [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
     * in the Alexa Skills Kit.
     */
    @JvmName("qxtqxepexihnuwjk")
    public suspend fun parentIntentSignature(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentIntentSignature = mapped
    }

    /**
     * @param value When the user answers "no" to the question defined in
     * `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
     * canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
     * Attributes are documented under statement.
     */
    @JvmName("tdymknjqrxgajpac")
    public suspend fun rejectionStatement(`value`: IntentRejectionStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rejectionStatement = mapped
    }

    /**
     * @param argument When the user answers "no" to the question defined in
     * `confirmation_prompt`, Amazon Lex responds with this statement to acknowledge that the intent was
     * canceled. You must provide both the `rejection_statement` and the `confirmation_prompt`, or neither.
     * Attributes are documented under statement.
     */
    @JvmName("enumtwkqqvcrhues")
    public suspend fun rejectionStatement(argument: suspend IntentRejectionStatementArgsBuilder.() -> Unit) {
        val toBeMapped = IntentRejectionStatementArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rejectionStatement = mapped
    }

    /**
     * @param value An array of utterances (strings) that a user might say to signal
     * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("rygmgigvsqwvbpav")
    public suspend fun sampleUtterances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param values An array of utterances (strings) that a user might say to signal
     * the intent. For example, "I want {PizzaSize} pizza", "Order {Quantity} {PizzaSize} pizzas".
     * In each utterance, a slot name is enclosed in curly braces. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("jkjkvgoyyacjitdk")
    public suspend fun sampleUtterances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param value An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("mafotkvumwauewvx")
    public suspend fun slots(`value`: List<IntentSlotArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    /**
     * @param argument An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("rhehfyfkadclmegc")
    public suspend fun slots(argument: List<suspend IntentSlotArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IntentSlotArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("hxbukxpyybnrtkso")
    public suspend fun slots(vararg argument: suspend IntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IntentSlotArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("skyujmirvgfyqmaw")
    public suspend fun slots(argument: suspend IntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IntentSlotArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param values An list of intent slots. At runtime, Amazon Lex elicits required slot values
     * from the user using prompts defined in the slots. Attributes are documented under slot.
     */
    @JvmName("curkixodyapqbdti")
    public suspend fun slots(vararg values: IntentSlotArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    internal fun build(): IntentArgs = IntentArgs(
        conclusionStatement = conclusionStatement,
        confirmationPrompt = confirmationPrompt,
        createVersion = createVersion,
        description = description,
        dialogCodeHook = dialogCodeHook,
        followUpPrompt = followUpPrompt,
        fulfillmentActivity = fulfillmentActivity,
        name = name,
        parentIntentSignature = parentIntentSignature,
        rejectionStatement = rejectionStatement,
        sampleUtterances = sampleUtterances,
        slots = slots,
    )
}
