@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.SlotTypeEnumerationValue
import com.pulumi.aws.lex.kotlin.outputs.SlotTypeEnumerationValue.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SlotType].
 */
@PulumiTagMarker
public class SlotTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SlotTypeArgs = SlotTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SlotTypeArgsBuilder.() -> Unit) {
        val builder = SlotTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SlotType {
        val builtJavaResource = com.pulumi.aws.lex.SlotType(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SlotType(builtJavaResource)
    }
}

/**
 * Provides an Amazon Lex Slot Type resource. For more information see
 * [Amazon Lex: How It Works](https://docs.aws.amazon.com/lex/latest/dg/how-it-works.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const flowerTypes = new aws.lex.SlotType("flower_types", {
 *     createVersion: true,
 *     description: "Types of flowers to order",
 *     enumerationValues: [
 *         {
 *             synonyms: [
 *                 "Lirium",
 *                 "Martagon",
 *             ],
 *             value: "lilies",
 *         },
 *         {
 *             synonyms: [
 *                 "Eduardoregelia",
 *                 "Podonix",
 *             ],
 *             value: "tulips",
 *         },
 *     ],
 *     name: "FlowerTypes",
 *     valueSelectionStrategy: "ORIGINAL_VALUE",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * flower_types = aws.lex.SlotType("flower_types",
 *     create_version=True,
 *     description="Types of flowers to order",
 *     enumeration_values=[
 *         {
 *             "synonyms": [
 *                 "Lirium",
 *                 "Martagon",
 *             ],
 *             "value": "lilies",
 *         },
 *         {
 *             "synonyms": [
 *                 "Eduardoregelia",
 *                 "Podonix",
 *             ],
 *             "value": "tulips",
 *         },
 *     ],
 *     name="FlowerTypes",
 *     value_selection_strategy="ORIGINAL_VALUE")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var flowerTypes = new Aws.Lex.SlotType("flower_types", new()
 *     {
 *         CreateVersion = true,
 *         Description = "Types of flowers to order",
 *         EnumerationValues = new[]
 *         {
 *             new Aws.Lex.Inputs.SlotTypeEnumerationValueArgs
 *             {
 *                 Synonyms = new[]
 *                 {
 *                     "Lirium",
 *                     "Martagon",
 *                 },
 *                 Value = "lilies",
 *             },
 *             new Aws.Lex.Inputs.SlotTypeEnumerationValueArgs
 *             {
 *                 Synonyms = new[]
 *                 {
 *                     "Eduardoregelia",
 *                     "Podonix",
 *                 },
 *                 Value = "tulips",
 *             },
 *         },
 *         Name = "FlowerTypes",
 *         ValueSelectionStrategy = "ORIGINAL_VALUE",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lex.NewSlotType(ctx, "flower_types", &lex.SlotTypeArgs{
 * 			CreateVersion: pulumi.Bool(true),
 * 			Description:   pulumi.String("Types of flowers to order"),
 * 			EnumerationValues: lex.SlotTypeEnumerationValueArray{
 * 				&lex.SlotTypeEnumerationValueArgs{
 * 					Synonyms: pulumi.StringArray{
 * 						pulumi.String("Lirium"),
 * 						pulumi.String("Martagon"),
 * 					},
 * 					Value: pulumi.String("lilies"),
 * 				},
 * 				&lex.SlotTypeEnumerationValueArgs{
 * 					Synonyms: pulumi.StringArray{
 * 						pulumi.String("Eduardoregelia"),
 * 						pulumi.String("Podonix"),
 * 					},
 * 					Value: pulumi.String("tulips"),
 * 				},
 * 			},
 * 			Name:                   pulumi.String("FlowerTypes"),
 * 			ValueSelectionStrategy: pulumi.String("ORIGINAL_VALUE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.SlotType;
 * import com.pulumi.aws.lex.SlotTypeArgs;
 * import com.pulumi.aws.lex.inputs.SlotTypeEnumerationValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var flowerTypes = new SlotType("flowerTypes", SlotTypeArgs.builder()
 *             .createVersion(true)
 *             .description("Types of flowers to order")
 *             .enumerationValues(
 *                 SlotTypeEnumerationValueArgs.builder()
 *                     .synonyms(
 *                         "Lirium",
 *                         "Martagon")
 *                     .value("lilies")
 *                     .build(),
 *                 SlotTypeEnumerationValueArgs.builder()
 *                     .synonyms(
 *                         "Eduardoregelia",
 *                         "Podonix")
 *                     .value("tulips")
 *                     .build())
 *             .name("FlowerTypes")
 *             .valueSelectionStrategy("ORIGINAL_VALUE")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   flowerTypes:
 *     type: aws:lex:SlotType
 *     name: flower_types
 *     properties:
 *       createVersion: true
 *       description: Types of flowers to order
 *       enumerationValues:
 *         - synonyms:
 *             - Lirium
 *             - Martagon
 *           value: lilies
 *         - synonyms:
 *             - Eduardoregelia
 *             - Podonix
 *           value: tulips
 *       name: FlowerTypes
 *       valueSelectionStrategy: ORIGINAL_VALUE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import slot types using their name. For example:
 * ```sh
 * $ pulumi import aws:lex/slotType:SlotType flower_types FlowerTypes
 * ```
 */
public class SlotType internal constructor(
    override val javaResource: com.pulumi.aws.lex.SlotType,
) : KotlinCustomResource(javaResource, SlotTypeMapper) {
    /**
     * Checksum identifying the version of the slot type that was created. The checksum is
     * not included as an argument because the resource will add it automatically when updating the slot type.
     */
    public val checksum: Output<String>
        get() = javaResource.checksum().applyValue({ args0 -> args0 })

    /**
     * Determines if a new slot type version is created when the initial resource is created and on each
     * update. Defaults to `false`.
     */
    public val createVersion: Output<Boolean>?
        get() = javaResource.createVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date when the slot type version was created.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * A description of the slot type. Must be less than or equal to 200 characters in length.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of EnumerationValue objects that defines the values that
     * the slot type can take. Each value can have a list of synonyms, which are additional values that help
     * train the machine learning model about the values that it resolves for a slot. Attributes are
     * documented under enumeration_value.
     */
    public val enumerationValues: Output<List<SlotTypeEnumerationValue>>
        get() = javaResource.enumerationValues().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The date when the `$LATEST` version of this slot type was updated.
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * The name of the slot type. The name is not case sensitive. Must be less than or equal to 100 characters in length.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Determines the slot resolution strategy that Amazon Lex
     * uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
     * value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
     * if there is a resolution list for the slot, otherwise null is returned. Defaults to `ORIGINAL_VALUE`.
     */
    public val valueSelectionStrategy: Output<String>?
        get() = javaResource.valueSelectionStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the slot type.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object SlotTypeMapper : ResourceMapper<SlotType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.SlotType::class == javaResource::class

    override fun map(javaResource: Resource): SlotType = SlotType(
        javaResource as
            com.pulumi.aws.lex.SlotType,
    )
}

/**
 * @see [SlotType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SlotType].
 */
public suspend fun slotType(name: String, block: suspend SlotTypeResourceBuilder.() -> Unit): SlotType {
    val builder = SlotTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SlotType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun slotType(name: String): SlotType {
    val builder = SlotTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
