@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotDataPrivacy
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotMember
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotDataPrivacy.Companion.toKotlin as v2modelsBotDataPrivacyToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotMember.Companion.toKotlin as v2modelsBotMemberToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsBotTimeouts.Companion.toKotlin as v2modelsBotTimeoutsToKotlin

/**
 * Builder for [V2modelsBot].
 */
@PulumiTagMarker
public class V2modelsBotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V2modelsBotArgs = V2modelsBotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V2modelsBotArgsBuilder.() -> Unit) {
        val builder = V2modelsBotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V2modelsBot {
        val builtJavaResource = com.pulumi.aws.lex.V2modelsBot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V2modelsBot(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lex V2 Models Bot.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lex.V2modelsBot("example", {
 *     name: "example",
 *     dataPrivacies: [{
 *         childDirected: "boolean",
 *     }],
 *     idleSessionTtlInSeconds: 10,
 *     roleArn: "bot_example_arn",
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lex.V2modelsBot("example",
 *     name="example",
 *     data_privacies=[{
 *         "child_directed": "boolean",
 *     }],
 *     idle_session_ttl_in_seconds=10,
 *     role_arn="bot_example_arn",
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lex.V2modelsBot("example", new()
 *     {
 *         Name = "example",
 *         DataPrivacies = new[]
 *         {
 *             new Aws.Lex.Inputs.V2modelsBotDataPrivacyArgs
 *             {
 *                 ChildDirected = "boolean",
 *             },
 *         },
 *         IdleSessionTtlInSeconds = 10,
 *         RoleArn = "bot_example_arn",
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lex.NewV2modelsBot(ctx, "example", &lex.V2modelsBotArgs{
 * 			Name: pulumi.String("example"),
 * 			DataPrivacies: lex.V2modelsBotDataPrivacyArray{
 * 				&lex.V2modelsBotDataPrivacyArgs{
 * 					ChildDirected: pulumi.Bool("boolean"),
 * 				},
 * 			},
 * 			IdleSessionTtlInSeconds: pulumi.Int(10),
 * 			RoleArn:                 pulumi.String("bot_example_arn"),
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsBot;
 * import com.pulumi.aws.lex.V2modelsBotArgs;
 * import com.pulumi.aws.lex.inputs.V2modelsBotDataPrivacyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new V2modelsBot("example", V2modelsBotArgs.builder()
 *             .name("example")
 *             .dataPrivacies(V2modelsBotDataPrivacyArgs.builder()
 *                 .childDirected("boolean")
 *                 .build())
 *             .idleSessionTtlInSeconds(10)
 *             .roleArn("bot_example_arn")
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lex:V2modelsBot
 *     properties:
 *       name: example
 *       dataPrivacies:
 *         - childDirected: boolean
 *       idleSessionTtlInSeconds: 10
 *       roleArn: bot_example_arn
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Bot using the `id`. For example:
 * ```sh
 * $ pulumi import aws:lex/v2modelsBot:V2modelsBot example bot-id-12345678
 * ```
 */
public class V2modelsBot internal constructor(
    override val javaResource: com.pulumi.aws.lex.V2modelsBot,
) : KotlinCustomResource(javaResource, V2modelsBotMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Provides information on additional privacy protections Amazon Lex should use with the bot's data. See `data_privacy`
     */
    public val dataPrivacies: Output<List<V2modelsBotDataPrivacy>>?
        get() = javaResource.dataPrivacies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        v2modelsBotDataPrivacyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Description of the bot. It appears in lists to help you identify a particular bot.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    public val idleSessionTtlInSeconds: Output<Int>
        get() = javaResource.idleSessionTtlInSeconds().applyValue({ args0 -> args0 })

    /**
     * List of bot members in a network to be created. See `bot_members`.
     */
    public val members: Output<List<V2modelsBotMember>>?
        get() = javaResource.members().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> v2modelsBotMemberToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Name of the bot. The bot name must be unique in the account that creates the bot. Type String. Length Constraints: Minimum length of 1. Maximum length of 100.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ARN of an IAM role that has permission to access the bot.
     * The following arguments are optional:
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * List of tags to add to the bot. You can only add tags when you create a bot.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * List of tags to add to the test alias for a bot. You can only add tags when you create a bot.
     */
    public val testBotAliasTags: Output<Map<String, String>>?
        get() = javaResource.testBotAliasTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    public val timeouts: Output<V2modelsBotTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v2modelsBotTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type of a bot to create. Possible values are `"Bot"` and `"BotNetwork"`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object V2modelsBotMapper : ResourceMapper<V2modelsBot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.V2modelsBot::class == javaResource::class

    override fun map(javaResource: Resource): V2modelsBot = V2modelsBot(
        javaResource as
            com.pulumi.aws.lex.V2modelsBot,
    )
}

/**
 * @see [V2modelsBot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V2modelsBot].
 */
public suspend fun v2modelsBot(name: String, block: suspend V2modelsBotResourceBuilder.() -> Unit): V2modelsBot {
    val builder = V2modelsBotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V2modelsBot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v2modelsBot(name: String): V2modelsBot {
    val builder = V2modelsBotResourceBuilder()
    builder.name(name)
    return builder.build()
}
