@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.V2modelsBotVersionArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotVersionLocaleSpecificationArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotVersionLocaleSpecificationArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotVersionTimeoutsArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsBotVersionTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lex V2 Models Bot Version.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.lex.V2modelsBotVersion("test", {
 *     botId: testAwsLexv2models.id,
 *     localeSpecification: {
 *         en_US: {
 *             sourceBotVersion: "DRAFT",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.lex.V2modelsBotVersion("test",
 *     bot_id=test_aws_lexv2models["id"],
 *     locale_specification={
 *         "en_US": {
 *             "source_bot_version": "DRAFT",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Lex.V2modelsBotVersion("test", new()
 *     {
 *         BotId = testAwsLexv2models.Id,
 *         LocaleSpecification =
 *         {
 *             { "en_US", new Aws.Lex.Inputs.V2modelsBotVersionLocaleSpecificationArgs
 *             {
 *                 SourceBotVersion = "DRAFT",
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lex.NewV2modelsBotVersion(ctx, "test", &lex.V2modelsBotVersionArgs{
 * 			BotId: pulumi.Any(testAwsLexv2models.Id),
 * 			LocaleSpecification: lex.V2modelsBotVersionLocaleSpecificationMap{
 * 				"en_US": &lex.V2modelsBotVersionLocaleSpecificationArgs{
 * 					SourceBotVersion: pulumi.String("DRAFT"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsBotVersion;
 * import com.pulumi.aws.lex.V2modelsBotVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new V2modelsBotVersion("test", V2modelsBotVersionArgs.builder()
 *             .botId(testAwsLexv2models.id())
 *             .localeSpecification(Map.of("en_US", Map.of("sourceBotVersion", "DRAFT")))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:lex:V2modelsBotVersion
 *     properties:
 *       botId: ${testAwsLexv2models.id}
 *       localeSpecification:
 *         en_US:
 *           sourceBotVersion: DRAFT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Bot Version using the `id`. For example:
 * ```sh
 * $ pulumi import aws:lex/v2modelsBotVersion:V2modelsBotVersion example id-12345678,1
 * ```
 * @property botId Idientifier of the bot to create the version for.
 * @property botVersion Version number assigned to the version.
 * @property description A description of the version. Use the description to help identify the version in lists.
 * @property localeSpecification Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
 * The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
 * * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
 * @property timeouts
 */
public data class V2modelsBotVersionArgs(
    public val botId: Output<String>? = null,
    public val botVersion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val localeSpecification: Output<Map<String, V2modelsBotVersionLocaleSpecificationArgs>>? =
        null,
    public val timeouts: Output<V2modelsBotVersionTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.V2modelsBotVersionArgs> {
    override fun toJava(): com.pulumi.aws.lex.V2modelsBotVersionArgs =
        com.pulumi.aws.lex.V2modelsBotVersionArgs.builder()
            .botId(botId?.applyValue({ args0 -> args0 }))
            .botVersion(botVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .localeSpecification(
                localeSpecification?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsBotVersionArgs].
 */
@PulumiTagMarker
public class V2modelsBotVersionArgsBuilder internal constructor() {
    private var botId: Output<String>? = null

    private var botVersion: Output<String>? = null

    private var description: Output<String>? = null

    private var localeSpecification: Output<Map<String, V2modelsBotVersionLocaleSpecificationArgs>>? =
        null

    private var timeouts: Output<V2modelsBotVersionTimeoutsArgs>? = null

    /**
     * @param value Idientifier of the bot to create the version for.
     */
    @JvmName("oegugvsdblarbbba")
    public suspend fun botId(`value`: Output<String>) {
        this.botId = value
    }

    /**
     * @param value Version number assigned to the version.
     */
    @JvmName("yihhakxavwhetngj")
    public suspend fun botVersion(`value`: Output<String>) {
        this.botVersion = value
    }

    /**
     * @param value A description of the version. Use the description to help identify the version in lists.
     */
    @JvmName("udmnjeewrpxjyyiv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
     * The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
     * * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
     */
    @JvmName("caqonkpyanytcvli")
    public suspend fun localeSpecification(`value`: Output<Map<String, V2modelsBotVersionLocaleSpecificationArgs>>) {
        this.localeSpecification = value
    }

    /**
     * @param value
     */
    @JvmName("otjgtsfaborebcvo")
    public suspend fun timeouts(`value`: Output<V2modelsBotVersionTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Idientifier of the bot to create the version for.
     */
    @JvmName("sgkfwjcrbvsgxvtc")
    public suspend fun botId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botId = mapped
    }

    /**
     * @param value Version number assigned to the version.
     */
    @JvmName("mpwbqinxjdoxsaxf")
    public suspend fun botVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botVersion = mapped
    }

    /**
     * @param value A description of the version. Use the description to help identify the version in lists.
     */
    @JvmName("uugvqurkprqqnvxo")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
     * The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
     * * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
     */
    @JvmName("uwbrsxxnvywxvgpm")
    public suspend fun localeSpecification(`value`: Map<String, V2modelsBotVersionLocaleSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localeSpecification = mapped
    }

    /**
     * @param argument Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
     * The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
     * * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
     */
    @JvmName("grhsyfiykbruvuoa")
    public suspend fun localeSpecification(vararg argument: Pair<String, suspend V2modelsBotVersionLocaleSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                V2modelsBotVersionLocaleSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.localeSpecification = mapped
    }

    /**
     * @param values Specifies the locales that Amazon Lex adds to this version. You can choose the draft version or any other previously published version for each locale. When you specify a source version, the locale data is copied from the source version to the new version.
     * The attribute value is a map with one or more entries, each of which has a locale name as the key and an object with the following attribute as the value:
     * * `sourceBotVersion` - (Required) The version of a bot used for a bot locale. Valid values: `DRAFT`, a numeric version.
     */
    @JvmName("cblkducjchlnvnly")
    public fun localeSpecification(vararg values: Pair<String, V2modelsBotVersionLocaleSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localeSpecification = mapped
    }

    /**
     * @param value
     */
    @JvmName("cnoaawhklaxvayoi")
    public suspend fun timeouts(`value`: V2modelsBotVersionTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qfibfvwskmadddfl")
    public suspend fun timeouts(argument: suspend V2modelsBotVersionTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsBotVersionTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): V2modelsBotVersionArgs = V2modelsBotVersionArgs(
        botId = botId,
        botVersion = botVersion,
        description = description,
        localeSpecification = localeSpecification,
        timeouts = timeouts,
    )
}
