@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSetting
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSetting
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentDialogCodeHook
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHook
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSetting
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInputContext
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentKendraConfiguration
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentOutputContext
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentSampleUtterance
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentSlotPriority
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSetting.Companion.toKotlin as v2modelsIntentClosingSettingToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSetting.Companion.toKotlin as v2modelsIntentConfirmationSettingToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentDialogCodeHook.Companion.toKotlin as v2modelsIntentDialogCodeHookToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentFulfillmentCodeHook.Companion.toKotlin as v2modelsIntentFulfillmentCodeHookToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInitialResponseSetting.Companion.toKotlin as v2modelsIntentInitialResponseSettingToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentInputContext.Companion.toKotlin as v2modelsIntentInputContextToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentKendraConfiguration.Companion.toKotlin as v2modelsIntentKendraConfigurationToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentOutputContext.Companion.toKotlin as v2modelsIntentOutputContextToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentSampleUtterance.Companion.toKotlin as v2modelsIntentSampleUtteranceToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentSlotPriority.Companion.toKotlin as v2modelsIntentSlotPriorityToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentTimeouts.Companion.toKotlin as v2modelsIntentTimeoutsToKotlin

/**
 * Builder for [V2modelsIntent].
 */
@PulumiTagMarker
public class V2modelsIntentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V2modelsIntentArgs = V2modelsIntentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V2modelsIntentArgsBuilder.() -> Unit) {
        val builder = V2modelsIntentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V2modelsIntent {
        val builtJavaResource = com.pulumi.aws.lex.V2modelsIntent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V2modelsIntent(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Intent using the `intent_id:bot_id:bot_version:locale_id`. For example:
 * ```sh
 * $ pulumi import aws:lex/v2modelsIntent:V2modelsIntent example intent-42874:bot-11376:DRAFT:en_US
 * ```
 */
public class V2modelsIntent internal constructor(
    override val javaResource: com.pulumi.aws.lex.V2modelsIntent,
) : KotlinCustomResource(javaResource, V2modelsIntentMapper) {
    /**
     * Identifier of the bot associated with this intent.
     */
    public val botId: Output<String>
        get() = javaResource.botId().applyValue({ args0 -> args0 })

    /**
     * Version of the bot associated with this intent.
     */
    public val botVersion: Output<String>
        get() = javaResource.botVersion().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
     */
    public val closingSetting: Output<V2modelsIntentClosingSetting>?
        get() = javaResource.closingSetting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsIntentClosingSettingToKotlin(args0) })
            }).orElse(null)
        })

    public val confirmationSetting: Output<V2modelsIntentConfirmationSetting>?
        get() = javaResource.confirmationSetting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsIntentConfirmationSettingToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Timestamp of the date and time that the intent was created.
     */
    public val creationDateTime: Output<String>
        get() = javaResource.creationDateTime().applyValue({ args0 -> args0 })

    /**
     * Description of the intent. Use the description to help identify the intent in lists.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
     */
    public val dialogCodeHook: Output<V2modelsIntentDialogCodeHook>?
        get() = javaResource.dialogCodeHook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsIntentDialogCodeHookToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
     */
    public val fulfillmentCodeHook: Output<V2modelsIntentFulfillmentCodeHook>?
        get() = javaResource.fulfillmentCodeHook().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsIntentFulfillmentCodeHookToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
     */
    public val initialResponseSetting: Output<V2modelsIntentInitialResponseSetting>?
        get() = javaResource.initialResponseSetting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsIntentInitialResponseSettingToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
     */
    public val inputContexts: Output<List<V2modelsIntentInputContext>>?
        get() = javaResource.inputContexts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        v2modelsIntentInputContextToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Unique identifier for the intent.
     */
    public val intentId: Output<String>
        get() = javaResource.intentId().applyValue({ args0 -> args0 })

    /**
     * Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
     */
    public val kendraConfiguration: Output<V2modelsIntentKendraConfiguration>?
        get() = javaResource.kendraConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsIntentKendraConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Timestamp of the last time that the intent was modified.
     */
    public val lastUpdatedDateTime: Output<String>
        get() = javaResource.lastUpdatedDateTime().applyValue({ args0 -> args0 })

    /**
     * Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
     */
    public val localeId: Output<String>
        get() = javaResource.localeId().applyValue({ args0 -> args0 })

    /**
     * Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
     */
    public val outputContexts: Output<List<V2modelsIntentOutputContext>>?
        get() = javaResource.outputContexts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        v2modelsIntentOutputContextToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Identifier for the built-in intent to base this intent on.
     */
    public val parentIntentSignature: Output<String>?
        get() = javaResource.parentIntentSignature().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
     */
    public val sampleUtterances: Output<List<V2modelsIntentSampleUtterance>>?
        get() = javaResource.sampleUtterances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        v2modelsIntentSampleUtteranceToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
     */
    public val slotPriorities: Output<List<V2modelsIntentSlotPriority>>?
        get() = javaResource.slotPriorities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        v2modelsIntentSlotPriorityToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    public val timeouts: Output<V2modelsIntentTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v2modelsIntentTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object V2modelsIntentMapper : ResourceMapper<V2modelsIntent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.V2modelsIntent::class == javaResource::class

    override fun map(javaResource: Resource): V2modelsIntent = V2modelsIntent(
        javaResource as
            com.pulumi.aws.lex.V2modelsIntent,
    )
}

/**
 * @see [V2modelsIntent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V2modelsIntent].
 */
public suspend fun v2modelsIntent(
    name: String,
    block: suspend V2modelsIntentResourceBuilder.() -> Unit,
): V2modelsIntent {
    val builder = V2modelsIntentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V2modelsIntent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v2modelsIntent(name: String): V2modelsIntent {
    val builder = V2modelsIntentResourceBuilder()
    builder.name(name)
    return builder.build()
}
