@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.V2modelsIntentArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentClosingSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentClosingSettingArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentConfirmationSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentConfirmationSettingArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentDialogCodeHookArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentDialogCodeHookArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentFulfillmentCodeHookArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentFulfillmentCodeHookArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentInitialResponseSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentInitialResponseSettingArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentInputContextArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentInputContextArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentKendraConfigurationArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentKendraConfigurationArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentOutputContextArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentOutputContextArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentSampleUtteranceArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentSampleUtteranceArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentSlotPriorityArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentSlotPriorityArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentTimeoutsArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsIntentTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Intent using the `intent_id:bot_id:bot_version:locale_id`. For example:
 * ```sh
 * $ pulumi import aws:lex/v2modelsIntent:V2modelsIntent example intent-42874:bot-11376:DRAFT:en_US
 * ```
 * @property botId Identifier of the bot associated with this intent.
 * @property botVersion Version of the bot associated with this intent.
 * @property closingSetting Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
 * @property confirmationSetting
 * @property description Description of the intent. Use the description to help identify the intent in lists.
 * @property dialogCodeHook Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
 * @property fulfillmentCodeHook Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
 * @property initialResponseSetting Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
 * @property inputContexts Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
 * @property kendraConfiguration Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
 * @property localeId Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
 * @property name Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
 * The following arguments are optional:
 * @property outputContexts Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
 * @property parentIntentSignature Identifier for the built-in intent to base this intent on.
 * @property sampleUtterances Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
 * @property slotPriorities Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
 * @property timeouts
 */
public data class V2modelsIntentArgs(
    public val botId: Output<String>? = null,
    public val botVersion: Output<String>? = null,
    public val closingSetting: Output<V2modelsIntentClosingSettingArgs>? = null,
    public val confirmationSetting: Output<V2modelsIntentConfirmationSettingArgs>? = null,
    public val description: Output<String>? = null,
    public val dialogCodeHook: Output<V2modelsIntentDialogCodeHookArgs>? = null,
    public val fulfillmentCodeHook: Output<V2modelsIntentFulfillmentCodeHookArgs>? = null,
    public val initialResponseSetting: Output<V2modelsIntentInitialResponseSettingArgs>? = null,
    public val inputContexts: Output<List<V2modelsIntentInputContextArgs>>? = null,
    public val kendraConfiguration: Output<V2modelsIntentKendraConfigurationArgs>? = null,
    public val localeId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val outputContexts: Output<List<V2modelsIntentOutputContextArgs>>? = null,
    public val parentIntentSignature: Output<String>? = null,
    public val sampleUtterances: Output<List<V2modelsIntentSampleUtteranceArgs>>? = null,
    public val slotPriorities: Output<List<V2modelsIntentSlotPriorityArgs>>? = null,
    public val timeouts: Output<V2modelsIntentTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.V2modelsIntentArgs> {
    override fun toJava(): com.pulumi.aws.lex.V2modelsIntentArgs =
        com.pulumi.aws.lex.V2modelsIntentArgs.builder()
            .botId(botId?.applyValue({ args0 -> args0 }))
            .botVersion(botVersion?.applyValue({ args0 -> args0 }))
            .closingSetting(closingSetting?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .confirmationSetting(
                confirmationSetting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .dialogCodeHook(dialogCodeHook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fulfillmentCodeHook(
                fulfillmentCodeHook?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .initialResponseSetting(
                initialResponseSetting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .inputContexts(
                inputContexts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .kendraConfiguration(
                kendraConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .localeId(localeId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .outputContexts(
                outputContexts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parentIntentSignature(parentIntentSignature?.applyValue({ args0 -> args0 }))
            .sampleUtterances(
                sampleUtterances?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .slotPriorities(
                slotPriorities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentArgs].
 */
@PulumiTagMarker
public class V2modelsIntentArgsBuilder internal constructor() {
    private var botId: Output<String>? = null

    private var botVersion: Output<String>? = null

    private var closingSetting: Output<V2modelsIntentClosingSettingArgs>? = null

    private var confirmationSetting: Output<V2modelsIntentConfirmationSettingArgs>? = null

    private var description: Output<String>? = null

    private var dialogCodeHook: Output<V2modelsIntentDialogCodeHookArgs>? = null

    private var fulfillmentCodeHook: Output<V2modelsIntentFulfillmentCodeHookArgs>? = null

    private var initialResponseSetting: Output<V2modelsIntentInitialResponseSettingArgs>? = null

    private var inputContexts: Output<List<V2modelsIntentInputContextArgs>>? = null

    private var kendraConfiguration: Output<V2modelsIntentKendraConfigurationArgs>? = null

    private var localeId: Output<String>? = null

    private var name: Output<String>? = null

    private var outputContexts: Output<List<V2modelsIntentOutputContextArgs>>? = null

    private var parentIntentSignature: Output<String>? = null

    private var sampleUtterances: Output<List<V2modelsIntentSampleUtteranceArgs>>? = null

    private var slotPriorities: Output<List<V2modelsIntentSlotPriorityArgs>>? = null

    private var timeouts: Output<V2modelsIntentTimeoutsArgs>? = null

    /**
     * @param value Identifier of the bot associated with this intent.
     */
    @JvmName("aevkoijjibargsag")
    public suspend fun botId(`value`: Output<String>) {
        this.botId = value
    }

    /**
     * @param value Version of the bot associated with this intent.
     */
    @JvmName("wdrvedryxyeuumgm")
    public suspend fun botVersion(`value`: Output<String>) {
        this.botVersion = value
    }

    /**
     * @param value Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
     */
    @JvmName("ftigeoligkovbgke")
    public suspend fun closingSetting(`value`: Output<V2modelsIntentClosingSettingArgs>) {
        this.closingSetting = value
    }

    /**
     * @param value
     */
    @JvmName("yvslywlmaugvhxfc")
    public suspend fun confirmationSetting(`value`: Output<V2modelsIntentConfirmationSettingArgs>) {
        this.confirmationSetting = value
    }

    /**
     * @param value Description of the intent. Use the description to help identify the intent in lists.
     */
    @JvmName("hkotxeughhotukry")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
     */
    @JvmName("qhkseoqlhbvltrqs")
    public suspend fun dialogCodeHook(`value`: Output<V2modelsIntentDialogCodeHookArgs>) {
        this.dialogCodeHook = value
    }

    /**
     * @param value Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
     */
    @JvmName("rchcveifoyffqdnw")
    public suspend fun fulfillmentCodeHook(`value`: Output<V2modelsIntentFulfillmentCodeHookArgs>) {
        this.fulfillmentCodeHook = value
    }

    /**
     * @param value Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
     */
    @JvmName("aedmibygbvrdbeam")
    public suspend fun initialResponseSetting(`value`: Output<V2modelsIntentInitialResponseSettingArgs>) {
        this.initialResponseSetting = value
    }

    /**
     * @param value Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
     */
    @JvmName("dnnerwflierxcnjr")
    public suspend fun inputContexts(`value`: Output<List<V2modelsIntentInputContextArgs>>) {
        this.inputContexts = value
    }

    @JvmName("gnltiujdeqsuoiya")
    public suspend fun inputContexts(vararg values: Output<V2modelsIntentInputContextArgs>) {
        this.inputContexts = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
     */
    @JvmName("cakehgsgbysiwpwr")
    public suspend fun inputContexts(values: List<Output<V2modelsIntentInputContextArgs>>) {
        this.inputContexts = Output.all(values)
    }

    /**
     * @param value Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
     */
    @JvmName("fjgjxvnblhaxipom")
    public suspend fun kendraConfiguration(`value`: Output<V2modelsIntentKendraConfigurationArgs>) {
        this.kendraConfiguration = value
    }

    /**
     * @param value Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
     */
    @JvmName("lenvyfxitsefviko")
    public suspend fun localeId(`value`: Output<String>) {
        this.localeId = value
    }

    /**
     * @param value Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
     * The following arguments are optional:
     */
    @JvmName("knwbfpijmibtcleo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
     */
    @JvmName("sbsojorcbsqebqgq")
    public suspend fun outputContexts(`value`: Output<List<V2modelsIntentOutputContextArgs>>) {
        this.outputContexts = value
    }

    @JvmName("dktblrfbmekwqdrv")
    public suspend fun outputContexts(vararg values: Output<V2modelsIntentOutputContextArgs>) {
        this.outputContexts = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
     */
    @JvmName("dgvjdgvwheoeftya")
    public suspend fun outputContexts(values: List<Output<V2modelsIntentOutputContextArgs>>) {
        this.outputContexts = Output.all(values)
    }

    /**
     * @param value Identifier for the built-in intent to base this intent on.
     */
    @JvmName("pldksmybiclrxqpy")
    public suspend fun parentIntentSignature(`value`: Output<String>) {
        this.parentIntentSignature = value
    }

    /**
     * @param value Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
     */
    @JvmName("mloeyhgvnpxvavyn")
    public suspend fun sampleUtterances(`value`: Output<List<V2modelsIntentSampleUtteranceArgs>>) {
        this.sampleUtterances = value
    }

    @JvmName("vncvxqbbstqjxxiv")
    public suspend fun sampleUtterances(vararg values: Output<V2modelsIntentSampleUtteranceArgs>) {
        this.sampleUtterances = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
     */
    @JvmName("nsljybgkvljjfmtu")
    public suspend fun sampleUtterances(values: List<Output<V2modelsIntentSampleUtteranceArgs>>) {
        this.sampleUtterances = Output.all(values)
    }

    /**
     * @param value Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
     */
    @JvmName("igtwgpvwsrujjdep")
    public suspend fun slotPriorities(`value`: Output<List<V2modelsIntentSlotPriorityArgs>>) {
        this.slotPriorities = value
    }

    @JvmName("wgpcouemifndlccd")
    public suspend fun slotPriorities(vararg values: Output<V2modelsIntentSlotPriorityArgs>) {
        this.slotPriorities = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
     */
    @JvmName("obiipaqwfgxvneio")
    public suspend fun slotPriorities(values: List<Output<V2modelsIntentSlotPriorityArgs>>) {
        this.slotPriorities = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("yalcanrdneegcthx")
    public suspend fun timeouts(`value`: Output<V2modelsIntentTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Identifier of the bot associated with this intent.
     */
    @JvmName("pgeadpxxggatwdwr")
    public suspend fun botId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botId = mapped
    }

    /**
     * @param value Version of the bot associated with this intent.
     */
    @JvmName("wymyqhayanianfnv")
    public suspend fun botVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botVersion = mapped
    }

    /**
     * @param value Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
     */
    @JvmName("yqdekhsvgxqsniaq")
    public suspend fun closingSetting(`value`: V2modelsIntentClosingSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.closingSetting = mapped
    }

    /**
     * @param argument Configuration block for the response that Amazon Lex sends to the user when the intent is closed. See `closing_setting`.
     */
    @JvmName("nviakfqwysmnrely")
    public suspend fun closingSetting(argument: suspend V2modelsIntentClosingSettingArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentClosingSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.closingSetting = mapped
    }

    /**
     * @param value
     */
    @JvmName("lglgjeadpkuprujo")
    public suspend fun confirmationSetting(`value`: V2modelsIntentConfirmationSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confirmationSetting = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mfkbgolhjoaxwfsy")
    public suspend fun confirmationSetting(argument: suspend V2modelsIntentConfirmationSettingArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentConfirmationSettingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.confirmationSetting = mapped
    }

    /**
     * @param value Description of the intent. Use the description to help identify the intent in lists.
     */
    @JvmName("bryuoufnluukmchi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
     */
    @JvmName("wfjsipvyduknbsap")
    public suspend fun dialogCodeHook(`value`: V2modelsIntentDialogCodeHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialogCodeHook = mapped
    }

    /**
     * @param argument Configuration block for invoking the alias Lambda function for each user input. You can invoke this Lambda function to personalize user interaction. See `dialog_code_hook`.
     */
    @JvmName("hfgwyvvymdoydbde")
    public suspend fun dialogCodeHook(argument: suspend V2modelsIntentDialogCodeHookArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentDialogCodeHookArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dialogCodeHook = mapped
    }

    /**
     * @param value Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
     */
    @JvmName("oukecwlmscrjodwd")
    public suspend fun fulfillmentCodeHook(`value`: V2modelsIntentFulfillmentCodeHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fulfillmentCodeHook = mapped
    }

    /**
     * @param argument Configuration block for invoking the alias Lambda function when the intent is ready for fulfillment. You can invoke this function to complete the bot's transaction with the user. See `fulfillment_code_hook`.
     */
    @JvmName("sdbnfiyomibidogq")
    public suspend fun fulfillmentCodeHook(argument: suspend V2modelsIntentFulfillmentCodeHookArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentFulfillmentCodeHookArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fulfillmentCodeHook = mapped
    }

    /**
     * @param value Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
     */
    @JvmName("iuetahbltqhhsuuq")
    public suspend fun initialResponseSetting(`value`: V2modelsIntentInitialResponseSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialResponseSetting = mapped
    }

    /**
     * @param argument Configuration block for the response that is sent to the user at the beginning of a conversation, before eliciting slot values. See `initial_response_setting`.
     */
    @JvmName("xjyhlrubwhxexeym")
    public suspend fun initialResponseSetting(argument: suspend V2modelsIntentInitialResponseSettingArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentInitialResponseSettingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.initialResponseSetting = mapped
    }

    /**
     * @param value Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
     */
    @JvmName("bswdvnfcwiutsvxk")
    public suspend fun inputContexts(`value`: List<V2modelsIntentInputContextArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputContexts = mapped
    }

    /**
     * @param argument Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
     */
    @JvmName("cmvjaadmthsdwiep")
    public suspend fun inputContexts(argument: List<suspend V2modelsIntentInputContextArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInputContextArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputContexts = mapped
    }

    /**
     * @param argument Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
     */
    @JvmName("wvwyeuvulpwfahmg")
    public suspend fun inputContexts(vararg argument: suspend V2modelsIntentInputContextArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInputContextArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputContexts = mapped
    }

    /**
     * @param argument Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
     */
    @JvmName("hfawvclvruxcajtj")
    public suspend fun inputContexts(argument: suspend V2modelsIntentInputContextArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsIntentInputContextArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.inputContexts = mapped
    }

    /**
     * @param values Configuration blocks for contexts that must be active for this intent to be considered by Amazon Lex. When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the user when the specified contexts are included in the active context list for the session. If the contexts are not active, then Amazon Lex will not use the intent. A context can be automatically activated using the outputContexts property or it can be set at runtime. See `input_context`.
     */
    @JvmName("oukxlgsrrjumqqyq")
    public suspend fun inputContexts(vararg values: V2modelsIntentInputContextArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputContexts = mapped
    }

    /**
     * @param value Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
     */
    @JvmName("fgxidnhiylxpbdtn")
    public suspend fun kendraConfiguration(`value`: V2modelsIntentKendraConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kendraConfiguration = mapped
    }

    /**
     * @param argument Configuration block for information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called when Amazon Lex can't determine another intent to invoke. See `kendra_configuration`.
     */
    @JvmName("qomccblgkkjcpxho")
    public suspend fun kendraConfiguration(argument: suspend V2modelsIntentKendraConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentKendraConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kendraConfiguration = mapped
    }

    /**
     * @param value Identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used by the intent must have the same locale.
     */
    @JvmName("cymjblhikhfddgoi")
    public suspend fun localeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localeId = mapped
    }

    /**
     * @param value Name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the name of any built-in intent.
     * The following arguments are optional:
     */
    @JvmName("abgtkmgpvvrfwjnb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
     */
    @JvmName("bxsmhskqfggliakl")
    public suspend fun outputContexts(`value`: List<V2modelsIntentOutputContextArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputContexts = mapped
    }

    /**
     * @param argument Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
     */
    @JvmName("ywrgaclnuqbjeeyr")
    public suspend fun outputContexts(argument: List<suspend V2modelsIntentOutputContextArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentOutputContextArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputContexts = mapped
    }

    /**
     * @param argument Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
     */
    @JvmName("biebcbligiqxidrk")
    public suspend fun outputContexts(vararg argument: suspend V2modelsIntentOutputContextArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentOutputContextArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputContexts = mapped
    }

    /**
     * @param argument Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
     */
    @JvmName("nakyoirtngmgdlte")
    public suspend fun outputContexts(argument: suspend V2modelsIntentOutputContextArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsIntentOutputContextArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.outputContexts = mapped
    }

    /**
     * @param values Configuration blocks for contexts that the intent activates when it is fulfilled. You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the conversation with a customer. When you use the outputContextsList property, all of the contexts specified in the list are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of conversation turns that the context should be active, or the length of time that the context should be active. See `output_context`.
     */
    @JvmName("hlioyuystkwplgjr")
    public suspend fun outputContexts(vararg values: V2modelsIntentOutputContextArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputContexts = mapped
    }

    /**
     * @param value Identifier for the built-in intent to base this intent on.
     */
    @JvmName("herlufxtgohrqnwc")
    public suspend fun parentIntentSignature(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentIntentSignature = mapped
    }

    /**
     * @param value Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
     */
    @JvmName("fwybxxykdqwmoyha")
    public suspend fun sampleUtterances(`value`: List<V2modelsIntentSampleUtteranceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param argument Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
     */
    @JvmName("fibshpxmbohrjixn")
    public suspend fun sampleUtterances(argument: List<suspend V2modelsIntentSampleUtteranceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentSampleUtteranceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sampleUtterances = mapped
    }

    /**
     * @param argument Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
     */
    @JvmName("kshcpkycxmfsnkhk")
    public suspend fun sampleUtterances(vararg argument: suspend V2modelsIntentSampleUtteranceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentSampleUtteranceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sampleUtterances = mapped
    }

    /**
     * @param argument Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
     */
    @JvmName("stugwgsuahvwkjrl")
    public suspend fun sampleUtterances(argument: suspend V2modelsIntentSampleUtteranceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsIntentSampleUtteranceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sampleUtterances = mapped
    }

    /**
     * @param values Configuration block for strings that a user might say to signal the intent. See `sample_utterance`.
     */
    @JvmName("ajdmhldctfqbdkno")
    public suspend fun sampleUtterances(vararg values: V2modelsIntentSampleUtteranceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param value Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
     */
    @JvmName("dcixjrnhqridlkwn")
    public suspend fun slotPriorities(`value`: List<V2modelsIntentSlotPriorityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slotPriorities = mapped
    }

    /**
     * @param argument Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
     */
    @JvmName("rwsfrwaowfexqasu")
    public suspend fun slotPriorities(argument: List<suspend V2modelsIntentSlotPriorityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentSlotPriorityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slotPriorities = mapped
    }

    /**
     * @param argument Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
     */
    @JvmName("vfgqlopcsenenrvp")
    public suspend fun slotPriorities(vararg argument: suspend V2modelsIntentSlotPriorityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentSlotPriorityArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slotPriorities = mapped
    }

    /**
     * @param argument Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
     */
    @JvmName("bsqbxjfxxjeranmt")
    public suspend fun slotPriorities(argument: suspend V2modelsIntentSlotPriorityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsIntentSlotPriorityArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.slotPriorities = mapped
    }

    /**
     * @param values Configuration block for a new list of slots and their priorities that are contained by the intent. This is ignored on create and only valid for updates. See `slot_priority`.
     */
    @JvmName("qsbfnjvshfystovh")
    public suspend fun slotPriorities(vararg values: V2modelsIntentSlotPriorityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotPriorities = mapped
    }

    /**
     * @param value
     */
    @JvmName("ggawktmmcdyusdxt")
    public suspend fun timeouts(`value`: V2modelsIntentTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bbayefbvtucknjff")
    public suspend fun timeouts(argument: suspend V2modelsIntentTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsIntentTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): V2modelsIntentArgs = V2modelsIntentArgs(
        botId = botId,
        botVersion = botVersion,
        closingSetting = closingSetting,
        confirmationSetting = confirmationSetting,
        description = description,
        dialogCodeHook = dialogCodeHook,
        fulfillmentCodeHook = fulfillmentCodeHook,
        initialResponseSetting = initialResponseSetting,
        inputContexts = inputContexts,
        kendraConfiguration = kendraConfiguration,
        localeId = localeId,
        name = name,
        outputContexts = outputContexts,
        parentIntentSignature = parentIntentSignature,
        sampleUtterances = sampleUtterances,
        slotPriorities = slotPriorities,
        timeouts = timeouts,
    )
}
