@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotMultipleValuesSetting
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotObfuscationSetting
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotSubSlotSetting
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTimeouts
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotValueElicitationSetting
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotMultipleValuesSetting.Companion.toKotlin as v2modelsSlotMultipleValuesSettingToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotObfuscationSetting.Companion.toKotlin as v2modelsSlotObfuscationSettingToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotSubSlotSetting.Companion.toKotlin as v2modelsSlotSubSlotSettingToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTimeouts.Companion.toKotlin as v2modelsSlotTimeoutsToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotValueElicitationSetting.Companion.toKotlin as v2modelsSlotValueElicitationSettingToKotlin

/**
 * Builder for [V2modelsSlot].
 */
@PulumiTagMarker
public class V2modelsSlotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V2modelsSlotArgs = V2modelsSlotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V2modelsSlotArgsBuilder.() -> Unit) {
        val builder = V2modelsSlotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V2modelsSlot {
        val builtJavaResource = com.pulumi.aws.lex.V2modelsSlot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V2modelsSlot(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lex V2 Models Slot.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lex.V2modelsSlot("example", {
 *     botId: exampleAwsLexv2modelsBot.id,
 *     botVersion: exampleAwsLexv2modelsBotVersion.botVersion,
 *     intentId: exampleAwsLexv2modelsIntent.id,
 *     localeId: exampleAwsLexv2modelsBotLocale.localeId,
 *     name: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lex.V2modelsSlot("example",
 *     bot_id=example_aws_lexv2models_bot["id"],
 *     bot_version=example_aws_lexv2models_bot_version["botVersion"],
 *     intent_id=example_aws_lexv2models_intent["id"],
 *     locale_id=example_aws_lexv2models_bot_locale["localeId"],
 *     name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lex.V2modelsSlot("example", new()
 *     {
 *         BotId = exampleAwsLexv2modelsBot.Id,
 *         BotVersion = exampleAwsLexv2modelsBotVersion.BotVersion,
 *         IntentId = exampleAwsLexv2modelsIntent.Id,
 *         LocaleId = exampleAwsLexv2modelsBotLocale.LocaleId,
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lex.NewV2modelsSlot(ctx, "example", &lex.V2modelsSlotArgs{
 * 			BotId:      pulumi.Any(exampleAwsLexv2modelsBot.Id),
 * 			BotVersion: pulumi.Any(exampleAwsLexv2modelsBotVersion.BotVersion),
 * 			IntentId:   pulumi.Any(exampleAwsLexv2modelsIntent.Id),
 * 			LocaleId:   pulumi.Any(exampleAwsLexv2modelsBotLocale.LocaleId),
 * 			Name:       pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsSlot;
 * import com.pulumi.aws.lex.V2modelsSlotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new V2modelsSlot("example", V2modelsSlotArgs.builder()
 *             .botId(exampleAwsLexv2modelsBot.id())
 *             .botVersion(exampleAwsLexv2modelsBotVersion.botVersion())
 *             .intentId(exampleAwsLexv2modelsIntent.id())
 *             .localeId(exampleAwsLexv2modelsBotLocale.localeId())
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lex:V2modelsSlot
 *     properties:
 *       botId: ${exampleAwsLexv2modelsBot.id}
 *       botVersion: ${exampleAwsLexv2modelsBotVersion.botVersion}
 *       intentId: ${exampleAwsLexv2modelsIntent.id}
 *       localeId: ${exampleAwsLexv2modelsBotLocale.localeId}
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Slot using the `id`. For example:
 * ```sh
 * $ pulumi import aws:lex/v2modelsSlot:V2modelsSlot example bot-1234,1,intent-5678,en-US,slot-9012
 * ```
 */
public class V2modelsSlot internal constructor(
    override val javaResource: com.pulumi.aws.lex.V2modelsSlot,
) : KotlinCustomResource(javaResource, V2modelsSlotMapper) {
    /**
     * Identifier of the bot associated with the slot.
     */
    public val botId: Output<String>
        get() = javaResource.botId().applyValue({ args0 -> args0 })

    /**
     * Version of the bot associated with the slot.
     */
    public val botVersion: Output<String>
        get() = javaResource.botVersion().applyValue({ args0 -> args0 })

    /**
     * Description of the slot.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Identifier of the intent that contains the slot.
     */
    public val intentId: Output<String>
        get() = javaResource.intentId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the language and locale that the slot will be used in.
     */
    public val localeId: Output<String>
        get() = javaResource.localeId().applyValue({ args0 -> args0 })

    /**
     * Whether the slot returns multiple values in one response. See the `multiple_values_setting` argument reference below.
     */
    public val multipleValuesSettings: Output<List<V2modelsSlotMultipleValuesSetting>>?
        get() = javaResource.multipleValuesSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        v2modelsSlotMultipleValuesSettingToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Name of the slot.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Determines how slot values are used in Amazon CloudWatch logs. See the `obfuscation_setting` argument reference below.
     */
    public val obfuscationSettings: Output<List<V2modelsSlotObfuscationSetting>>?
        get() = javaResource.obfuscationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        v2modelsSlotObfuscationSettingToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Unique identifier associated with the slot.
     */
    public val slotId: Output<String>
        get() = javaResource.slotId().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for the slot type associated with this slot.
     */
    public val slotTypeId: Output<String>
        get() = javaResource.slotTypeId().applyValue({ args0 -> args0 })

    /**
     * Specifications for the constituent sub slots and the expression for the composite slot.
     */
    public val subSlotSettings: Output<List<V2modelsSlotSubSlotSetting>>?
        get() = javaResource.subSlotSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        v2modelsSlotSubSlotSettingToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    public val timeouts: Output<V2modelsSlotTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v2modelsSlotTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    public val valueElicitationSetting: Output<V2modelsSlotValueElicitationSetting>?
        get() = javaResource.valueElicitationSetting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsSlotValueElicitationSettingToKotlin(args0) })
            }).orElse(null)
        })
}

public object V2modelsSlotMapper : ResourceMapper<V2modelsSlot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.V2modelsSlot::class == javaResource::class

    override fun map(javaResource: Resource): V2modelsSlot = V2modelsSlot(
        javaResource as
            com.pulumi.aws.lex.V2modelsSlot,
    )
}

/**
 * @see [V2modelsSlot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V2modelsSlot].
 */
public suspend fun v2modelsSlot(
    name: String,
    block: suspend V2modelsSlotResourceBuilder.() -> Unit,
): V2modelsSlot {
    val builder = V2modelsSlotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V2modelsSlot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v2modelsSlot(name: String): V2modelsSlot {
    val builder = V2modelsSlotResourceBuilder()
    builder.name(name)
    return builder.build()
}
