@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.V2modelsSlotArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotMultipleValuesSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotMultipleValuesSettingArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotObfuscationSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotObfuscationSettingArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotSubSlotSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotSubSlotSettingArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTimeoutsArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTimeoutsArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotValueElicitationSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotValueElicitationSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lex V2 Models Slot.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.lex.V2modelsSlot("example", {
 *     botId: exampleAwsLexv2modelsBot.id,
 *     botVersion: exampleAwsLexv2modelsBotVersion.botVersion,
 *     intentId: exampleAwsLexv2modelsIntent.id,
 *     localeId: exampleAwsLexv2modelsBotLocale.localeId,
 *     name: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.lex.V2modelsSlot("example",
 *     bot_id=example_aws_lexv2models_bot["id"],
 *     bot_version=example_aws_lexv2models_bot_version["botVersion"],
 *     intent_id=example_aws_lexv2models_intent["id"],
 *     locale_id=example_aws_lexv2models_bot_locale["localeId"],
 *     name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Lex.V2modelsSlot("example", new()
 *     {
 *         BotId = exampleAwsLexv2modelsBot.Id,
 *         BotVersion = exampleAwsLexv2modelsBotVersion.BotVersion,
 *         IntentId = exampleAwsLexv2modelsIntent.Id,
 *         LocaleId = exampleAwsLexv2modelsBotLocale.LocaleId,
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := lex.NewV2modelsSlot(ctx, "example", &lex.V2modelsSlotArgs{
 * 			BotId:      pulumi.Any(exampleAwsLexv2modelsBot.Id),
 * 			BotVersion: pulumi.Any(exampleAwsLexv2modelsBotVersion.BotVersion),
 * 			IntentId:   pulumi.Any(exampleAwsLexv2modelsIntent.Id),
 * 			LocaleId:   pulumi.Any(exampleAwsLexv2modelsBotLocale.LocaleId),
 * 			Name:       pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lex.V2modelsSlot;
 * import com.pulumi.aws.lex.V2modelsSlotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new V2modelsSlot("example", V2modelsSlotArgs.builder()
 *             .botId(exampleAwsLexv2modelsBot.id())
 *             .botVersion(exampleAwsLexv2modelsBotVersion.botVersion())
 *             .intentId(exampleAwsLexv2modelsIntent.id())
 *             .localeId(exampleAwsLexv2modelsBotLocale.localeId())
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:lex:V2modelsSlot
 *     properties:
 *       botId: ${exampleAwsLexv2modelsBot.id}
 *       botVersion: ${exampleAwsLexv2modelsBotVersion.botVersion}
 *       intentId: ${exampleAwsLexv2modelsIntent.id}
 *       localeId: ${exampleAwsLexv2modelsBotLocale.localeId}
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Slot using the `id`. For example:
 * ```sh
 * $ pulumi import aws:lex/v2modelsSlot:V2modelsSlot example bot-1234,1,intent-5678,en-US,slot-9012
 * ```
 * @property botId Identifier of the bot associated with the slot.
 * @property botVersion Version of the bot associated with the slot.
 * @property description Description of the slot.
 * @property intentId Identifier of the intent that contains the slot.
 * @property localeId Identifier of the language and locale that the slot will be used in.
 * @property multipleValuesSettings Whether the slot returns multiple values in one response. See the `multiple_values_setting` argument reference below.
 * @property name Name of the slot.
 * @property obfuscationSettings Determines how slot values are used in Amazon CloudWatch logs. See the `obfuscation_setting` argument reference below.
 * @property slotTypeId Unique identifier for the slot type associated with this slot.
 * @property subSlotSettings Specifications for the constituent sub slots and the expression for the composite slot.
 * @property timeouts
 * @property valueElicitationSetting Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
 * The following arguments are optional:
 */
public data class V2modelsSlotArgs(
    public val botId: Output<String>? = null,
    public val botVersion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val intentId: Output<String>? = null,
    public val localeId: Output<String>? = null,
    public val multipleValuesSettings: Output<List<V2modelsSlotMultipleValuesSettingArgs>>? = null,
    public val name: Output<String>? = null,
    public val obfuscationSettings: Output<List<V2modelsSlotObfuscationSettingArgs>>? = null,
    public val slotTypeId: Output<String>? = null,
    public val subSlotSettings: Output<List<V2modelsSlotSubSlotSettingArgs>>? = null,
    public val timeouts: Output<V2modelsSlotTimeoutsArgs>? = null,
    public val valueElicitationSetting: Output<V2modelsSlotValueElicitationSettingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.V2modelsSlotArgs> {
    override fun toJava(): com.pulumi.aws.lex.V2modelsSlotArgs =
        com.pulumi.aws.lex.V2modelsSlotArgs.builder()
            .botId(botId?.applyValue({ args0 -> args0 }))
            .botVersion(botVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .intentId(intentId?.applyValue({ args0 -> args0 }))
            .localeId(localeId?.applyValue({ args0 -> args0 }))
            .multipleValuesSettings(
                multipleValuesSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .obfuscationSettings(
                obfuscationSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .slotTypeId(slotTypeId?.applyValue({ args0 -> args0 }))
            .subSlotSettings(
                subSlotSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .valueElicitationSetting(
                valueElicitationSetting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsSlotArgs].
 */
@PulumiTagMarker
public class V2modelsSlotArgsBuilder internal constructor() {
    private var botId: Output<String>? = null

    private var botVersion: Output<String>? = null

    private var description: Output<String>? = null

    private var intentId: Output<String>? = null

    private var localeId: Output<String>? = null

    private var multipleValuesSettings: Output<List<V2modelsSlotMultipleValuesSettingArgs>>? = null

    private var name: Output<String>? = null

    private var obfuscationSettings: Output<List<V2modelsSlotObfuscationSettingArgs>>? = null

    private var slotTypeId: Output<String>? = null

    private var subSlotSettings: Output<List<V2modelsSlotSubSlotSettingArgs>>? = null

    private var timeouts: Output<V2modelsSlotTimeoutsArgs>? = null

    private var valueElicitationSetting: Output<V2modelsSlotValueElicitationSettingArgs>? = null

    /**
     * @param value Identifier of the bot associated with the slot.
     */
    @JvmName("tivqwgkrfhshkjvu")
    public suspend fun botId(`value`: Output<String>) {
        this.botId = value
    }

    /**
     * @param value Version of the bot associated with the slot.
     */
    @JvmName("lmaqievyijwiacaq")
    public suspend fun botVersion(`value`: Output<String>) {
        this.botVersion = value
    }

    /**
     * @param value Description of the slot.
     */
    @JvmName("ncdjfaamsetprrjt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Identifier of the intent that contains the slot.
     */
    @JvmName("ccoaklgtvgmgovod")
    public suspend fun intentId(`value`: Output<String>) {
        this.intentId = value
    }

    /**
     * @param value Identifier of the language and locale that the slot will be used in.
     */
    @JvmName("pobnpgaresldelwe")
    public suspend fun localeId(`value`: Output<String>) {
        this.localeId = value
    }

    /**
     * @param value Whether the slot returns multiple values in one response. See the `multiple_values_setting` argument reference below.
     */
    @JvmName("gdpqebcnhkxormyr")
    public suspend fun multipleValuesSettings(`value`: Output<List<V2modelsSlotMultipleValuesSettingArgs>>) {
        this.multipleValuesSettings = value
    }

    @JvmName("tuhgqhxntgosvxdt")
    public suspend fun multipleValuesSettings(vararg values: Output<V2modelsSlotMultipleValuesSettingArgs>) {
        this.multipleValuesSettings = Output.all(values.asList())
    }

    /**
     * @param values Whether the slot returns multiple values in one response. See the `multiple_values_setting` argument reference below.
     */
    @JvmName("mjuwbyrcrhwgjqdo")
    public suspend fun multipleValuesSettings(values: List<Output<V2modelsSlotMultipleValuesSettingArgs>>) {
        this.multipleValuesSettings = Output.all(values)
    }

    /**
     * @param value Name of the slot.
     */
    @JvmName("hypclhhxtcxponxp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Determines how slot values are used in Amazon CloudWatch logs. See the `obfuscation_setting` argument reference below.
     */
    @JvmName("tnmxkitdrteveics")
    public suspend fun obfuscationSettings(`value`: Output<List<V2modelsSlotObfuscationSettingArgs>>) {
        this.obfuscationSettings = value
    }

    @JvmName("vfhqbtfgmjyxrynp")
    public suspend fun obfuscationSettings(vararg values: Output<V2modelsSlotObfuscationSettingArgs>) {
        this.obfuscationSettings = Output.all(values.asList())
    }

    /**
     * @param values Determines how slot values are used in Amazon CloudWatch logs. See the `obfuscation_setting` argument reference below.
     */
    @JvmName("xvwycuwsbpxsgllk")
    public suspend fun obfuscationSettings(values: List<Output<V2modelsSlotObfuscationSettingArgs>>) {
        this.obfuscationSettings = Output.all(values)
    }

    /**
     * @param value Unique identifier for the slot type associated with this slot.
     */
    @JvmName("inpilbwewktcxkkl")
    public suspend fun slotTypeId(`value`: Output<String>) {
        this.slotTypeId = value
    }

    /**
     * @param value Specifications for the constituent sub slots and the expression for the composite slot.
     */
    @JvmName("ytkgvmusyvymcvfy")
    public suspend fun subSlotSettings(`value`: Output<List<V2modelsSlotSubSlotSettingArgs>>) {
        this.subSlotSettings = value
    }

    @JvmName("dmqvfihrcmrlgxqi")
    public suspend fun subSlotSettings(vararg values: Output<V2modelsSlotSubSlotSettingArgs>) {
        this.subSlotSettings = Output.all(values.asList())
    }

    /**
     * @param values Specifications for the constituent sub slots and the expression for the composite slot.
     */
    @JvmName("cefjyplxsotdmqxk")
    public suspend fun subSlotSettings(values: List<Output<V2modelsSlotSubSlotSettingArgs>>) {
        this.subSlotSettings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cmprijpfwqpoedsj")
    public suspend fun timeouts(`value`: Output<V2modelsSlotTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("pxieuerlklsyhkyb")
    public suspend fun valueElicitationSetting(`value`: Output<V2modelsSlotValueElicitationSettingArgs>) {
        this.valueElicitationSetting = value
    }

    /**
     * @param value Identifier of the bot associated with the slot.
     */
    @JvmName("xrscmxoyxusllpms")
    public suspend fun botId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botId = mapped
    }

    /**
     * @param value Version of the bot associated with the slot.
     */
    @JvmName("nsxjppohifeaepvm")
    public suspend fun botVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botVersion = mapped
    }

    /**
     * @param value Description of the slot.
     */
    @JvmName("agxsngayrqfxqusa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Identifier of the intent that contains the slot.
     */
    @JvmName("gtfncfixexudevut")
    public suspend fun intentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intentId = mapped
    }

    /**
     * @param value Identifier of the language and locale that the slot will be used in.
     */
    @JvmName("rqxscfaynrbvoxms")
    public suspend fun localeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localeId = mapped
    }

    /**
     * @param value Whether the slot returns multiple values in one response. See the `multiple_values_setting` argument reference below.
     */
    @JvmName("itenmavislvxrwms")
    public suspend fun multipleValuesSettings(`value`: List<V2modelsSlotMultipleValuesSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multipleValuesSettings = mapped
    }

    /**
     * @param argument Whether the slot returns multiple values in one response. See the `multiple_values_setting` argument reference below.
     */
    @JvmName("ymjnyjfqabjgufso")
    public suspend fun multipleValuesSettings(argument: List<suspend V2modelsSlotMultipleValuesSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotMultipleValuesSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.multipleValuesSettings = mapped
    }

    /**
     * @param argument Whether the slot returns multiple values in one response. See the `multiple_values_setting` argument reference below.
     */
    @JvmName("uxjuniobksoljvoo")
    public suspend fun multipleValuesSettings(vararg argument: suspend V2modelsSlotMultipleValuesSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotMultipleValuesSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.multipleValuesSettings = mapped
    }

    /**
     * @param argument Whether the slot returns multiple values in one response. See the `multiple_values_setting` argument reference below.
     */
    @JvmName("knqovvcojodkvxsu")
    public suspend fun multipleValuesSettings(argument: suspend V2modelsSlotMultipleValuesSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsSlotMultipleValuesSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.multipleValuesSettings = mapped
    }

    /**
     * @param values Whether the slot returns multiple values in one response. See the `multiple_values_setting` argument reference below.
     */
    @JvmName("lserihxiwmgvmibv")
    public suspend fun multipleValuesSettings(vararg values: V2modelsSlotMultipleValuesSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multipleValuesSettings = mapped
    }

    /**
     * @param value Name of the slot.
     */
    @JvmName("mecvwjqmxywgsosh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Determines how slot values are used in Amazon CloudWatch logs. See the `obfuscation_setting` argument reference below.
     */
    @JvmName("ffrdrqqcmtoqmdoi")
    public suspend fun obfuscationSettings(`value`: List<V2modelsSlotObfuscationSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.obfuscationSettings = mapped
    }

    /**
     * @param argument Determines how slot values are used in Amazon CloudWatch logs. See the `obfuscation_setting` argument reference below.
     */
    @JvmName("bjwekgniwywspaxv")
    public suspend fun obfuscationSettings(argument: List<suspend V2modelsSlotObfuscationSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotObfuscationSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.obfuscationSettings = mapped
    }

    /**
     * @param argument Determines how slot values are used in Amazon CloudWatch logs. See the `obfuscation_setting` argument reference below.
     */
    @JvmName("ppduaajcgyewfvso")
    public suspend fun obfuscationSettings(vararg argument: suspend V2modelsSlotObfuscationSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotObfuscationSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.obfuscationSettings = mapped
    }

    /**
     * @param argument Determines how slot values are used in Amazon CloudWatch logs. See the `obfuscation_setting` argument reference below.
     */
    @JvmName("piaefvospqewcwel")
    public suspend fun obfuscationSettings(argument: suspend V2modelsSlotObfuscationSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsSlotObfuscationSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.obfuscationSettings = mapped
    }

    /**
     * @param values Determines how slot values are used in Amazon CloudWatch logs. See the `obfuscation_setting` argument reference below.
     */
    @JvmName("yiqxtxcojksvcjba")
    public suspend fun obfuscationSettings(vararg values: V2modelsSlotObfuscationSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.obfuscationSettings = mapped
    }

    /**
     * @param value Unique identifier for the slot type associated with this slot.
     */
    @JvmName("jalvxagouodssfii")
    public suspend fun slotTypeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slotTypeId = mapped
    }

    /**
     * @param value Specifications for the constituent sub slots and the expression for the composite slot.
     */
    @JvmName("jxcredeyftclprtf")
    public suspend fun subSlotSettings(`value`: List<V2modelsSlotSubSlotSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subSlotSettings = mapped
    }

    /**
     * @param argument Specifications for the constituent sub slots and the expression for the composite slot.
     */
    @JvmName("dvyhnflnxtkuhgcp")
    public suspend fun subSlotSettings(argument: List<suspend V2modelsSlotSubSlotSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotSubSlotSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subSlotSettings = mapped
    }

    /**
     * @param argument Specifications for the constituent sub slots and the expression for the composite slot.
     */
    @JvmName("jcfafjowjxjamhwp")
    public suspend fun subSlotSettings(vararg argument: suspend V2modelsSlotSubSlotSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotSubSlotSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subSlotSettings = mapped
    }

    /**
     * @param argument Specifications for the constituent sub slots and the expression for the composite slot.
     */
    @JvmName("myqrhbmkseeykxvd")
    public suspend fun subSlotSettings(argument: suspend V2modelsSlotSubSlotSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsSlotSubSlotSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.subSlotSettings = mapped
    }

    /**
     * @param values Specifications for the constituent sub slots and the expression for the composite slot.
     */
    @JvmName("mvhcbvcptlkrifng")
    public suspend fun subSlotSettings(vararg values: V2modelsSlotSubSlotSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subSlotSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("cagotfficrsgytqw")
    public suspend fun timeouts(`value`: V2modelsSlotTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pursxbjjvyyytqty")
    public suspend fun timeouts(argument: suspend V2modelsSlotTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsSlotTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("gpnhcnkcfnhkovct")
    public suspend fun valueElicitationSetting(`value`: V2modelsSlotValueElicitationSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueElicitationSetting = mapped
    }

    /**
     * @param argument Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("akwiumqjudymsoin")
    public suspend fun valueElicitationSetting(argument: suspend V2modelsSlotValueElicitationSettingArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsSlotValueElicitationSettingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.valueElicitationSetting = mapped
    }

    internal fun build(): V2modelsSlotArgs = V2modelsSlotArgs(
        botId = botId,
        botVersion = botVersion,
        description = description,
        intentId = intentId,
        localeId = localeId,
        multipleValuesSettings = multipleValuesSettings,
        name = name,
        obfuscationSettings = obfuscationSettings,
        slotTypeId = slotTypeId,
        subSlotSettings = subSlotSettings,
        timeouts = timeouts,
        valueElicitationSetting = valueElicitationSetting,
    )
}
