@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeCompositeSlotTypeSetting
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeExternalSourceSetting
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeSlotTypeValues
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeTimeouts
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeValueSelectionSetting
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeCompositeSlotTypeSetting.Companion.toKotlin as v2modelsSlotTypeCompositeSlotTypeSettingToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeExternalSourceSetting.Companion.toKotlin as v2modelsSlotTypeExternalSourceSettingToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeSlotTypeValues.Companion.toKotlin as v2modelsSlotTypeSlotTypeValuesToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeTimeouts.Companion.toKotlin as v2modelsSlotTypeTimeoutsToKotlin
import com.pulumi.aws.lex.kotlin.outputs.V2modelsSlotTypeValueSelectionSetting.Companion.toKotlin as v2modelsSlotTypeValueSelectionSettingToKotlin

/**
 * Builder for [V2modelsSlotType].
 */
@PulumiTagMarker
public class V2modelsSlotTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: V2modelsSlotTypeArgs = V2modelsSlotTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend V2modelsSlotTypeArgsBuilder.() -> Unit) {
        val builder = V2modelsSlotTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): V2modelsSlotType {
        val builtJavaResource = com.pulumi.aws.lex.V2modelsSlotType(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return V2modelsSlotType(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Lex V2 Models Slot Type.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.iam.RolePolicyAttachment("test", {
 *     role: testAwsIamRole.name,
 *     policyArn: `arn:${current.partition}:iam::aws:policy/AmazonLexFullAccess`,
 * });
 * const testV2modelsBot = new aws.lex.V2modelsBot("test", {
 *     name: "testbot",
 *     idleSessionTtlInSeconds: 60,
 *     roleArn: testAwsIamRole.arn,
 *     dataPrivacies: [{
 *         childDirected: true,
 *     }],
 * });
 * const testV2modelsBotLocale = new aws.lex.V2modelsBotLocale("test", {
 *     localeId: "en_US",
 *     botId: testV2modelsBot.id,
 *     botVersion: "DRAFT",
 *     nLuIntentConfidenceThreshold: 0.7,
 * });
 * const testV2modelsBotVersion = new aws.lex.V2modelsBotVersion("test", {
 *     botId: testV2modelsBot.id,
 *     localeSpecification: testV2modelsBotLocale.localeId.apply(localeId => {
 *         [localeId]: {
 *             sourceBotVersion: "DRAFT",
 *         },
 *     }),
 * });
 * const testV2modelsSlotType = new aws.lex.V2modelsSlotType("test", {
 *     botId: testV2modelsBot.id,
 *     botVersion: testV2modelsBotLocale.botVersion,
 *     name: "test",
 *     localeId: testV2modelsBotLocale.localeId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.iam.RolePolicyAttachment("test",
 *     role=test_aws_iam_role["name"],
 *     policy_arn=f"arn:{current['partition']}:iam::aws:policy/AmazonLexFullAccess")
 * test_v2models_bot = aws.lex.V2modelsBot("test",
 *     name="testbot",
 *     idle_session_ttl_in_seconds=60,
 *     role_arn=test_aws_iam_role["arn"],
 *     data_privacies=[{
 *         "child_directed": True,
 *     }])
 * test_v2models_bot_locale = aws.lex.V2modelsBotLocale("test",
 *     locale_id="en_US",
 *     bot_id=test_v2models_bot.id,
 *     bot_version="DRAFT",
 *     n_lu_intent_confidence_threshold=0.7)
 * test_v2models_bot_version = aws.lex.V2modelsBotVersion("test",
 *     bot_id=test_v2models_bot.id,
 *     locale_specification=test_v2models_bot_locale.locale_id.apply(lambda locale_id: {
 *         locale_id: {
 *             "sourceBotVersion": "DRAFT",
 *         },
 *     }))
 * test_v2models_slot_type = aws.lex.V2modelsSlotType("test",
 *     bot_id=test_v2models_bot.id,
 *     bot_version=test_v2models_bot_locale.bot_version,
 *     name="test",
 *     locale_id=test_v2models_bot_locale.locale_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Iam.RolePolicyAttachment("test", new()
 *     {
 *         Role = testAwsIamRole.Name,
 *         PolicyArn = $"arn:{current.Partition}:iam::aws:policy/AmazonLexFullAccess",
 *     });
 *     var testV2modelsBot = new Aws.Lex.V2modelsBot("test", new()
 *     {
 *         Name = "testbot",
 *         IdleSessionTtlInSeconds = 60,
 *         RoleArn = testAwsIamRole.Arn,
 *         DataPrivacies = new[]
 *         {
 *             new Aws.Lex.Inputs.V2modelsBotDataPrivacyArgs
 *             {
 *                 ChildDirected = true,
 *             },
 *         },
 *     });
 *     var testV2modelsBotLocale = new Aws.Lex.V2modelsBotLocale("test", new()
 *     {
 *         LocaleId = "en_US",
 *         BotId = testV2modelsBot.Id,
 *         BotVersion = "DRAFT",
 *         NLuIntentConfidenceThreshold = 0.7,
 *     });
 *     var testV2modelsBotVersion = new Aws.Lex.V2modelsBotVersion("test", new()
 *     {
 *         BotId = testV2modelsBot.Id,
 *         LocaleSpecification = testV2modelsBotLocale.LocaleId.Apply(localeId =>
 *         {
 *             { localeId,
 *             {
 *                 { "sourceBotVersion", "DRAFT" },
 *             } },
 *         }),
 *     });
 *     var testV2modelsSlotType = new Aws.Lex.V2modelsSlotType("test", new()
 *     {
 *         BotId = testV2modelsBot.Id,
 *         BotVersion = testV2modelsBotLocale.BotVersion,
 *         Name = "test",
 *         LocaleId = testV2modelsBotLocale.LocaleId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iam.NewRolePolicyAttachment(ctx, "test", &iam.RolePolicyAttachmentArgs{
 * Role: pulumi.Any(testAwsIamRole.Name),
 * PolicyArn: pulumi.Sprintf("arn:%v:iam::aws:policy/AmazonLexFullAccess", current.Partition),
 * })
 * if err != nil {
 * return err
 * }
 * testV2modelsBot, err := lex.NewV2modelsBot(ctx, "test", &lex.V2modelsBotArgs{
 * Name: pulumi.String("testbot"),
 * IdleSessionTtlInSeconds: pulumi.Int(60),
 * RoleArn: pulumi.Any(testAwsIamRole.Arn),
 * DataPrivacies: lex.V2modelsBotDataPrivacyArray{
 * &lex.V2modelsBotDataPrivacyArgs{
 * ChildDirected: pulumi.Bool(true),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * testV2modelsBotLocale, err := lex.NewV2modelsBotLocale(ctx, "test", &lex.V2modelsBotLocaleArgs{
 * LocaleId: pulumi.String("en_US"),
 * BotId: testV2modelsBot.ID(),
 * BotVersion: pulumi.String("DRAFT"),
 * NLuIntentConfidenceThreshold: pulumi.Float64(0.7),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = lex.NewV2modelsBotVersion(ctx, "test", &lex.V2modelsBotVersionArgs{
 * BotId: testV2modelsBot.ID(),
 * LocaleSpecification: testV2modelsBotLocale.LocaleId.ApplyT(func(localeId string) (map[string]map[string]interface{}, error) {
 * return map[string]map[string]interface{}{
 * localeId: map[string]interface{}{
 * "sourceBotVersion": "DRAFT",
 * },
 * }, nil
 * }).(pulumi.Map[string]map[string]interface{}Output),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = lex.NewV2modelsSlotType(ctx, "test", &lex.V2modelsSlotTypeArgs{
 * BotId: testV2modelsBot.ID(),
 * BotVersion: testV2modelsBotLocale.BotVersion,
 * Name: pulumi.String("test"),
 * LocaleId: testV2modelsBotLocale.LocaleId,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.lex.V2modelsBot;
 * import com.pulumi.aws.lex.V2modelsBotArgs;
 * import com.pulumi.aws.lex.inputs.V2modelsBotDataPrivacyArgs;
 * import com.pulumi.aws.lex.V2modelsBotLocale;
 * import com.pulumi.aws.lex.V2modelsBotLocaleArgs;
 * import com.pulumi.aws.lex.V2modelsBotVersion;
 * import com.pulumi.aws.lex.V2modelsBotVersionArgs;
 * import com.pulumi.aws.lex.V2modelsSlotType;
 * import com.pulumi.aws.lex.V2modelsSlotTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RolePolicyAttachment("test", RolePolicyAttachmentArgs.builder()
 *             .role(testAwsIamRole.name())
 *             .policyArn(String.format("arn:%s:iam::aws:policy/AmazonLexFullAccess", current.partition()))
 *             .build());
 *         var testV2modelsBot = new V2modelsBot("testV2modelsBot", V2modelsBotArgs.builder()
 *             .name("testbot")
 *             .idleSessionTtlInSeconds(60)
 *             .roleArn(testAwsIamRole.arn())
 *             .dataPrivacies(V2modelsBotDataPrivacyArgs.builder()
 *                 .childDirected(true)
 *                 .build())
 *             .build());
 *         var testV2modelsBotLocale = new V2modelsBotLocale("testV2modelsBotLocale", V2modelsBotLocaleArgs.builder()
 *             .localeId("en_US")
 *             .botId(testV2modelsBot.id())
 *             .botVersion("DRAFT")
 *             .nLuIntentConfidenceThreshold(0.7)
 *             .build());
 *         var testV2modelsBotVersion = new V2modelsBotVersion("testV2modelsBotVersion", V2modelsBotVersionArgs.builder()
 *             .botId(testV2modelsBot.id())
 *             .localeSpecification(testV2modelsBotLocale.localeId().applyValue(localeId -> Map.of(localeId, Map.of("sourceBotVersion", "DRAFT"))))
 *             .build());
 *         var testV2modelsSlotType = new V2modelsSlotType("testV2modelsSlotType", V2modelsSlotTypeArgs.builder()
 *             .botId(testV2modelsBot.id())
 *             .botVersion(testV2modelsBotLocale.botVersion())
 *             .name("test")
 *             .localeId(testV2modelsBotLocale.localeId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       role: ${testAwsIamRole.name}
 *       policyArn: arn:${current.partition}:iam::aws:policy/AmazonLexFullAccess
 *   testV2modelsBot:
 *     type: aws:lex:V2modelsBot
 *     name: test
 *     properties:
 *       name: testbot
 *       idleSessionTtlInSeconds: 60
 *       roleArn: ${testAwsIamRole.arn}
 *       dataPrivacies:
 *         - childDirected: true
 *   testV2modelsBotLocale:
 *     type: aws:lex:V2modelsBotLocale
 *     name: test
 *     properties:
 *       localeId: en_US
 *       botId: ${testV2modelsBot.id}
 *       botVersion: DRAFT
 *       nLuIntentConfidenceThreshold: 0.7
 *   testV2modelsBotVersion:
 *     type: aws:lex:V2modelsBotVersion
 *     name: test
 *     properties:
 *       botId: ${testV2modelsBot.id}
 *       localeSpecification:
 *         ${testV2modelsBotLocale.localeId}:
 *           sourceBotVersion: DRAFT
 *   testV2modelsSlotType:
 *     type: aws:lex:V2modelsSlotType
 *     name: test
 *     properties:
 *       botId: ${testV2modelsBot.id}
 *       botVersion: ${testV2modelsBotLocale.botVersion}
 *       name: test
 *       localeId: ${testV2modelsBotLocale.localeId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Slot Type using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:lex/v2modelsSlotType:V2modelsSlotType example bot-1234,DRAFT,en_US,slot_type-id-12345678
 * ```
 */
public class V2modelsSlotType internal constructor(
    override val javaResource: com.pulumi.aws.lex.V2modelsSlotType,
) : KotlinCustomResource(javaResource, V2modelsSlotTypeMapper) {
    /**
     * Identifier of the bot associated with this slot type.
     */
    public val botId: Output<String>
        get() = javaResource.botId().applyValue({ args0 -> args0 })

    /**
     * Version of the bot associated with this slot type.
     */
    public val botVersion: Output<String>
        get() = javaResource.botVersion().applyValue({ args0 -> args0 })

    /**
     * Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
     */
    public val compositeSlotTypeSetting: Output<V2modelsSlotTypeCompositeSlotTypeSetting>?
        get() = javaResource.compositeSlotTypeSetting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v2modelsSlotTypeCompositeSlotTypeSettingToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Description of the slot type.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of external information used to create the slot type. See `external_source_setting` argument reference below.
     */
    public val externalSourceSetting: Output<V2modelsSlotTypeExternalSourceSetting>?
        get() = javaResource.externalSourceSetting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsSlotTypeExternalSourceSettingToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
     */
    public val localeId: Output<String>
        get() = javaResource.localeId().applyValue({ args0 -> args0 })

    /**
     * Name of the slot type
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
     */
    public val parentSlotTypeSignature: Output<String>?
        get() = javaResource.parentSlotTypeSignature().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val slotTypeId: Output<String>
        get() = javaResource.slotTypeId().applyValue({ args0 -> args0 })

    /**
     * List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    public val slotTypeValues: Output<V2modelsSlotTypeSlotTypeValues>?
        get() = javaResource.slotTypeValues().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsSlotTypeSlotTypeValuesToKotlin(args0) })
            }).orElse(null)
        })

    public val timeouts: Output<V2modelsSlotTypeTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    v2modelsSlotTypeTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
     */
    public val valueSelectionSetting: Output<V2modelsSlotTypeValueSelectionSetting>?
        get() = javaResource.valueSelectionSetting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> v2modelsSlotTypeValueSelectionSettingToKotlin(args0) })
            }).orElse(null)
        })
}

public object V2modelsSlotTypeMapper : ResourceMapper<V2modelsSlotType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lex.V2modelsSlotType::class == javaResource::class

    override fun map(javaResource: Resource): V2modelsSlotType = V2modelsSlotType(
        javaResource as
            com.pulumi.aws.lex.V2modelsSlotType,
    )
}

/**
 * @see [V2modelsSlotType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [V2modelsSlotType].
 */
public suspend fun v2modelsSlotType(
    name: String,
    block: suspend V2modelsSlotTypeResourceBuilder.() -> Unit,
): V2modelsSlotType {
    val builder = V2modelsSlotTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [V2modelsSlotType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun v2modelsSlotType(name: String): V2modelsSlotType {
    val builder = V2modelsSlotTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
