@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin

import com.pulumi.aws.lex.V2modelsSlotTypeArgs.builder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeCompositeSlotTypeSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeCompositeSlotTypeSettingArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeExternalSourceSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeExternalSourceSettingArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeSlotTypeValuesArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeSlotTypeValuesArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeTimeoutsArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeTimeoutsArgsBuilder
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeValueSelectionSettingArgs
import com.pulumi.aws.lex.kotlin.inputs.V2modelsSlotTypeValueSelectionSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Lex V2 Models Slot Type.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.iam.RolePolicyAttachment("test", {
 *     role: testAwsIamRole.name,
 *     policyArn: `arn:${current.partition}:iam::aws:policy/AmazonLexFullAccess`,
 * });
 * const testV2modelsBot = new aws.lex.V2modelsBot("test", {
 *     name: "testbot",
 *     idleSessionTtlInSeconds: 60,
 *     roleArn: testAwsIamRole.arn,
 *     dataPrivacies: [{
 *         childDirected: true,
 *     }],
 * });
 * const testV2modelsBotLocale = new aws.lex.V2modelsBotLocale("test", {
 *     localeId: "en_US",
 *     botId: testV2modelsBot.id,
 *     botVersion: "DRAFT",
 *     nLuIntentConfidenceThreshold: 0.7,
 * });
 * const testV2modelsBotVersion = new aws.lex.V2modelsBotVersion("test", {
 *     botId: testV2modelsBot.id,
 *     localeSpecification: testV2modelsBotLocale.localeId.apply(localeId => {
 *         [localeId]: {
 *             sourceBotVersion: "DRAFT",
 *         },
 *     }),
 * });
 * const testV2modelsSlotType = new aws.lex.V2modelsSlotType("test", {
 *     botId: testV2modelsBot.id,
 *     botVersion: testV2modelsBotLocale.botVersion,
 *     name: "test",
 *     localeId: testV2modelsBotLocale.localeId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.iam.RolePolicyAttachment("test",
 *     role=test_aws_iam_role["name"],
 *     policy_arn=f"arn:{current['partition']}:iam::aws:policy/AmazonLexFullAccess")
 * test_v2models_bot = aws.lex.V2modelsBot("test",
 *     name="testbot",
 *     idle_session_ttl_in_seconds=60,
 *     role_arn=test_aws_iam_role["arn"],
 *     data_privacies=[{
 *         "child_directed": True,
 *     }])
 * test_v2models_bot_locale = aws.lex.V2modelsBotLocale("test",
 *     locale_id="en_US",
 *     bot_id=test_v2models_bot.id,
 *     bot_version="DRAFT",
 *     n_lu_intent_confidence_threshold=0.7)
 * test_v2models_bot_version = aws.lex.V2modelsBotVersion("test",
 *     bot_id=test_v2models_bot.id,
 *     locale_specification=test_v2models_bot_locale.locale_id.apply(lambda locale_id: {
 *         locale_id: {
 *             "sourceBotVersion": "DRAFT",
 *         },
 *     }))
 * test_v2models_slot_type = aws.lex.V2modelsSlotType("test",
 *     bot_id=test_v2models_bot.id,
 *     bot_version=test_v2models_bot_locale.bot_version,
 *     name="test",
 *     locale_id=test_v2models_bot_locale.locale_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Iam.RolePolicyAttachment("test", new()
 *     {
 *         Role = testAwsIamRole.Name,
 *         PolicyArn = $"arn:{current.Partition}:iam::aws:policy/AmazonLexFullAccess",
 *     });
 *     var testV2modelsBot = new Aws.Lex.V2modelsBot("test", new()
 *     {
 *         Name = "testbot",
 *         IdleSessionTtlInSeconds = 60,
 *         RoleArn = testAwsIamRole.Arn,
 *         DataPrivacies = new[]
 *         {
 *             new Aws.Lex.Inputs.V2modelsBotDataPrivacyArgs
 *             {
 *                 ChildDirected = true,
 *             },
 *         },
 *     });
 *     var testV2modelsBotLocale = new Aws.Lex.V2modelsBotLocale("test", new()
 *     {
 *         LocaleId = "en_US",
 *         BotId = testV2modelsBot.Id,
 *         BotVersion = "DRAFT",
 *         NLuIntentConfidenceThreshold = 0.7,
 *     });
 *     var testV2modelsBotVersion = new Aws.Lex.V2modelsBotVersion("test", new()
 *     {
 *         BotId = testV2modelsBot.Id,
 *         LocaleSpecification = testV2modelsBotLocale.LocaleId.Apply(localeId =>
 *         {
 *             { localeId,
 *             {
 *                 { "sourceBotVersion", "DRAFT" },
 *             } },
 *         }),
 *     });
 *     var testV2modelsSlotType = new Aws.Lex.V2modelsSlotType("test", new()
 *     {
 *         BotId = testV2modelsBot.Id,
 *         BotVersion = testV2modelsBotLocale.BotVersion,
 *         Name = "test",
 *         LocaleId = testV2modelsBotLocale.LocaleId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/lex"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iam.NewRolePolicyAttachment(ctx, "test", &iam.RolePolicyAttachmentArgs{
 * Role: pulumi.Any(testAwsIamRole.Name),
 * PolicyArn: pulumi.Sprintf("arn:%v:iam::aws:policy/AmazonLexFullAccess", current.Partition),
 * })
 * if err != nil {
 * return err
 * }
 * testV2modelsBot, err := lex.NewV2modelsBot(ctx, "test", &lex.V2modelsBotArgs{
 * Name: pulumi.String("testbot"),
 * IdleSessionTtlInSeconds: pulumi.Int(60),
 * RoleArn: pulumi.Any(testAwsIamRole.Arn),
 * DataPrivacies: lex.V2modelsBotDataPrivacyArray{
 * &lex.V2modelsBotDataPrivacyArgs{
 * ChildDirected: pulumi.Bool(true),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * testV2modelsBotLocale, err := lex.NewV2modelsBotLocale(ctx, "test", &lex.V2modelsBotLocaleArgs{
 * LocaleId: pulumi.String("en_US"),
 * BotId: testV2modelsBot.ID(),
 * BotVersion: pulumi.String("DRAFT"),
 * NLuIntentConfidenceThreshold: pulumi.Float64(0.7),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = lex.NewV2modelsBotVersion(ctx, "test", &lex.V2modelsBotVersionArgs{
 * BotId: testV2modelsBot.ID(),
 * LocaleSpecification: testV2modelsBotLocale.LocaleId.ApplyT(func(localeId string) (map[string]map[string]interface{}, error) {
 * return map[string]map[string]interface{}{
 * localeId: map[string]interface{}{
 * "sourceBotVersion": "DRAFT",
 * },
 * }, nil
 * }).(pulumi.Map[string]map[string]interface{}Output),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = lex.NewV2modelsSlotType(ctx, "test", &lex.V2modelsSlotTypeArgs{
 * BotId: testV2modelsBot.ID(),
 * BotVersion: testV2modelsBotLocale.BotVersion,
 * Name: pulumi.String("test"),
 * LocaleId: testV2modelsBotLocale.LocaleId,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.lex.V2modelsBot;
 * import com.pulumi.aws.lex.V2modelsBotArgs;
 * import com.pulumi.aws.lex.inputs.V2modelsBotDataPrivacyArgs;
 * import com.pulumi.aws.lex.V2modelsBotLocale;
 * import com.pulumi.aws.lex.V2modelsBotLocaleArgs;
 * import com.pulumi.aws.lex.V2modelsBotVersion;
 * import com.pulumi.aws.lex.V2modelsBotVersionArgs;
 * import com.pulumi.aws.lex.V2modelsSlotType;
 * import com.pulumi.aws.lex.V2modelsSlotTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new RolePolicyAttachment("test", RolePolicyAttachmentArgs.builder()
 *             .role(testAwsIamRole.name())
 *             .policyArn(String.format("arn:%s:iam::aws:policy/AmazonLexFullAccess", current.partition()))
 *             .build());
 *         var testV2modelsBot = new V2modelsBot("testV2modelsBot", V2modelsBotArgs.builder()
 *             .name("testbot")
 *             .idleSessionTtlInSeconds(60)
 *             .roleArn(testAwsIamRole.arn())
 *             .dataPrivacies(V2modelsBotDataPrivacyArgs.builder()
 *                 .childDirected(true)
 *                 .build())
 *             .build());
 *         var testV2modelsBotLocale = new V2modelsBotLocale("testV2modelsBotLocale", V2modelsBotLocaleArgs.builder()
 *             .localeId("en_US")
 *             .botId(testV2modelsBot.id())
 *             .botVersion("DRAFT")
 *             .nLuIntentConfidenceThreshold(0.7)
 *             .build());
 *         var testV2modelsBotVersion = new V2modelsBotVersion("testV2modelsBotVersion", V2modelsBotVersionArgs.builder()
 *             .botId(testV2modelsBot.id())
 *             .localeSpecification(testV2modelsBotLocale.localeId().applyValue(localeId -> Map.of(localeId, Map.of("sourceBotVersion", "DRAFT"))))
 *             .build());
 *         var testV2modelsSlotType = new V2modelsSlotType("testV2modelsSlotType", V2modelsSlotTypeArgs.builder()
 *             .botId(testV2modelsBot.id())
 *             .botVersion(testV2modelsBotLocale.botVersion())
 *             .name("test")
 *             .localeId(testV2modelsBotLocale.localeId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       role: ${testAwsIamRole.name}
 *       policyArn: arn:${current.partition}:iam::aws:policy/AmazonLexFullAccess
 *   testV2modelsBot:
 *     type: aws:lex:V2modelsBot
 *     name: test
 *     properties:
 *       name: testbot
 *       idleSessionTtlInSeconds: 60
 *       roleArn: ${testAwsIamRole.arn}
 *       dataPrivacies:
 *         - childDirected: true
 *   testV2modelsBotLocale:
 *     type: aws:lex:V2modelsBotLocale
 *     name: test
 *     properties:
 *       localeId: en_US
 *       botId: ${testV2modelsBot.id}
 *       botVersion: DRAFT
 *       nLuIntentConfidenceThreshold: 0.7
 *   testV2modelsBotVersion:
 *     type: aws:lex:V2modelsBotVersion
 *     name: test
 *     properties:
 *       botId: ${testV2modelsBot.id}
 *       localeSpecification:
 *         ${testV2modelsBotLocale.localeId}:
 *           sourceBotVersion: DRAFT
 *   testV2modelsSlotType:
 *     type: aws:lex:V2modelsSlotType
 *     name: test
 *     properties:
 *       botId: ${testV2modelsBot.id}
 *       botVersion: ${testV2modelsBotLocale.botVersion}
 *       name: test
 *       localeId: ${testV2modelsBotLocale.localeId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Lex V2 Models Slot Type using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:lex/v2modelsSlotType:V2modelsSlotType example bot-1234,DRAFT,en_US,slot_type-id-12345678
 * ```
 * @property botId Identifier of the bot associated with this slot type.
 * @property botVersion Version of the bot associated with this slot type.
 * @property compositeSlotTypeSetting Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
 * @property description Description of the slot type.
 * @property externalSourceSetting Type of external information used to create the slot type. See `external_source_setting` argument reference below.
 * @property localeId Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
 * @property name Name of the slot type
 * The following arguments are optional:
 * @property parentSlotTypeSignature Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
 * @property slotTypeValues List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
 * @property timeouts
 * @property valueSelectionSetting Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
 */
public data class V2modelsSlotTypeArgs(
    public val botId: Output<String>? = null,
    public val botVersion: Output<String>? = null,
    public val compositeSlotTypeSetting: Output<V2modelsSlotTypeCompositeSlotTypeSettingArgs>? = null,
    public val description: Output<String>? = null,
    public val externalSourceSetting: Output<V2modelsSlotTypeExternalSourceSettingArgs>? = null,
    public val localeId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parentSlotTypeSignature: Output<String>? = null,
    public val slotTypeValues: Output<V2modelsSlotTypeSlotTypeValuesArgs>? = null,
    public val timeouts: Output<V2modelsSlotTypeTimeoutsArgs>? = null,
    public val valueSelectionSetting: Output<V2modelsSlotTypeValueSelectionSettingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.V2modelsSlotTypeArgs> {
    override fun toJava(): com.pulumi.aws.lex.V2modelsSlotTypeArgs =
        com.pulumi.aws.lex.V2modelsSlotTypeArgs.builder()
            .botId(botId?.applyValue({ args0 -> args0 }))
            .botVersion(botVersion?.applyValue({ args0 -> args0 }))
            .compositeSlotTypeSetting(
                compositeSlotTypeSetting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .externalSourceSetting(
                externalSourceSetting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .localeId(localeId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parentSlotTypeSignature(parentSlotTypeSignature?.applyValue({ args0 -> args0 }))
            .slotTypeValues(slotTypeValues?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .valueSelectionSetting(
                valueSelectionSetting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsSlotTypeArgs].
 */
@PulumiTagMarker
public class V2modelsSlotTypeArgsBuilder internal constructor() {
    private var botId: Output<String>? = null

    private var botVersion: Output<String>? = null

    private var compositeSlotTypeSetting: Output<V2modelsSlotTypeCompositeSlotTypeSettingArgs>? = null

    private var description: Output<String>? = null

    private var externalSourceSetting: Output<V2modelsSlotTypeExternalSourceSettingArgs>? = null

    private var localeId: Output<String>? = null

    private var name: Output<String>? = null

    private var parentSlotTypeSignature: Output<String>? = null

    private var slotTypeValues: Output<V2modelsSlotTypeSlotTypeValuesArgs>? = null

    private var timeouts: Output<V2modelsSlotTypeTimeoutsArgs>? = null

    private var valueSelectionSetting: Output<V2modelsSlotTypeValueSelectionSettingArgs>? = null

    /**
     * @param value Identifier of the bot associated with this slot type.
     */
    @JvmName("pyoeuttvvqhkjvwx")
    public suspend fun botId(`value`: Output<String>) {
        this.botId = value
    }

    /**
     * @param value Version of the bot associated with this slot type.
     */
    @JvmName("tffvcpmghqurmpxo")
    public suspend fun botVersion(`value`: Output<String>) {
        this.botVersion = value
    }

    /**
     * @param value Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
     */
    @JvmName("djxphyaoniwceunl")
    public suspend fun compositeSlotTypeSetting(`value`: Output<V2modelsSlotTypeCompositeSlotTypeSettingArgs>) {
        this.compositeSlotTypeSetting = value
    }

    /**
     * @param value Description of the slot type.
     */
    @JvmName("snilfshqvodricln")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Type of external information used to create the slot type. See `external_source_setting` argument reference below.
     */
    @JvmName("hymrbugumisijnlt")
    public suspend fun externalSourceSetting(`value`: Output<V2modelsSlotTypeExternalSourceSettingArgs>) {
        this.externalSourceSetting = value
    }

    /**
     * @param value Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
     */
    @JvmName("dntjxxoofrwpbbgq")
    public suspend fun localeId(`value`: Output<String>) {
        this.localeId = value
    }

    /**
     * @param value Name of the slot type
     * The following arguments are optional:
     */
    @JvmName("fhcakjfsyutcfsdx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
     */
    @JvmName("txnkkaerounbhqip")
    public suspend fun parentSlotTypeSignature(`value`: Output<String>) {
        this.parentSlotTypeSignature = value
    }

    /**
     * @param value List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("ixrluqllhbdpnmlo")
    public suspend fun slotTypeValues(`value`: Output<V2modelsSlotTypeSlotTypeValuesArgs>) {
        this.slotTypeValues = value
    }

    /**
     * @param value
     */
    @JvmName("inqsvbumcchkhjsg")
    public suspend fun timeouts(`value`: Output<V2modelsSlotTypeTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
     */
    @JvmName("gpsbriirpdxvdtmy")
    public suspend fun valueSelectionSetting(`value`: Output<V2modelsSlotTypeValueSelectionSettingArgs>) {
        this.valueSelectionSetting = value
    }

    /**
     * @param value Identifier of the bot associated with this slot type.
     */
    @JvmName("eoijcuupdcxstswl")
    public suspend fun botId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botId = mapped
    }

    /**
     * @param value Version of the bot associated with this slot type.
     */
    @JvmName("qsjctakjqwrdbcsc")
    public suspend fun botVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.botVersion = mapped
    }

    /**
     * @param value Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
     */
    @JvmName("gtnwtkrnvggkylhq")
    public suspend fun compositeSlotTypeSetting(`value`: V2modelsSlotTypeCompositeSlotTypeSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compositeSlotTypeSetting = mapped
    }

    /**
     * @param argument Specifications for a composite slot type. See `composite_slot_type_setting` argument reference below.
     */
    @JvmName("wnscjgsgoadibbhd")
    public suspend fun compositeSlotTypeSetting(argument: suspend V2modelsSlotTypeCompositeSlotTypeSettingArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsSlotTypeCompositeSlotTypeSettingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.compositeSlotTypeSetting = mapped
    }

    /**
     * @param value Description of the slot type.
     */
    @JvmName("imahlavaxpbvmcwr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Type of external information used to create the slot type. See `external_source_setting` argument reference below.
     */
    @JvmName("buvtcquixvcaapco")
    public suspend fun externalSourceSetting(`value`: V2modelsSlotTypeExternalSourceSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalSourceSetting = mapped
    }

    /**
     * @param argument Type of external information used to create the slot type. See `external_source_setting` argument reference below.
     */
    @JvmName("pcemuhcuhksrsyum")
    public suspend fun externalSourceSetting(argument: suspend V2modelsSlotTypeExternalSourceSettingArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsSlotTypeExternalSourceSettingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.externalSourceSetting = mapped
    }

    /**
     * @param value Identifier of the language and locale where this slot type is used. All of the bots, slot types, and slots used by the intent must have the same locale.
     */
    @JvmName("anuederevjwssyfk")
    public suspend fun localeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localeId = mapped
    }

    /**
     * @param value Name of the slot type
     * The following arguments are optional:
     */
    @JvmName("cetjgipcebhynnkc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Built-in slot type used as a parent of this slot type. When you define a parent slot type, the new slot type has the configuration of the parent slot type. Only AMAZON.AlphaNumeric is supported.
     */
    @JvmName("mfpbtpiphvwaplay")
    public suspend fun parentSlotTypeSignature(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentSlotTypeSignature = mapped
    }

    /**
     * @param value List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("cixjwvtcylgrwfai")
    public suspend fun slotTypeValues(`value`: V2modelsSlotTypeSlotTypeValuesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slotTypeValues = mapped
    }

    /**
     * @param argument List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("xvgroacgegaeyvfg")
    public suspend fun slotTypeValues(argument: suspend V2modelsSlotTypeSlotTypeValuesArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsSlotTypeSlotTypeValuesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.slotTypeValues = mapped
    }

    /**
     * @param value
     */
    @JvmName("bymqucddwobeypsk")
    public suspend fun timeouts(`value`: V2modelsSlotTypeTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xirscnawrylnhtpx")
    public suspend fun timeouts(argument: suspend V2modelsSlotTypeTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsSlotTypeTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
     */
    @JvmName("adptutpepriokugw")
    public suspend fun valueSelectionSetting(`value`: V2modelsSlotTypeValueSelectionSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueSelectionSetting = mapped
    }

    /**
     * @param argument Determines the strategy that Amazon Lex uses to select a value from the list of possible values. The field can be set to one of the following values: `ORIGINAL_VALUE` returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` if there is a resolution list for the slot, return the first value in the resolution list. If there is no resolution list, return null. If you don't specify the valueSelectionSetting parameter, the default is ORIGINAL_VALUE. See `value_selection_setting` argument reference below.
     */
    @JvmName("bwkswgyvsrifreth")
    public suspend fun valueSelectionSetting(argument: suspend V2modelsSlotTypeValueSelectionSettingArgsBuilder.() -> Unit) {
        val toBeMapped = V2modelsSlotTypeValueSelectionSettingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.valueSelectionSetting = mapped
    }

    internal fun build(): V2modelsSlotTypeArgs = V2modelsSlotTypeArgs(
        botId = botId,
        botVersion = botVersion,
        compositeSlotTypeSetting = compositeSlotTypeSetting,
        description = description,
        externalSourceSetting = externalSourceSetting,
        localeId = localeId,
        name = name,
        parentSlotTypeSignature = parentSlotTypeSignature,
        slotTypeValues = slotTypeValues,
        timeouts = timeouts,
        valueSelectionSetting = valueSelectionSetting,
    )
}
