@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.BotAbortStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messages
 * @property responseCard
 */
public data class BotAbortStatementArgs(
    public val messages: Output<List<BotAbortStatementMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.BotAbortStatementArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.BotAbortStatementArgs =
        com.pulumi.aws.lex.inputs.BotAbortStatementArgs.builder()
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotAbortStatementArgs].
 */
@PulumiTagMarker
public class BotAbortStatementArgsBuilder internal constructor() {
    private var messages: Output<List<BotAbortStatementMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("vxbdrijixfwbvfpq")
    public suspend fun messages(`value`: Output<List<BotAbortStatementMessageArgs>>) {
        this.messages = value
    }

    @JvmName("myfydtafkgajqvqq")
    public suspend fun messages(vararg values: Output<BotAbortStatementMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pcxmmvwdgatmvjmt")
    public suspend fun messages(values: List<Output<BotAbortStatementMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("nhnajuhqgjdevnhl")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value
     */
    @JvmName("ufeflscrubqdawwe")
    public suspend fun messages(`value`: List<BotAbortStatementMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wyjousnxrwookonw")
    public suspend fun messages(argument: List<suspend BotAbortStatementMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BotAbortStatementMessageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mkdsdjqnfjixpcmj")
    public suspend fun messages(vararg argument: suspend BotAbortStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BotAbortStatementMessageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vwfgvhdmecvukvoc")
    public suspend fun messages(argument: suspend BotAbortStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BotAbortStatementMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values
     */
    @JvmName("nrmqcuastvaikchs")
    public suspend fun messages(vararg values: BotAbortStatementMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value
     */
    @JvmName("nuqnhuwkosrhrkfe")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): BotAbortStatementArgs = BotAbortStatementArgs(
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
