@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.BotAbortStatementMessageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The text of the message.
 * @property contentType The content type of the message string.
 * @property groupNumber Identifies the message group that the message belongs to. When a group
 * is assigned to a message, Amazon Lex returns one message from each group in the response.
 */
public data class BotAbortStatementMessageArgs(
    public val content: Output<String>,
    public val contentType: Output<String>,
    public val groupNumber: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.BotAbortStatementMessageArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.BotAbortStatementMessageArgs =
        com.pulumi.aws.lex.inputs.BotAbortStatementMessageArgs.builder()
            .content(content.applyValue({ args0 -> args0 }))
            .contentType(contentType.applyValue({ args0 -> args0 }))
            .groupNumber(groupNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotAbortStatementMessageArgs].
 */
@PulumiTagMarker
public class BotAbortStatementMessageArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var contentType: Output<String>? = null

    private var groupNumber: Output<Int>? = null

    /**
     * @param value The text of the message.
     */
    @JvmName("slqdaqengpkksdwm")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The content type of the message string.
     */
    @JvmName("axdqldlgtflqyxmf")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Identifies the message group that the message belongs to. When a group
     * is assigned to a message, Amazon Lex returns one message from each group in the response.
     */
    @JvmName("hdixyreexetwhcda")
    public suspend fun groupNumber(`value`: Output<Int>) {
        this.groupNumber = value
    }

    /**
     * @param value The text of the message.
     */
    @JvmName("smvpgywfanyqlasa")
    public suspend fun content(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The content type of the message string.
     */
    @JvmName("hjbetwjrgcrodpkg")
    public suspend fun contentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Identifies the message group that the message belongs to. When a group
     * is assigned to a message, Amazon Lex returns one message from each group in the response.
     */
    @JvmName("kpcsoxfppouiliuk")
    public suspend fun groupNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupNumber = mapped
    }

    internal fun build(): BotAbortStatementMessageArgs = BotAbortStatementMessageArgs(
        content = content ?: throw PulumiNullFieldException("content"),
        contentType = contentType ?: throw PulumiNullFieldException("contentType"),
        groupNumber = groupNumber,
    )
}
