@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.BotAliasConversationLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property iamRoleArn The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3 bucket. Must be between 20 and 2048 characters in length.
 * @property logSettings The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
 */
public data class BotAliasConversationLogsArgs(
    public val iamRoleArn: Output<String>,
    public val logSettings: Output<List<BotAliasConversationLogsLogSettingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.BotAliasConversationLogsArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.BotAliasConversationLogsArgs =
        com.pulumi.aws.lex.inputs.BotAliasConversationLogsArgs.builder()
            .iamRoleArn(iamRoleArn.applyValue({ args0 -> args0 }))
            .logSettings(
                logSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BotAliasConversationLogsArgs].
 */
@PulumiTagMarker
public class BotAliasConversationLogsArgsBuilder internal constructor() {
    private var iamRoleArn: Output<String>? = null

    private var logSettings: Output<List<BotAliasConversationLogsLogSettingArgs>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3 bucket. Must be between 20 and 2048 characters in length.
     */
    @JvmName("tyokgawdyaqnonbo")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
     */
    @JvmName("kfkujaeedikncrno")
    public suspend fun logSettings(`value`: Output<List<BotAliasConversationLogsLogSettingArgs>>) {
        this.logSettings = value
    }

    @JvmName("lypobgvhtejclwhe")
    public suspend fun logSettings(vararg values: Output<BotAliasConversationLogsLogSettingArgs>) {
        this.logSettings = Output.all(values.asList())
    }

    /**
     * @param values The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
     */
    @JvmName("esjlenshortcfwyx")
    public suspend fun logSettings(values: List<Output<BotAliasConversationLogsLogSettingArgs>>) {
        this.logSettings = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3 bucket. Must be between 20 and 2048 characters in length.
     */
    @JvmName("gnqqyxtmctcrtefg")
    public suspend fun iamRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
     */
    @JvmName("trikpufwrvygshwk")
    public suspend fun logSettings(`value`: List<BotAliasConversationLogsLogSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logSettings = mapped
    }

    /**
     * @param argument The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
     */
    @JvmName("vgijmagwdmurayen")
    public suspend fun logSettings(argument: List<suspend BotAliasConversationLogsLogSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BotAliasConversationLogsLogSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logSettings = mapped
    }

    /**
     * @param argument The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
     */
    @JvmName("bmqiyriocabobrml")
    public suspend fun logSettings(vararg argument: suspend BotAliasConversationLogsLogSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BotAliasConversationLogsLogSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logSettings = mapped
    }

    /**
     * @param argument The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
     */
    @JvmName("lqsdyotghshwgmvj")
    public suspend fun logSettings(argument: suspend BotAliasConversationLogsLogSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BotAliasConversationLogsLogSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logSettings = mapped
    }

    /**
     * @param values The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
     */
    @JvmName("exthoiubeculudje")
    public suspend fun logSettings(vararg values: BotAliasConversationLogsLogSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logSettings = mapped
    }

    internal fun build(): BotAliasConversationLogsArgs = BotAliasConversationLogsArgs(
        iamRoleArn = iamRoleArn ?: throw PulumiNullFieldException("iamRoleArn"),
        logSettings = logSettings,
    )
}
