@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.BotClarificationPromptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property maxAttempts The number of times to prompt the user for information.
 * @property messages
 * @property responseCard
 */
public data class BotClarificationPromptArgs(
    public val maxAttempts: Output<Int>,
    public val messages: Output<List<BotClarificationPromptMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.BotClarificationPromptArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.BotClarificationPromptArgs =
        com.pulumi.aws.lex.inputs.BotClarificationPromptArgs.builder()
            .maxAttempts(maxAttempts.applyValue({ args0 -> args0 }))
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotClarificationPromptArgs].
 */
@PulumiTagMarker
public class BotClarificationPromptArgsBuilder internal constructor() {
    private var maxAttempts: Output<Int>? = null

    private var messages: Output<List<BotClarificationPromptMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value The number of times to prompt the user for information.
     */
    @JvmName("uagmsfkmikkugqgi")
    public suspend fun maxAttempts(`value`: Output<Int>) {
        this.maxAttempts = value
    }

    /**
     * @param value
     */
    @JvmName("sqouajcjckehxinl")
    public suspend fun messages(`value`: Output<List<BotClarificationPromptMessageArgs>>) {
        this.messages = value
    }

    @JvmName("wniknwmcrllfomqu")
    public suspend fun messages(vararg values: Output<BotClarificationPromptMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qthmqeotftqcndbb")
    public suspend fun messages(values: List<Output<BotClarificationPromptMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qjtrkiwmjynotukt")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value The number of times to prompt the user for information.
     */
    @JvmName("yrnqqynlcweibpug")
    public suspend fun maxAttempts(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxAttempts = mapped
    }

    /**
     * @param value
     */
    @JvmName("mmobvhofxcwixepq")
    public suspend fun messages(`value`: List<BotClarificationPromptMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("obgefhppvdiyrdrb")
    public suspend fun messages(argument: List<suspend BotClarificationPromptMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BotClarificationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fummgfrycqotqhmu")
    public suspend fun messages(vararg argument: suspend BotClarificationPromptMessageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BotClarificationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fujqaygtxqvfyhwv")
    public suspend fun messages(argument: suspend BotClarificationPromptMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BotClarificationPromptMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values
     */
    @JvmName("cqyonbxnlgqltgsw")
    public suspend fun messages(vararg values: BotClarificationPromptMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value
     */
    @JvmName("ecclkuptrarsioam")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): BotClarificationPromptArgs = BotClarificationPromptArgs(
        maxAttempts = maxAttempts ?: throw PulumiNullFieldException("maxAttempts"),
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
