@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.BotIntentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property intentName The name of the intent. Must be less than or equal to 100 characters in length.
 * @property intentVersion The version of the intent. Must be less than or equal to 64 characters in length.
 */
public data class BotIntentArgs(
    public val intentName: Output<String>,
    public val intentVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.BotIntentArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.BotIntentArgs =
        com.pulumi.aws.lex.inputs.BotIntentArgs.builder()
            .intentName(intentName.applyValue({ args0 -> args0 }))
            .intentVersion(intentVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotIntentArgs].
 */
@PulumiTagMarker
public class BotIntentArgsBuilder internal constructor() {
    private var intentName: Output<String>? = null

    private var intentVersion: Output<String>? = null

    /**
     * @param value The name of the intent. Must be less than or equal to 100 characters in length.
     */
    @JvmName("tchphitfnmmansgl")
    public suspend fun intentName(`value`: Output<String>) {
        this.intentName = value
    }

    /**
     * @param value The version of the intent. Must be less than or equal to 64 characters in length.
     */
    @JvmName("scquepfvnhlujcem")
    public suspend fun intentVersion(`value`: Output<String>) {
        this.intentVersion = value
    }

    /**
     * @param value The name of the intent. Must be less than or equal to 100 characters in length.
     */
    @JvmName("upqtufutcafjayoo")
    public suspend fun intentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.intentName = mapped
    }

    /**
     * @param value The version of the intent. Must be less than or equal to 64 characters in length.
     */
    @JvmName("mejgxwhpndyqodxo")
    public suspend fun intentVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.intentVersion = mapped
    }

    internal fun build(): BotIntentArgs = BotIntentArgs(
        intentName = intentName ?: throw PulumiNullFieldException("intentName"),
        intentVersion = intentVersion ?: throw PulumiNullFieldException("intentVersion"),
    )
}
