@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.GetBotAliasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBotAlias.
 * @property botName Name of the bot.
 * @property name Name of the bot alias. The name is case sensitive.
 */
public data class GetBotAliasPlainArgs(
    public val botName: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.GetBotAliasPlainArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.GetBotAliasPlainArgs =
        com.pulumi.aws.lex.inputs.GetBotAliasPlainArgs.builder()
            .botName(botName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBotAliasPlainArgs].
 */
@PulumiTagMarker
public class GetBotAliasPlainArgsBuilder internal constructor() {
    private var botName: String? = null

    private var name: String? = null

    /**
     * @param value Name of the bot.
     */
    @JvmName("xqeethnxihvolhte")
    public suspend fun botName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.botName = mapped
    }

    /**
     * @param value Name of the bot alias. The name is case sensitive.
     */
    @JvmName("ftmbipoxpxkdlpth")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetBotAliasPlainArgs = GetBotAliasPlainArgs(
        botName = botName ?: throw PulumiNullFieldException("botName"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
