@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.GetIntentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIntent.
 * @property name Name of the intent. The name is case sensitive.
 * @property version Version of the intent.
 */
public data class GetIntentPlainArgs(
    public val name: String,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.GetIntentPlainArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.GetIntentPlainArgs =
        com.pulumi.aws.lex.inputs.GetIntentPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntentPlainArgs].
 */
@PulumiTagMarker
public class GetIntentPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var version: String? = null

    /**
     * @param value Name of the intent. The name is case sensitive.
     */
    @JvmName("rgdrlfldpdhmmuwa")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Version of the intent.
     */
    @JvmName("ernwpmbuqsdirhvj")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetIntentPlainArgs = GetIntentPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        version = version,
    )
}
