@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentConclusionStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messages
 * @property responseCard
 */
public data class IntentConclusionStatementArgs(
    public val messages: Output<List<IntentConclusionStatementMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentConclusionStatementArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentConclusionStatementArgs =
        com.pulumi.aws.lex.inputs.IntentConclusionStatementArgs.builder()
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentConclusionStatementArgs].
 */
@PulumiTagMarker
public class IntentConclusionStatementArgsBuilder internal constructor() {
    private var messages: Output<List<IntentConclusionStatementMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("viafqbqasnhqcpiq")
    public suspend fun messages(`value`: Output<List<IntentConclusionStatementMessageArgs>>) {
        this.messages = value
    }

    @JvmName("vshkqfgcxiwkqwyw")
    public suspend fun messages(vararg values: Output<IntentConclusionStatementMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pluxyltbmcxaymep")
    public suspend fun messages(values: List<Output<IntentConclusionStatementMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kqrjdolyfysbryae")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value
     */
    @JvmName("tdtxwcqqnwdvqjxy")
    public suspend fun messages(`value`: List<IntentConclusionStatementMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oqhkqlyyvctxbyrs")
    public suspend fun messages(argument: List<suspend IntentConclusionStatementMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntentConclusionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("heweatsigltideqd")
    public suspend fun messages(vararg argument: suspend IntentConclusionStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IntentConclusionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("scudojcvyvaknfhd")
    public suspend fun messages(argument: suspend IntentConclusionStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntentConclusionStatementMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values
     */
    @JvmName("dlfexvunwnucmyyc")
    public suspend fun messages(vararg values: IntentConclusionStatementMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value
     */
    @JvmName("lmpdneoskpliwlfa")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): IntentConclusionStatementArgs = IntentConclusionStatementArgs(
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
