@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentFollowUpPromptRejectionStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messages
 * @property responseCard
 */
public data class IntentFollowUpPromptRejectionStatementArgs(
    public val messages: Output<List<IntentFollowUpPromptRejectionStatementMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentFollowUpPromptRejectionStatementArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentFollowUpPromptRejectionStatementArgs =
        com.pulumi.aws.lex.inputs.IntentFollowUpPromptRejectionStatementArgs.builder()
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentFollowUpPromptRejectionStatementArgs].
 */
@PulumiTagMarker
public class IntentFollowUpPromptRejectionStatementArgsBuilder internal constructor() {
    private var messages: Output<List<IntentFollowUpPromptRejectionStatementMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("sapdjnwwdfbjvjqw")
    public suspend fun messages(`value`: Output<List<IntentFollowUpPromptRejectionStatementMessageArgs>>) {
        this.messages = value
    }

    @JvmName("jshcdpncmptdpqts")
    public suspend fun messages(vararg values: Output<IntentFollowUpPromptRejectionStatementMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ggbbsamtpmjblfid")
    public suspend fun messages(values: List<Output<IntentFollowUpPromptRejectionStatementMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kbdkuwserynmcpue")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value
     */
    @JvmName("idahluqvchgxarmi")
    public suspend fun messages(`value`: List<IntentFollowUpPromptRejectionStatementMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qmexwkpfvvfmfxce")
    public suspend fun messages(argument: List<suspend IntentFollowUpPromptRejectionStatementMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntentFollowUpPromptRejectionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xrdvmudpddgugkei")
    public suspend fun messages(vararg argument: suspend IntentFollowUpPromptRejectionStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IntentFollowUpPromptRejectionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cgntmuklgjsfmlgb")
    public suspend fun messages(argument: suspend IntentFollowUpPromptRejectionStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntentFollowUpPromptRejectionStatementMessageArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values
     */
    @JvmName("vmsmbkjydkakkgfk")
    public suspend fun messages(vararg values: IntentFollowUpPromptRejectionStatementMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value
     */
    @JvmName("sxtggnncuotfuixf")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): IntentFollowUpPromptRejectionStatementArgs =
        IntentFollowUpPromptRejectionStatementArgs(
            messages = messages ?: throw PulumiNullFieldException("messages"),
            responseCard = responseCard,
        )
}
