@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messages
 * @property responseCard
 */
public data class IntentRejectionStatementArgs(
    public val messages: Output<List<IntentRejectionStatementMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs =
        com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs.builder()
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentRejectionStatementArgs].
 */
@PulumiTagMarker
public class IntentRejectionStatementArgsBuilder internal constructor() {
    private var messages: Output<List<IntentRejectionStatementMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ajvxvtvhnwdyuqca")
    public suspend fun messages(`value`: Output<List<IntentRejectionStatementMessageArgs>>) {
        this.messages = value
    }

    @JvmName("dsgrxkkubtcoxjbr")
    public suspend fun messages(vararg values: Output<IntentRejectionStatementMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("wgqcyuojnnwarnta")
    public suspend fun messages(values: List<Output<IntentRejectionStatementMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("vhlmhnkdyrotxpqb")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value
     */
    @JvmName("vxilfanyxpumurmg")
    public suspend fun messages(`value`: List<IntentRejectionStatementMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gmosqkdnkgtkvstl")
    public suspend fun messages(argument: List<suspend IntentRejectionStatementMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntentRejectionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("orirncwthmlovfmu")
    public suspend fun messages(vararg argument: suspend IntentRejectionStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IntentRejectionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rldjfhtneomvkveb")
    public suspend fun messages(argument: suspend IntentRejectionStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntentRejectionStatementMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values
     */
    @JvmName("iyebqxaheahgdods")
    public suspend fun messages(vararg values: IntentRejectionStatementMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value
     */
    @JvmName("uvghrwfptcemsqqq")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): IntentRejectionStatementArgs = IntentRejectionStatementArgs(
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
